/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboard.user;

import be.maximvdw.featherboardcore.p.a.a;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

@Entity
@Table(name="players")
public class FBPlayerData {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id", unique=true)
    private int id = 0;
    @Column(name="player")
    private String player = "";
    @Column(name="toggled")
    private boolean toggled = true;
    private List<String> override = new ArrayList<String>();
    @Column(name="uuidSupport")
    private boolean uuidSupport = true;
    @Transient
    private boolean dirty = false;
    @Transient
    private boolean startup = true;

    public FBPlayerData() {
    }

    public FBPlayerData(OfflinePlayer offlinePlayer) {
        this();
        if (a.c()) {
            this.setUuidSupport(true);
            this.setPlayer(offlinePlayer.getUniqueId().toString());
        } else {
            this.setPlayer(offlinePlayer.getName());
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n2) {
        this.id = n2;
    }

    public String getPlayer() {
        return this.player;
    }

    public void setPlayer(String string) {
        this.player = string;
    }

    public boolean isUuidSupport() {
        return this.uuidSupport;
    }

    public void setUuidSupport(boolean bl2) {
        this.uuidSupport = bl2;
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void setToggled(boolean bl2) {
        this.toggled = bl2;
        this.dirty = true;
    }

    public List<String> getOverride() {
        return this.override;
    }

    public void setOverride(List<String> list) {
        this.override = list;
        this.dirty = true;
    }

    public void addOverride(String string) {
        if (!this.override.contains(string)) {
            this.override.add(string);
        }
        this.dirty = true;
    }

    public void removeOverride(String string) {
        if (this.override.contains(string)) {
            this.override.remove(string);
        }
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl2) {
        this.dirty = bl2;
    }

    public OfflinePlayer getOfflinePlayer() {
        if (this.isUuidSupport()) {
            return Bukkit.getOfflinePlayer((UUID)UUID.fromString(this.getPlayer()));
        }
        return Bukkit.getOfflinePlayer((String)this.getPlayer());
    }

    public boolean isStartup() {
        return this.startup;
    }

    public void setStartup(boolean bl2) {
        this.startup = bl2;
    }
}

