/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.providers;

import java.util.Iterator;
import java.util.logging.Logger;
import net.ess3.providers.Provider;

public class ProviderFactory<T extends Provider> {
    private Logger logger;
    private String providerType;
    private Iterable<Class<? extends T>> availableProviders;

    public ProviderFactory(Logger logger, Iterable<Class<? extends T>> availableProviders, String providerType) {
        this.logger = logger;
        this.providerType = providerType;
        this.availableProviders = availableProviders;
    }

    public T getProvider() {
        Class<? extends T> providerClass;
        Provider finalProvider = null;
        Iterator<Class<T>> iterator = this.availableProviders.iterator();
        while (iterator.hasNext() && ((finalProvider = (Provider)this.loadProvider(providerClass = iterator.next())) == null || !finalProvider.tryProvider())) {
        }
        assert (finalProvider != null);
        this.logger.info("Using " + finalProvider.getHumanName() + " as " + this.providerType + " provider.");
        return (T)finalProvider;
    }

    private T loadProvider(Class<? extends T> providerClass) {
        try {
            return (T)((Provider)providerClass.newInstance());
        }
        catch (Throwable ignored) {
            return null;
        }
    }
}

