/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.nms.updatedmeta;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.ess3.nms.PotionMetaProvider;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class BasePotionDataProvider
extends PotionMetaProvider {
    private static Map<Integer, PotionType> damageValueToType = ImmutableMap.builder().put((Object)1, (Object)PotionType.REGEN).put((Object)2, (Object)PotionType.SPEED).put((Object)3, (Object)PotionType.FIRE_RESISTANCE).put((Object)4, (Object)PotionType.POISON).put((Object)5, (Object)PotionType.INSTANT_HEAL).put((Object)6, (Object)PotionType.NIGHT_VISION).put((Object)8, (Object)PotionType.WEAKNESS).put((Object)9, (Object)PotionType.STRENGTH).put((Object)10, (Object)PotionType.SLOWNESS).put((Object)11, (Object)PotionType.JUMP).put((Object)12, (Object)PotionType.INSTANT_DAMAGE).put((Object)13, (Object)PotionType.WATER_BREATHING).put((Object)14, (Object)PotionType.INVISIBILITY).build();

    @Override
    public ItemStack createPotionItem(Material initial, int effectId) throws IllegalArgumentException {
        boolean splash;
        ItemStack potion = new ItemStack(initial, 1);
        if (effectId == 0) {
            return potion;
        }
        int damageValue = BasePotionDataProvider.getBit(effectId, 0) + 2 * BasePotionDataProvider.getBit(effectId, 1) + 4 * BasePotionDataProvider.getBit(effectId, 2) + 8 * BasePotionDataProvider.getBit(effectId, 3);
        PotionType type = damageValueToType.get(damageValue);
        if (type == null) {
            throw new IllegalArgumentException("Unable to process potion effect ID " + effectId + " with damage value " + damageValue);
        }
        boolean extended = BasePotionDataProvider.getBit(effectId, 6) == 1;
        boolean upgraded = BasePotionDataProvider.getBit(effectId, 5) == 1;
        boolean bl = splash = BasePotionDataProvider.getBit(effectId, 14) == 1;
        if (splash && initial == Material.POTION) {
            potion = new ItemStack(Material.SPLASH_POTION, 1);
        }
        PotionMeta meta = (PotionMeta)potion.getItemMeta();
        PotionData data = new PotionData(type, extended, upgraded);
        meta.setBasePotionData(data);
        potion.setItemMeta((ItemMeta)meta);
        return potion;
    }

    private static int getBit(int n, int k) {
        return n >> k & 1;
    }

    @Override
    public String getHumanName() {
        return "1.9+ BasePotionData provider";
    }
}

