/*
 * Decompiled with CFR 0.152.
 */
package net.ess3.nms.refl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;

public class ReflUtil {
    private static String nmsVersion;
    private static Map<String, Class<?>> classCache;
    private static Table<Class<?>, String, Method> methodCache;
    private static Table<Class<?>, MethodParams, Method> methodParamCache;
    private static Table<Class<?>, String, Field> fieldCache;
    private static Map<Class<?>, Constructor<?>> constructorCache;
    private static Table<Class<?>, ConstructorParams, Constructor<?>> constructorParamCache;

    public static String getNMSVersion() {
        if (nmsVersion == null) {
            String name = Bukkit.getServer().getClass().getName();
            String[] parts = name.split("\\.");
            nmsVersion = parts[3];
        }
        return nmsVersion;
    }

    public static Class<?> getNMSClass(String className) {
        return ReflUtil.getClassCached("net.minecraft.server." + ReflUtil.getNMSVersion() + "." + className);
    }

    public static Class<?> getOBCClass(String className) {
        return ReflUtil.getClassCached("org.bukkit.craftbukkit." + ReflUtil.getNMSVersion() + "." + className);
    }

    public static Class<?> getClassCached(String className) {
        if (classCache.containsKey(className)) {
            return classCache.get(className);
        }
        try {
            Class<?> classForName = Class.forName(className);
            classCache.put(className, classForName);
            return classForName;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static Method getMethodCached(Class<?> clazz, String methodName) {
        if (methodCache.contains(clazz, (Object)methodName)) {
            return (Method)methodCache.get(clazz, (Object)methodName);
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            methodCache.put(clazz, (Object)methodName, (Object)method);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Method getMethodCached(Class<?> clazz, String methodName, Class<?> ... params) {
        MethodParams methodParams = new MethodParams(methodName, params);
        if (methodParamCache.contains(clazz, (Object)methodParams)) {
            return (Method)methodParamCache.get(clazz, (Object)methodParams);
        }
        try {
            Method method = clazz.getDeclaredMethod(methodName, params);
            method.setAccessible(true);
            methodParamCache.put(clazz, (Object)methodParams, (Object)method);
            return method;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Field getFieldCached(Class<?> clazz, String fieldName) {
        if (fieldCache.contains(clazz, (Object)fieldName)) {
            return (Field)fieldCache.get(clazz, (Object)fieldName);
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            fieldCache.put(clazz, (Object)fieldName, (Object)field);
            return field;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    public static Constructor<?> getConstructorCached(Class<?> clazz) {
        if (constructorCache.containsKey(clazz)) {
            return constructorCache.get(clazz);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            constructorCache.put(clazz, constructor);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Constructor<?> getConstructorCached(Class<?> clazz, Class<?> ... params) {
        ConstructorParams constructorParams = new ConstructorParams(params);
        if (constructorParamCache.contains(clazz, (Object)constructorParams)) {
            return (Constructor)constructorParamCache.get(clazz, (Object)constructorParams);
        }
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(params);
            constructor.setAccessible(true);
            constructorParamCache.put(clazz, (Object)constructorParams, constructor);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    static {
        classCache = new HashMap();
        methodCache = HashBasedTable.create();
        methodParamCache = HashBasedTable.create();
        fieldCache = HashBasedTable.create();
        constructorCache = new HashMap();
        constructorParamCache = HashBasedTable.create();
    }

    private static class ConstructorParams {
        private final Class<?>[] params;

        public ConstructorParams(Class<?>[] params) {
            this.params = params;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstructorParams that = (ConstructorParams)o;
            return Arrays.deepEquals(this.params, that.params);
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.params);
        }
    }

    private static class MethodParams {
        private final String name;
        private final Class<?>[] params;

        public MethodParams(String name, Class<?>[] params) {
            this.name = name;
            this.params = params;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodParams)) {
                return false;
            }
            MethodParams that = (MethodParams)o;
            if (!that.canEqual(this)) {
                return false;
            }
            String thisName = this.name;
            String thatName = that.name;
            if (thisName == null ? thatName == null : thisName.equals(thatName)) {
                return Arrays.deepEquals(this.params, that.params);
            }
            return false;
        }

        boolean canEqual(Object that) {
            return that instanceof MethodParams;
        }

        public int hashCode() {
            int result = 1;
            String thisName = this.name;
            result = result * 31 + (thisName == null ? 0 : thisName.hashCode());
            result = result * 31 + Arrays.deepHashCode(this.params);
            return result;
        }
    }
}

