/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.utils;

import com.earth2me.essentials.I18n;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import net.ess3.api.IEssentials;

public class NumberUtil {
    static DecimalFormat twoDPlaces = new DecimalFormat("#,###.##");
    static DecimalFormat currencyFormat = new DecimalFormat("#0.00", DecimalFormatSymbols.getInstance(Locale.US));
    static final NumberFormat PRETTY_FORMAT = NumberFormat.getInstance(Locale.US);

    public static String shortCurrency(BigDecimal value, IEssentials ess) {
        return ess.getSettings().getCurrencySymbol() + NumberUtil.formatAsCurrency(value);
    }

    public static String formatDouble(double value) {
        return twoDPlaces.format(value);
    }

    public static String formatAsCurrency(BigDecimal value) {
        String str = currencyFormat.format(value);
        if (str.endsWith(".00")) {
            str = str.substring(0, str.length() - 3);
        }
        return str;
    }

    public static String formatAsPrettyCurrency(BigDecimal value) {
        String str = PRETTY_FORMAT.format(value);
        if (str.endsWith(".00")) {
            str = str.substring(0, str.length() - 3);
        }
        return str;
    }

    public static String displayCurrency(BigDecimal value, IEssentials ess) {
        return I18n.tl("currency", ess.getSettings().getCurrencySymbol(), NumberUtil.formatAsPrettyCurrency(value));
    }

    public static String displayCurrencyExactly(BigDecimal value, IEssentials ess) {
        return I18n.tl("currency", ess.getSettings().getCurrencySymbol(), value.toPlainString());
    }

    public static boolean isInt(String sInt) {
        try {
            Integer.parseInt(sInt);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    static {
        twoDPlaces.setRoundingMode(RoundingMode.HALF_UP);
        currencyFormat.setRoundingMode(RoundingMode.FLOOR);
        PRETTY_FORMAT.setRoundingMode(RoundingMode.FLOOR);
        PRETTY_FORMAT.setGroupingUsed(true);
        PRETTY_FORMAT.setMinimumFractionDigits(2);
        PRETTY_FORMAT.setMaximumFractionDigits(2);
    }
}

