/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.messaging;

import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.IEssentials;
import com.earth2me.essentials.IUser;
import com.earth2me.essentials.User;
import com.earth2me.essentials.messaging.IMessageRecipient;
import java.lang.ref.WeakReference;

public class SimpleMessageRecipient
implements IMessageRecipient {
    private final IEssentials ess;
    private final IMessageRecipient parent;
    private long lastMessageMs;
    private WeakReference<IMessageRecipient> replyRecipient;

    public SimpleMessageRecipient(IEssentials ess, IMessageRecipient parent) {
        this.ess = ess;
        this.parent = parent;
    }

    @Override
    public void sendMessage(String message) {
        this.parent.sendMessage(message);
    }

    @Override
    public String getName() {
        return this.parent.getName();
    }

    @Override
    public String getDisplayName() {
        return this.parent.getDisplayName();
    }

    @Override
    public IMessageRecipient.MessageResponse sendMessage(IMessageRecipient recipient, String message) {
        IMessageRecipient.MessageResponse messageResponse = recipient.onReceiveMessage(this.parent, message);
        switch (messageResponse) {
            case UNREACHABLE: {
                this.sendMessage(I18n.tl("recentlyForeverAlone", recipient.getDisplayName()));
                break;
            }
            case MESSAGES_IGNORED: {
                this.sendMessage(I18n.tl("msgIgnore", recipient.getDisplayName()));
                break;
            }
            case SENDER_IGNORED: {
                break;
            }
            case SUCCESS_BUT_AFK: {
                this.sendMessage(I18n.tl("userAFK", recipient.getDisplayName()));
            }
            default: {
                this.sendMessage(I18n.tl("msgFormat", I18n.tl("me", new Object[0]), recipient.getDisplayName(), message));
            }
        }
        if (messageResponse.isSuccess()) {
            this.setReplyRecipient(recipient);
        }
        return messageResponse;
    }

    @Override
    public IMessageRecipient.MessageResponse onReceiveMessage(IMessageRecipient sender, String message) {
        if (!this.isReachable()) {
            return IMessageRecipient.MessageResponse.UNREACHABLE;
        }
        User user = this.parent instanceof User ? (User)this.parent : null;
        boolean afk = false;
        if (user != null) {
            if (user.isIgnoreMsg() && !(sender instanceof Console)) {
                return IMessageRecipient.MessageResponse.MESSAGES_IGNORED;
            }
            afk = user.isAfk();
            if (sender instanceof IUser && user.isIgnoredPlayer((IUser)((Object)sender))) {
                return IMessageRecipient.MessageResponse.SENDER_IGNORED;
            }
        }
        this.sendMessage(I18n.tl("msgFormat", sender.getDisplayName(), I18n.tl("me", new Object[0]), message));
        if (this.ess.getSettings().isLastMessageReplyRecipient()) {
            long timeout = this.ess.getSettings().getLastMessageReplyRecipientTimeout() * 1000L;
            if (this.getReplyRecipient() == null || !this.getReplyRecipient().isReachable() || System.currentTimeMillis() - this.lastMessageMs > timeout) {
                this.setReplyRecipient(sender);
            }
        } else {
            this.setReplyRecipient(sender);
        }
        this.lastMessageMs = System.currentTimeMillis();
        return afk ? IMessageRecipient.MessageResponse.SUCCESS_BUT_AFK : IMessageRecipient.MessageResponse.SUCCESS;
    }

    @Override
    public boolean isReachable() {
        return this.parent.isReachable();
    }

    @Override
    public IMessageRecipient getReplyRecipient() {
        return this.replyRecipient == null ? null : (IMessageRecipient)this.replyRecipient.get();
    }

    @Override
    public void setReplyRecipient(IMessageRecipient replyRecipient) {
        this.replyRecipient = new WeakReference<IMessageRecipient>(replyRecipient);
    }
}

