/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.NumberUtil;
import java.math.BigDecimal;
import net.ess3.api.MaxMoneyException;
import org.bukkit.Server;

public class Commandpay
extends EssentialsLoopCommand {
    BigDecimal amount;

    public Commandpay() {
        super("pay");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException();
        }
        String stringAmount = args[1].replaceAll("[^0-9\\.]", "");
        if (stringAmount.length() < 1) {
            throw new NotEnoughArgumentsException();
        }
        this.amount = new BigDecimal(stringAmount);
        if (this.amount.compareTo(this.ess.getSettings().getMinimumPayAmount()) < 0) {
            throw new Exception(I18n.tl("minimumPayAmount", NumberUtil.displayCurrencyExactly(this.ess.getSettings().getMinimumPayAmount(), this.ess)));
        }
        this.loopOnlinePlayers(server, user.getSource(), false, user.isAuthorized("essentials.pay.multiple"), args[0], args);
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User player, String[] args) throws ChargeException {
        User user = this.ess.getUser(sender.getPlayer());
        try {
            user.payUser(player, this.amount);
            Trade.log("Command", "Pay", "Player", user.getName(), new Trade(this.amount, this.ess), player.getName(), new Trade(this.amount, this.ess), user.getLocation(), this.ess);
        }
        catch (MaxMoneyException ex) {
            sender.sendMessage(I18n.tl("maxMoney", new Object[0]));
            try {
                user.setMoney(user.getMoney().add(this.amount));
            }
            catch (MaxMoneyException maxMoneyException) {
                // empty catch block
            }
        }
    }
}

