/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.Console;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsLoopCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.utils.FormatUtil;
import org.bukkit.Server;

public class Commandmsg
extends EssentialsLoopCommand {
    public Commandmsg() {
        super("msg");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        boolean canWildcard;
        if (args.length < 2 || args[0].trim().length() < 2 || args[1].trim().isEmpty()) {
            throw new NotEnoughArgumentsException();
        }
        String message = Commandmsg.getFinalArg(args, 1);
        if (sender.isPlayer()) {
            User user = this.ess.getUser(sender.getPlayer());
            if (user.isMuted()) {
                throw new Exception(I18n.tl("voiceSilenced", new Object[0]));
            }
            message = FormatUtil.formatMessage(user, "essentials.msg", message);
            canWildcard = user.isAuthorized("essentials.msg.multiple");
        } else {
            message = FormatUtil.replaceFormat(message);
            canWildcard = true;
        }
        if (args[0].equalsIgnoreCase("Console")) {
            Console messageSender = sender.isPlayer() ? this.ess.getUser(sender.getPlayer()) : Console.getInstance();
            messageSender.sendMessage(Console.getInstance(), message);
            return;
        }
        this.loopOnlinePlayers(server, sender, canWildcard, canWildcard, args[0], new String[]{message});
    }

    @Override
    protected void updatePlayer(Server server, CommandSource sender, User messageReceiver, String[] args) {
        Console messageSender = sender.isPlayer() ? this.ess.getUser(sender.getPlayer()) : Console.getInstance();
        messageSender.sendMessage(messageReceiver, args[0]);
    }
}

