/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.textreader.IText;
import com.earth2me.essentials.textreader.KeywordReplacer;
import com.earth2me.essentials.textreader.SimpleTextInput;
import com.earth2me.essentials.utils.FormatUtil;
import java.util.Collection;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commandbroadcastworld
extends EssentialsCommand {
    public Commandbroadcastworld() {
        super("broadcastworld");
    }

    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        this.sendBroadcast(user.getWorld().getName(), user.getDisplayName(), Commandbroadcastworld.getFinalArg(args, 0));
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 2) {
            throw new NotEnoughArgumentsException("world");
        }
        this.sendBroadcast(args[0], sender.getSender().getName(), Commandbroadcastworld.getFinalArg(args, 1));
    }

    private void sendBroadcast(String worldName, String name, String message) throws Exception {
        World world = this.ess.getWorld(worldName);
        if (world == null) {
            throw new Exception(I18n.tl("invalidWorld", new Object[0]));
        }
        this.sendToWorld(world, I18n.tl("broadcast", FormatUtil.replaceFormat(message).replace("\\n", "\n"), name));
    }

    private void sendToWorld(World world, String message) {
        IText broadcast = new SimpleTextInput(message);
        Collection<Player> players = this.ess.getOnlinePlayers();
        for (Player player : players) {
            if (!player.getWorld().equals(world)) continue;
            User user = this.ess.getUser(player);
            broadcast = new KeywordReplacer(broadcast, new CommandSource((CommandSender)player), this.ess, false);
            for (String messageText : broadcast.getLines()) {
                user.sendMessage(messageText);
            }
        }
    }
}

