/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.EssentialsConf;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;

public class EssentialsUserConf
extends EssentialsConf {
    public final String username;
    public final UUID uuid;

    public EssentialsUserConf(String username, UUID uuid, File configFile) {
        super(configFile);
        this.username = username;
        this.uuid = uuid;
    }

    @Override
    public boolean legacyFileExists() {
        File file = new File(this.configFile.getParentFile(), this.username + ".yml");
        return file.exists();
    }

    @Override
    public void convertLegacyFile() {
        File file = new File(this.configFile.getParentFile(), this.username + ".yml");
        try {
            Files.move((File)file, (File)new File(this.configFile.getParentFile(), this.uuid + ".yml"));
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.WARNING, "Failed to migrate user: " + this.username, ex);
        }
        this.setProperty("lastAccountName", this.username);
    }

    private File getAltFile() {
        UUID fn = UUID.nameUUIDFromBytes(("OfflinePlayer:" + this.username.toLowerCase(Locale.ENGLISH)).getBytes(Charsets.UTF_8));
        return new File(this.configFile.getParentFile(), fn.toString() + ".yml");
    }

    @Override
    public boolean altFileExists() {
        if (this.username.equals(this.username.toLowerCase())) {
            return false;
        }
        return this.getAltFile().exists();
    }

    @Override
    public void convertAltFile() {
        try {
            Files.move((File)this.getAltFile(), (File)new File(this.configFile.getParentFile(), this.uuid + ".yml"));
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.WARNING, "Failed to migrate user: " + this.username, ex);
        }
    }
}

