/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.textreader.KeywordReplacer;
import com.earth2me.essentials.textreader.TextInput;
import com.earth2me.essentials.textreader.TextPager;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.LocationUtil;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.ess3.api.IEssentials;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerEggThrowEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class EssentialsPlayerListener
implements Listener {
    private static final Logger LOGGER = Logger.getLogger("Essentials");
    private final transient IEssentials ess;

    public EssentialsPlayerListener(IEssentials parent) {
        this.ess = parent;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        this.updateCompass(user);
        user.setDisplayNick();
        if (this.ess.getSettings().isTeleportInvulnerability()) {
            user.enableInvulnerabilityAfterTeleport();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (user.isMuted()) {
            event.setCancelled(true);
            user.sendMessage(I18n.tl("voiceSilenced", new Object[0]));
            LOGGER.info(I18n.tl("mutedUserSpeaks", user.getName()));
        }
        try {
            Iterator it = event.getRecipients().iterator();
            while (it.hasNext()) {
                User u = this.ess.getUser((Player)it.next());
                if (!u.isIgnoredPlayer(user)) continue;
                it.remove();
            }
        }
        catch (UnsupportedOperationException ex) {
            if (this.ess.getSettings().isDebug()) {
                this.ess.getLogger().log(Level.INFO, "Ignore could not block chat due to custom chat plugin event.", ex);
            }
            this.ess.getLogger().info("Ignore could not block chat due to custom chat plugin event.");
        }
        user.updateActivity(true);
        user.setDisplayNick();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockZ() == event.getTo().getBlockZ() && event.getFrom().getBlockY() == event.getTo().getBlockY()) {
            return;
        }
        if (!this.ess.getSettings().cancelAfkOnMove() && !this.ess.getSettings().getFreezeAfkPlayers()) {
            event.getHandlers().unregister((Listener)this);
            if (this.ess.getSettings().isDebug()) {
                LOGGER.log(Level.INFO, "Unregistering move listener");
            }
            return;
        }
        User user = this.ess.getUser(event.getPlayer());
        if (user.isAfk() && this.ess.getSettings().getFreezeAfkPlayers()) {
            Location from = event.getFrom();
            Location origTo = event.getTo();
            Location to = origTo.clone();
            if (this.ess.getSettings().cancelAfkOnMove() && origTo.getY() >= (double)(from.getBlockY() + 1)) {
                user.updateActivity(true);
                return;
            }
            to.setX(from.getX());
            to.setY(from.getY());
            to.setZ(from.getZ());
            try {
                event.setTo(LocationUtil.getSafeDestination(to));
            }
            catch (Exception ex) {
                event.setTo(to);
            }
            return;
        }
        Location afk = user.getAfkPosition();
        if (afk == null || !event.getTo().getWorld().equals(afk.getWorld()) || afk.distanceSquared(event.getTo()) > 9.0) {
            user.updateActivity(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (this.ess.getSettings().allowSilentJoinQuit() && user.isAuthorized("essentials.silentquit")) {
            event.setQuitMessage(null);
        } else if (this.ess.getSettings().isCustomQuitMessage() && event.getQuitMessage() != null) {
            Player player = event.getPlayer();
            event.setQuitMessage(this.ess.getSettings().getCustomQuitMessage().replace("{PLAYER}", player.getDisplayName()).replace("{USERNAME}", player.getName()));
        }
        user.startTransaction();
        if (this.ess.getSettings().removeGodOnDisconnect() && user.isGodModeEnabled()) {
            user.setGodModeEnabled(false);
        }
        if (user.isVanished()) {
            user.setVanished(false);
        }
        user.setLogoutLocation();
        if (user.isRecipeSee()) {
            user.getBase().getOpenInventory().getTopInventory().clear();
        }
        for (HumanEntity viewer : user.getBase().getInventory().getViewers()) {
            User uviewer;
            if (!(viewer instanceof Player) || !(uviewer = this.ess.getUser((Player)viewer)).isInvSee()) continue;
            uviewer.getBase().closeInventory();
        }
        user.updateActivity(false);
        if (!user.isHidden()) {
            user.setLastLogout(System.currentTimeMillis());
        }
        user.stopTransaction();
        user.dispose();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(final PlayerJoinEvent event) {
        final String joinMessage = event.getJoinMessage();
        this.ess.runTaskAsynchronously(new Runnable(){

            @Override
            public void run() {
                EssentialsPlayerListener.this.delayedJoin(event.getPlayer(), joinMessage);
            }
        });
        if (this.ess.getSettings().allowSilentJoinQuit() || this.ess.getSettings().isCustomJoinMessage()) {
            event.setJoinMessage(null);
        }
    }

    public void delayedJoin(final Player player, final String message) {
        if (!player.isOnline()) {
            return;
        }
        this.ess.getBackup().onPlayerJoin();
        User dUser = this.ess.getUser(player);
        dUser.startTransaction();
        if (dUser.isNPC()) {
            dUser.setNPC(false);
        }
        final long currentTime = System.currentTimeMillis();
        dUser.checkMuteTimeout(currentTime);
        dUser.updateActivity(false);
        dUser.stopTransaction();
        TextInput tempInput = null;
        if (!this.ess.getSettings().isCommandDisabled("motd")) {
            try {
                tempInput = new TextInput(dUser.getSource(), "motd", true, this.ess);
            }
            catch (IOException ex) {
                if (this.ess.getSettings().isDebug()) {
                    LOGGER.log(Level.WARNING, ex.getMessage(), ex);
                }
                LOGGER.log(Level.WARNING, ex.getMessage());
            }
        }
        final TextInput input = tempInput;
        class DelayJoinTask
        implements Runnable {
            DelayJoinTask() {
            }

            @Override
            public void run() {
                User user = EssentialsPlayerListener.this.ess.getUser(player);
                if (!user.getBase().isOnline()) {
                    return;
                }
                user.startTransaction();
                user.setLastAccountName(user.getBase().getName());
                user.setLastLogin(currentTime);
                user.setDisplayNick();
                EssentialsPlayerListener.this.updateCompass(user);
                if (!EssentialsPlayerListener.this.ess.getVanishedPlayers().isEmpty() && !user.isAuthorized("essentials.vanish.see")) {
                    for (String p : EssentialsPlayerListener.this.ess.getVanishedPlayers()) {
                        Player toVanish = EssentialsPlayerListener.this.ess.getServer().getPlayerExact(p);
                        if (toVanish == null || !toVanish.isOnline()) continue;
                        user.getBase().hidePlayer(toVanish);
                    }
                }
                if (user.isAuthorized("essentials.sleepingignored")) {
                    user.getBase().setSleepingIgnored(true);
                }
                if (EssentialsPlayerListener.this.ess.getSettings().allowSilentJoinQuit() && (user.isAuthorized("essentials.silentjoin") || user.isAuthorized("essentials.silentjoin.vanish"))) {
                    if (user.isAuthorized("essentials.silentjoin.vanish")) {
                        user.setVanished(true);
                    }
                } else if (message != null) {
                    if (EssentialsPlayerListener.this.ess.getSettings().isCustomJoinMessage()) {
                        String msg = EssentialsPlayerListener.this.ess.getSettings().getCustomJoinMessage().replace("{PLAYER}", player.getDisplayName()).replace("{USERNAME}", player.getName()).replace("{UNIQUE}", String.valueOf(EssentialsPlayerListener.this.ess.getUserMap().getUniqueUsers()));
                        EssentialsPlayerListener.this.ess.getServer().broadcastMessage(msg);
                    } else if (EssentialsPlayerListener.this.ess.getSettings().allowSilentJoinQuit()) {
                        EssentialsPlayerListener.this.ess.getServer().broadcastMessage(message);
                    }
                }
                if (input != null && user.isAuthorized("essentials.motd")) {
                    KeywordReplacer output = new KeywordReplacer(input, user.getSource(), EssentialsPlayerListener.this.ess);
                    TextPager pager = new TextPager(output, true);
                    pager.showPage("1", null, "motd", user.getSource());
                }
                if (!EssentialsPlayerListener.this.ess.getSettings().isCommandDisabled("mail") && user.isAuthorized("essentials.mail")) {
                    List<String> mail = user.getMails();
                    if (mail.isEmpty()) {
                        if (EssentialsPlayerListener.this.ess.getSettings().isNotifyNoNewMail()) {
                            user.sendMessage(I18n.tl("noNewMail", new Object[0]));
                        }
                    } else {
                        user.sendMessage(I18n.tl("youHaveNewMail", mail.size()));
                    }
                }
                if (user.isAuthorized("essentials.fly.safelogin")) {
                    user.getBase().setFallDistance(0.0f);
                    if (LocationUtil.shouldFly(user.getLocation())) {
                        user.getBase().setAllowFlight(true);
                        user.getBase().setFlying(true);
                        if (EssentialsPlayerListener.this.ess.getSettings().isSendFlyEnableOnJoin()) {
                            user.getBase().sendMessage(I18n.tl("flyMode", I18n.tl("enabled", new Object[0]), user.getDisplayName()));
                        }
                    }
                }
                if (!user.isAuthorized("essentials.speed")) {
                    user.getBase().setFlySpeed(0.1f);
                    user.getBase().setWalkSpeed(0.2f);
                }
                if (user.isSocialSpyEnabled() && !user.isAuthorized("essentials.socialspy")) {
                    user.setSocialSpyEnabled(false);
                    EssentialsPlayerListener.this.ess.getLogger().log(Level.INFO, "Set socialspy to false for {0} because they had it enabled without permission.", user.getName());
                }
                user.stopTransaction();
            }
        }
        this.ess.scheduleSyncDelayedTask(new DelayJoinTask());
    }

    private void updateCompass(User user) {
        Location loc = user.getHome(user.getLocation());
        if (loc == null) {
            loc = user.getBase().getBedSpawnLocation();
        }
        if (loc != null) {
            user.getBase().setCompassTarget(loc);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerLogin(PlayerLoginEvent event) {
        switch (event.getResult()) {
            case KICK_FULL: {
                User kfuser = this.ess.getUser(event.getPlayer());
                if (kfuser.isAuthorized("essentials.joinfullserver")) {
                    event.allow();
                    return;
                }
                event.disallow(PlayerLoginEvent.Result.KICK_FULL, I18n.tl("serverFull", new Object[0]));
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        boolean backListener = this.ess.getSettings().registerBackInListener();
        boolean teleportInvulnerability = this.ess.getSettings().isTeleportInvulnerability();
        if (backListener || teleportInvulnerability) {
            User user = this.ess.getUser(event.getPlayer());
            if (backListener && (event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN || event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND)) {
                user.setLastLocation();
            }
            if (teleportInvulnerability && (event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN || event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND)) {
                user.enableInvulnerabilityAfterTeleport();
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerEggThrow(PlayerEggThrowEvent event) {
        ItemStack stack;
        User user = this.ess.getUser(event.getPlayer());
        if (user.hasUnlimited(stack = new ItemStack(Material.EGG, 1))) {
            user.getBase().getInventory().addItem(new ItemStack[]{stack});
            user.getBase().updateInventory();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        final User user = this.ess.getUser(event.getPlayer());
        if (user.hasUnlimited(new ItemStack(event.getBucket()))) {
            event.getItemStack().setType(event.getBucket());
            this.ess.scheduleSyncDelayedTask(new Runnable(){

                @Override
                public void run() {
                    user.getBase().updateInventory();
                }
            });
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String cmd = event.getMessage().toLowerCase(Locale.ENGLISH).split(" ")[0].replace("/", "").toLowerCase(Locale.ENGLISH);
        if (this.ess.getUser(player).isMuted() && (this.ess.getSettings().getMuteCommands().contains(cmd) || this.ess.getSettings().getMuteCommands().contains("*"))) {
            event.setCancelled(true);
            player.sendMessage(I18n.tl("voiceSilenced", new Object[0]));
            LOGGER.info(I18n.tl("mutedUserSpeaks", player.getName()));
            return;
        }
        if ((this.ess.getSettings().getSocialSpyCommands().contains(cmd) || this.ess.getSettings().getSocialSpyCommands().contains("*")) && !player.hasPermission("essentials.chat.spy.exempt")) {
            for (User spyer : this.ess.getOnlineUsers()) {
                if (!spyer.isSocialSpyEnabled() || player.equals(spyer.getBase())) continue;
                spyer.sendMessage(player.getDisplayName() + " : " + event.getMessage());
            }
        }
        boolean broadcast = true;
        boolean update = true;
        PluginCommand pluginCommand = this.ess.getServer().getPluginCommand(cmd);
        if (pluginCommand != null) {
            switch (pluginCommand.getName()) {
                case "afk": {
                    update = false;
                }
                case "vanish": {
                    broadcast = false;
                }
            }
        }
        User user = this.ess.getUser(player);
        if (update) {
            user.updateActivity(broadcast);
        }
        if (this.ess.getSettings().isCommandCooldownsEnabled() && pluginCommand != null) {
            Map.Entry<Pattern, Long> cooldownEntry;
            int argStartIndex = event.getMessage().indexOf(" ");
            String args = argStartIndex == -1 ? event.getMessage() : event.getMessage().substring(argStartIndex);
            String fullCommand = pluginCommand.getName() + " " + args;
            boolean cooldownFound = false;
            for (Map.Entry<Pattern, Long> entry : new HashMap<Pattern, Long>(user.getCommandCooldowns()).entrySet()) {
                if (entry.getValue() <= System.currentTimeMillis()) {
                    user.clearCommandCooldown(entry.getKey());
                    continue;
                }
                if (!entry.getKey().matcher(fullCommand).matches() || entry.getValue() <= System.currentTimeMillis()) continue;
                String commandCooldownTime = DateUtil.formatDateDiff(entry.getValue());
                user.sendMessage(I18n.tl("commandCooldown", commandCooldownTime));
                cooldownFound = true;
                event.setCancelled(true);
                break;
            }
            if (!cooldownFound && (cooldownEntry = this.ess.getSettings().getCommandCooldownEntry(fullCommand)) != null) {
                Date expiry = new Date(System.currentTimeMillis() + cooldownEntry.getValue());
                user.addCommandCooldown(cooldownEntry.getKey(), expiry, this.ess.getSettings().isCommandCooldownPersistent(fullCommand));
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangedWorldFlyReset(PlayerChangedWorldEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        if (user.getBase().getGameMode() != GameMode.CREATIVE && !user.getBase().getGameMode().name().equals("SPECTATOR") && !user.isAuthorized("essentials.fly")) {
            user.getBase().setFallDistance(0.0f);
            user.getBase().setAllowFlight(false);
        }
        if (!user.isAuthorized("essentials.speed")) {
            user.getBase().setFlySpeed(0.1f);
            user.getBase().setWalkSpeed(0.2f);
        } else {
            if ((double)user.getBase().getFlySpeed() > this.ess.getSettings().getMaxFlySpeed() && !user.isAuthorized("essentials.speed.bypass")) {
                user.getBase().setFlySpeed((float)this.ess.getSettings().getMaxFlySpeed());
            } else {
                user.getBase().setFlySpeed(user.getBase().getFlySpeed() * 0.99999f);
            }
            if ((double)user.getBase().getWalkSpeed() > this.ess.getSettings().getMaxWalkSpeed() && !user.isAuthorized("essentials.speed.bypass")) {
                user.getBase().setWalkSpeed((float)this.ess.getSettings().getMaxWalkSpeed());
            } else {
                user.getBase().setWalkSpeed(user.getBase().getWalkSpeed() * 0.99999f);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        String newWorld = event.getPlayer().getLocation().getWorld().getName();
        user.setDisplayNick();
        this.updateCompass(user);
        if (this.ess.getSettings().getNoGodWorlds().contains(newWorld) && user.isGodModeEnabledRaw()) {
            user.sendMessage(I18n.tl("noGodWorldWarning", new Object[0]));
        }
        if (!user.getWorld().getName().equals(newWorld)) {
            user.sendMessage(I18n.tl("currentWorld", newWorld));
        }
        if (user.isVanished()) {
            user.setVanished(user.isAuthorized("essentials.vanish"));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerInteract(PlayerInteractEvent event) {
        switch (event.getAction()) {
            case RIGHT_CLICK_BLOCK: {
                User player;
                if (event.isCancelled() || event.getClickedBlock().getType() != Material.BED_BLOCK || !this.ess.getSettings().getUpdateBedAtDaytime() || !(player = this.ess.getUser(event.getPlayer())).isAuthorized("essentials.sethome.bed")) break;
                player.getBase().setBedSpawnLocation(event.getClickedBlock().getLocation());
                player.sendMessage(I18n.tl("bedSet", player.getLocation().getWorld().getName(), player.getLocation().getBlockX(), player.getLocation().getBlockY(), player.getLocation().getBlockZ()));
                break;
            }
            case LEFT_CLICK_AIR: {
                User user;
                if (event.getPlayer().isFlying() && (user = this.ess.getUser(event.getPlayer())).isFlyClickJump()) {
                    this.useFlyClickJump(user);
                    return;
                }
            }
            case LEFT_CLICK_BLOCK: {
                if (event.getItem() == null || event.getItem().getType() == Material.AIR) break;
                User user = this.ess.getUser(event.getPlayer());
                user.updateActivity(true);
                if (!user.hasPowerTools() || !user.arePowerToolsEnabled() || !this.usePowertools(user, event.getItem().getTypeId())) break;
                event.setCancelled(true);
                break;
            }
        }
    }

    private void useFlyClickJump(final User user) {
        block2: {
            try {
                final Location otarget = LocationUtil.getTarget((LivingEntity)user.getBase());
                class DelayedClickJumpTask
                implements Runnable {
                    DelayedClickJumpTask() {
                    }

                    @Override
                    public void run() {
                        Location loc = user.getLocation();
                        loc.setX(otarget.getX());
                        loc.setZ(otarget.getZ());
                        while (LocationUtil.isBlockDamaging(loc.getWorld(), loc.getBlockX(), loc.getBlockY() - 1, loc.getBlockZ())) {
                            loc.setY(loc.getY() + 1.0);
                        }
                        user.getBase().teleport(loc, PlayerTeleportEvent.TeleportCause.PLUGIN);
                    }
                }
                this.ess.scheduleSyncDelayedTask(new DelayedClickJumpTask());
            }
            catch (Exception ex) {
                if (!this.ess.getSettings().isDebug()) break block2;
                LOGGER.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    private boolean usePowertools(final User user, int id) {
        List<String> commandList = user.getPowertool(id);
        if (commandList == null || commandList.isEmpty()) {
            return false;
        }
        boolean used = false;
        for (final String command : commandList) {
            if (command.contains("{player}")) continue;
            if (command.startsWith("c:")) {
                used = true;
                user.getBase().chat(command.substring(2));
                continue;
            }
            used = true;
            class PowerToolUseTask
            implements Runnable {
                PowerToolUseTask() {
                }

                @Override
                public void run() {
                    user.getServer().dispatchCommand((CommandSender)user.getBase(), command);
                    LOGGER.log(Level.INFO, String.format("[PT] %s issued server command: /%s", user.getName(), command));
                }
            }
            this.ess.scheduleSyncDelayedTask(new PowerToolUseTask());
        }
        return used;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (this.ess.getSettings().getDisableItemPickupWhileAfk() && this.ess.getUser(event.getPlayer()).isAfk()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInventoryClickEvent(InventoryClickEvent event) {
        User user;
        Player refreshPlayer = null;
        Inventory top = event.getView().getTopInventory();
        InventoryType type = top.getType();
        if (type == InventoryType.PLAYER) {
            user = this.ess.getUser((Player)event.getWhoClicked());
            InventoryHolder invHolder = top.getHolder();
            if (invHolder != null && invHolder instanceof HumanEntity) {
                User invOwner = this.ess.getUser((Player)invHolder);
                if (user.isInvSee() && (!user.isAuthorized("essentials.invsee.modify") || invOwner.isAuthorized("essentials.invsee.preventmodify") || !invOwner.getBase().isOnline())) {
                    event.setCancelled(true);
                    refreshPlayer = user.getBase();
                }
            }
        } else if (type == InventoryType.ENDER_CHEST) {
            user = this.ess.getUser((Player)event.getWhoClicked());
            if (user.isEnderSee() && !user.isAuthorized("essentials.enderchest.modify")) {
                event.setCancelled(true);
                refreshPlayer = user.getBase();
            }
        } else if (type == InventoryType.WORKBENCH) {
            user = this.ess.getUser((Player)event.getWhoClicked());
            if (user.isRecipeSee()) {
                event.setCancelled(true);
                refreshPlayer = user.getBase();
            }
        } else if (type == InventoryType.CHEST && top.getSize() == 9) {
            user = this.ess.getUser((Player)event.getWhoClicked());
            InventoryHolder invHolder = top.getHolder();
            if (invHolder != null && invHolder instanceof HumanEntity && user.isInvSee()) {
                event.setCancelled(true);
                refreshPlayer = user.getBase();
            }
        }
        if (refreshPlayer != null) {
            final Player player = refreshPlayer;
            this.ess.scheduleSyncDelayedTask(new Runnable(){

                @Override
                public void run() {
                    player.updateInventory();
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryCloseEvent(InventoryCloseEvent event) {
        InventoryHolder invHolder;
        User user;
        Player refreshPlayer = null;
        Inventory top = event.getView().getTopInventory();
        InventoryType type = top.getType();
        if (type == InventoryType.PLAYER) {
            user = this.ess.getUser((Player)event.getPlayer());
            user.setInvSee(false);
            refreshPlayer = user.getBase();
        } else if (type == InventoryType.ENDER_CHEST) {
            user = this.ess.getUser((Player)event.getPlayer());
            user.setEnderSee(false);
            refreshPlayer = user.getBase();
        } else if (type == InventoryType.WORKBENCH) {
            user = this.ess.getUser((Player)event.getPlayer());
            if (user.isRecipeSee()) {
                user.setRecipeSee(false);
                event.getView().getTopInventory().clear();
                refreshPlayer = user.getBase();
            }
        } else if (type == InventoryType.CHEST && top.getSize() == 9 && (invHolder = top.getHolder()) != null && invHolder instanceof HumanEntity) {
            User user2 = this.ess.getUser((Player)event.getPlayer());
            user2.setInvSee(false);
            refreshPlayer = user2.getBase();
        }
        if (refreshPlayer != null) {
            final Player player = refreshPlayer;
            this.ess.scheduleSyncDelayedTask(new Runnable(){

                @Override
                public void run() {
                    player.updateInventory();
                }
            }, 1L);
        }
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerFishEvent(PlayerFishEvent event) {
        User user = this.ess.getUser(event.getPlayer());
        user.updateActivity(true);
    }
}

