/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.listeners;

import com.palmergames.bukkit.TownyChat.TownyChatFormatter;
import com.palmergames.bukkit.TownyChat.channels.channelTypes;
import com.palmergames.bukkit.TownyChat.config.ChatSettings;
import com.palmergames.bukkit.TownyChat.events.AsyncChatHookEvent;
import com.palmergames.bukkit.towny.TownyFormatter;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownyUniverse;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.DeluxeUtil;
import me.clip.deluxechat.Lang;
import me.clip.deluxechat.events.DeluxeChatEvent;
import me.clip.deluxechat.events.DeluxeChatJSONEvent;
import me.clip.deluxechat.events.RecipientPlaceholderEvent;
import me.clip.deluxechat.fanciful.FancyMessage;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.objects.DeluxeFormat;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class TownyChatListener
implements Listener,
DeluxeHook {
    private DeluxeChat plugin;
    private static Map<String, ChatPlayer> players;

    public TownyChatListener(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
        players = new HashMap<String, ChatPlayer>();
    }

    @Override
    public void hook() {
        boolean bl = PlaceholderHandler.registerPlaceholderHook("TownyChat", new DeluxePlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player player, String string) {
                switch (string) {
                    case "channel_tag": {
                        return TownyChatListener.this.getChatPlayer(player).getTag();
                    }
                    case "channel_name": {
                        return TownyChatListener.this.getChatPlayer(player).getChannel();
                    }
                    case "message_color": {
                        return TownyChatListener.this.getChatPlayer(player).getColor();
                    }
                }
                try {
                    Resident resident = TownyUniverse.getDataSource().getResident(player.getName());
                    switch (string) {
                        case "world": {
                            return String.format(ChatSettings.getWorldTag(), player.getWorld().getName());
                        }
                        case "town": {
                            return resident.hasTown() ? resident.getTown().getName() : "";
                        }
                        case "townformatted": {
                            return TownyChatFormatter.formatTownTag((Resident)resident, (Boolean)false, (Boolean)true);
                        }
                        case "towntag": {
                            return TownyChatFormatter.formatTownTag((Resident)resident, (Boolean)false, (Boolean)false);
                        }
                        case "towntagoverride": {
                            return TownyChatFormatter.formatTownTag((Resident)resident, (Boolean)true, (Boolean)false);
                        }
                        case "nation": {
                            return resident.hasNation() ? resident.getTown().getNation().getName() : "";
                        }
                        case "nationformatted": {
                            return TownyChatFormatter.formatNationTag((Resident)resident, (Boolean)false, (Boolean)true);
                        }
                        case "nationtag": {
                            return TownyChatFormatter.formatNationTag((Resident)resident, (Boolean)false, (Boolean)false);
                        }
                        case "nationtagoverride": {
                            return TownyChatFormatter.formatNationTag((Resident)resident, (Boolean)true, (Boolean)false);
                        }
                        case "townytag": {
                            return TownyChatFormatter.formatTownyTag((Resident)resident, (Boolean)false, (Boolean)false);
                        }
                        case "townyformatted": {
                            return TownyChatFormatter.formatTownyTag((Resident)resident, (Boolean)false, (Boolean)true);
                        }
                        case "townytagoverride": {
                            return TownyChatFormatter.formatTownyTag((Resident)resident, (Boolean)true, (Boolean)false);
                        }
                        case "title": {
                            return resident.hasTitle() ? resident.getTitle() : "";
                        }
                        case "surname": {
                            return resident.hasSurname() ? resident.getSurname() : "";
                        }
                        case "townynameprefix": {
                            return TownyFormatter.getNamePrefix((Resident)resident);
                        }
                        case "townynamepostfix": {
                            return TownyFormatter.getNamePostfix((Resident)resident);
                        }
                        case "townyprefix": {
                            return resident.hasTitle() ? resident.getTitle() : TownyFormatter.getNamePrefix((Resident)resident);
                        }
                        case "townypostfix": {
                            return resident.hasSurname() ? resident.getSurname() : TownyFormatter.getNamePostfix((Resident)resident);
                        }
                        case "townycolor": {
                            return resident.isMayor() ? ChatSettings.getMayorColour() : (resident.isKing() ? ChatSettings.getKingColour() : ChatSettings.getResidentColour());
                        }
                        case "group": {
                            return TownyUniverse.getPermissionSource().getPlayerGroup(player);
                        }
                        case "permprefix": {
                            return TownyUniverse.getPermissionSource().getPrefixSuffix(resident, "prefix");
                        }
                        case "permsuffix": {
                            return TownyUniverse.getPermissionSource().getPrefixSuffix(resident, "suffix");
                        }
                        case "channeltag": {
                            return TownyChatFormatter.formatTownyTag((Resident)resident, (Boolean)false, (Boolean)false);
                        }
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    return "";
                }
                return null;
            }
        }, true);
        if (bl) {
            this.plugin.log.info("Hooked into TownyChat for placeholders!");
        }
    }

    public void clear() {
        players = null;
    }

    private void updatePlayer(String string, String string2, String string3, String string4) {
        if (players == null) {
            players = new HashMap<String, ChatPlayer>();
        }
        if (players.containsKey(string) && players.get(string) != null) {
            players.get(string).setChannel(string2);
            players.get(string).setTag(string3);
            players.get(string).setColor(string4);
        } else {
            ChatPlayer chatPlayer = new ChatPlayer(string, string2, string3, string4);
            players.put(string, chatPlayer);
        }
    }

    private ChatPlayer getChatPlayer(Player player) {
        return players != null && players.containsKey(player.getName()) && players.get(player.getName()) != null ? players.get(player.getName()) : new ChatPlayer(player.getName(), "", "", "");
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        if (players == null || players.isEmpty()) {
            return;
        }
        if (players.containsKey(playerQuitEvent.getPlayer().getName())) {
            players.remove(playerQuitEvent.getPlayer().getName());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChat(AsyncChatHookEvent asyncChatHookEvent) {
        if (asyncChatHookEvent.isCancelled()) {
            return;
        }
        if (DeluxeChat.getFormats() == null || DeluxeChat.getFormats().isEmpty()) {
            return;
        }
        Player player = asyncChatHookEvent.getPlayer();
        if (this.plugin.isMuted(player)) {
            asyncChatHookEvent.setCancelled(true);
            return;
        }
        String string = asyncChatHookEvent.getMessage();
        if (DeluxeUtil.containsInvalidChars(string) && !player.hasPermission("deluxechat.utf")) {
            DeluxeUtil.sms(player, Lang.CHAT_ILLEGAL_CHARACTERS.getConfigValue(null));
            asyncChatHookEvent.setCancelled(true);
            return;
        }
        if (!player.hasPermission("deluxechat.filter.bypass")) {
            string = DeluxeUtil.removeBlacklisted(string);
        }
        string = DeluxeUtil.checkColor(player, string, false);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        if (asyncChatHookEvent.getChannel() != null) {
            string2 = asyncChatHookEvent.getChannel().getChannelTag();
            string3 = asyncChatHookEvent.getChannel().getName();
            string4 = asyncChatHookEvent.getChannel().getMessageColour();
        }
        this.updatePlayer(asyncChatHookEvent.getPlayer().getName(), string3, string2, string4);
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        DeluxeFormat deluxeFormat = DeluxeFormat.newInstance(this.plugin.getPlayerFormat(player));
        DeluxeChatEvent deluxeChatEvent = new DeluxeChatEvent(player, asyncChatHookEvent.getRecipients(), deluxeFormat, string);
        Bukkit.getPluginManager().callEvent((Event)deluxeChatEvent);
        if (deluxeChatEvent.isCancelled()) {
            asyncChatHookEvent.setCancelled(true);
            return;
        }
        deluxeFormat = deluxeChatEvent.getDeluxeFormat();
        FancyMessage fancyMessage = this.plugin.getFancyChatFormat(player, deluxeFormat);
        if (fancyMessage == null) {
            this.plugin.log.severe("There was an error getting the chat format for player " + player.getName());
            return;
        }
        Set<Player> set = deluxeChatEvent.getRecipients();
        if (set == null) {
            fancyMessage = null;
            asyncChatHookEvent.setCancelled(true);
            return;
        }
        String string5 = String.valueOf(fancyMessage.getLastColor()) + fancyMessage.getChatColor() + deluxeChatEvent.getChatMessage();
        String string6 = this.plugin.getChat().convertMsg(player, string5);
        if (DeluxeChat.useRelationPlaceholders()) {
            DeluxeChatJSONEvent deluxeChatJSONEvent = new DeluxeChatJSONEvent(player, fancyMessage.toJSONString(), string6, string5);
            Bukkit.getPluginManager().callEvent((Event)deluxeChatJSONEvent);
            if (deluxeChatJSONEvent.getJSONFormat() == null || deluxeChatJSONEvent.getJSONChatMessage() == null || deluxeChatJSONEvent.getJSONFormat().isEmpty()) {
                return;
            }
            for (Player object : set) {
                this.plugin.getChat().sendDirectChat(player, deluxeChatJSONEvent.getJSONFormat(), deluxeChatJSONEvent.getJSONChatMessage(), player, object);
            }
        } else {
            this.plugin.getChat().sendDeluxeChat(player, fancyMessage.toJSONString(), string6, set);
        }
        set.clear();
        asyncChatHookEvent.getRecipients().clear();
        Bukkit.getConsoleSender().sendMessage("[CHAT] " + player.getName() + ": " + string5);
        if (DeluxeChat.useBungee() && !DeluxeChat.isLocal(player.getUniqueId().toString()) && player.hasPermission("deluxechat.bungee.chat")) {
            if (asyncChatHookEvent.getChannel().getType() != channelTypes.GLOBAL) {
                return;
            }
            boolean bl = player.hasPermission("deluxechat.bungee.override");
            if (DeluxeChat.useRelationPlaceholders()) {
                RecipientPlaceholderEvent recipientPlaceholderEvent = new RecipientPlaceholderEvent(player, player, fancyMessage.toJSONString(), string6, true);
                Bukkit.getPluginManager().callEvent((Event)recipientPlaceholderEvent);
                if (recipientPlaceholderEvent.getJSONFormat() == null || recipientPlaceholderEvent.getChatMessage() == null || recipientPlaceholderEvent.getJSONFormat().isEmpty() || recipientPlaceholderEvent.getChatMessage().isEmpty()) {
                    return;
                }
                DeluxeChat.forwardString(player, recipientPlaceholderEvent.getJSONFormat(), recipientPlaceholderEvent.getChatMessage(), bl);
            } else {
                DeluxeChat.forwardString(player, fancyMessage.toJSONString(), string6, bl);
            }
        }
    }

    public class ChatPlayer {
        private String player;
        private String channel;
        private String tag;
        private String color;

        public ChatPlayer(String string, String string2, String string3, String string4) {
            this.setPlayer(string);
            if (string2 != null) {
                this.setChannel(string2);
            } else {
                this.setChannel("");
            }
            if (string3 != null) {
                this.setTag(string3);
            } else {
                this.setTag("");
            }
            if (string4 != null) {
                this.setColor(string4);
            } else {
                this.setColor("");
            }
        }

        public String getPlayer() {
            return this.player;
        }

        public void setPlayer(String string) {
            this.player = string;
        }

        public String getChannel() {
            if (this.channel == null) {
                return "";
            }
            return this.channel;
        }

        public void setChannel(String string) {
            this.channel = string;
        }

        public String getTag() {
            if (this.tag == null) {
                return "";
            }
            return this.tag;
        }

        public void setTag(String string) {
            this.tag = string;
        }

        public String getColor() {
            if (this.color == null) {
                return "";
            }
            return this.color;
        }

        public void setColor(String string) {
            this.color = string;
        }
    }
}

