/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.listeners;

import java.util.ArrayList;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.DeluxeUtil;
import me.clip.deluxechat.fanciful.FancyMessage;
import me.clip.deluxechat.updater.SpigotUpdater;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerJoinListener
implements Listener {
    DeluxeChat plugin;

    public PlayerJoinListener(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        DeluxeChat.disableSocialSpy(playerQuitEvent.getPlayer());
        DeluxeChat.removeFromPM(playerQuitEvent.getPlayer().getName());
        this.plugin.setGlobal(playerQuitEvent.getPlayer().getUniqueId().toString());
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (player.hasPermission("deluxechat.socialspy.onjoin")) {
            DeluxeChat.enableSocialSpy(player);
        }
        if (DeluxeChat.useBungee()) {
            if (DeluxeChat.globalOnJoin()) {
                this.plugin.setGlobal(player.getUniqueId().toString());
            } else {
                this.plugin.setLocal(player.getUniqueId().toString());
            }
        }
        if (!player.isOp()) {
            return;
        }
        if (this.plugin.getUpdater() == null) {
            return;
        }
        if (SpigotUpdater.updateAvailable()) {
            DeluxeUtil.sms(player, "&8&m-----------------------------------------------------");
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&aUpdate released: &f" + SpigotUpdater.getHighest())));
            arrayList.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&cYou are running: &f" + this.plugin.getDescription().getVersion())));
            FancyMessage fancyMessage = new FancyMessage("An update for DeluxeChat has been found! ").color(ChatColor.GREEN).tooltip(arrayList).link("http://www.spigotmc.org/resources/deluxechat.1277/").then("Click to download!").color(ChatColor.WHITE).link("http://www.spigotmc.org/resources/deluxechat.1277/");
            this.plugin.getChat().sendFancyMessage((CommandSender)player, fancyMessage);
            DeluxeUtil.sms(player, "&8&m-----------------------------------------------------");
        }
    }
}

