/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.javascript;

import java.util.HashSet;
import java.util.Set;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.javascript.JavascriptPlaceholder;
import me.clip.deluxechat.javascript.JavascriptPlaceholdersConfig;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.entity.Player;

public class JavascriptPlaceholders {
    private DeluxeChat plugin;
    private JavascriptPlaceholdersConfig config;
    private static Set<JavascriptPlaceholder> scripts;

    public JavascriptPlaceholders(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
        this.config = new JavascriptPlaceholdersConfig(this.plugin);
        this.config.loadPlaceholders();
    }

    public static boolean addJavascriptPlaceholder(JavascriptPlaceholder javascriptPlaceholder) {
        if (javascriptPlaceholder == null) {
            return false;
        }
        if (scripts == null) {
            scripts = new HashSet<JavascriptPlaceholder>();
        }
        if (scripts.isEmpty()) {
            scripts.add(javascriptPlaceholder);
            return true;
        }
        for (JavascriptPlaceholder javascriptPlaceholder2 : scripts) {
            if (!javascriptPlaceholder2.getIdentifier().equalsIgnoreCase(javascriptPlaceholder.getIdentifier())) continue;
            return false;
        }
        scripts.add(javascriptPlaceholder);
        return true;
    }

    public static int getJavascriptPlaceholdersAmount() {
        return scripts == null ? 0 : scripts.size();
    }

    public static void cleanup() {
        scripts = null;
    }

    public void hook() {
        boolean bl = PlaceholderHandler.registerPlaceholderHook("javascript", new DeluxePlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player player, String string) {
                if (player == null) {
                    return "";
                }
                if (scripts == null) {
                    return null;
                }
                for (JavascriptPlaceholder javascriptPlaceholder : scripts) {
                    if (!javascriptPlaceholder.getIdentifier().equalsIgnoreCase(string)) continue;
                    return javascriptPlaceholder.evaluate(player);
                }
                return null;
            }
        }, true);
        if (bl) {
            this.plugin.log.info(String.valueOf(JavascriptPlaceholders.getJavascriptPlaceholdersAmount()) + " Javascript placeholders registered!");
        }
    }
}

