/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.javascript;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import me.clip.deluxechat.javascript.JavascriptReturnType;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class JavascriptPlaceholder {
    private String identifier;
    private String expression;
    private String trueResult;
    private String falseResult;
    private JavascriptReturnType type;
    private static ScriptEngine engine = null;

    public JavascriptPlaceholder(String string, JavascriptReturnType javascriptReturnType, String string2, String string3, String string4) {
        if (javascriptReturnType == null) {
            throw new IllegalArgumentException("Javascript placeholder type must either be 'boolean' or 'javascript'!");
        }
        this.type = javascriptReturnType;
        if (string == null) {
            throw new IllegalArgumentException("Javascript placeholder identifier must not be null!");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Javascript placeholder expression must not be null!");
        }
        this.identifier = string;
        this.expression = string2;
        if (javascriptReturnType == JavascriptReturnType.BOOLEAN) {
            if (string3 == null) {
                throw new IllegalArgumentException("Javascript boolean placeholder must contain a true_result!");
            }
            if (string4 == null) {
                throw new IllegalArgumentException("Javascript boolean placeholder must contain a false_result!");
            }
            this.trueResult = string3;
            this.falseResult = string4;
        }
    }

    public static void cleanup() {
        engine = null;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getTrueResult() {
        return this.trueResult;
    }

    public String getFalseResult() {
        return this.falseResult;
    }

    public JavascriptReturnType getType() {
        return this.type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String evaluate(Player player) {
        Object object;
        block4: {
            if (engine == null) {
                engine = new ScriptEngineManager().getEngineByName("javascript");
                engine.put("BukkitServer", Bukkit.getServer());
            }
            String string = PlaceholderHandler.setPlaceholders(player, this.expression);
            try {
                engine.put("BukkitPlayer", player);
                object = engine.eval(string);
                if (this.type != JavascriptReturnType.BOOLEAN) return object.toString();
                if (object instanceof Boolean) break block4;
                return "invalid javascript";
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        if (!((Boolean)object).booleanValue()) return PlaceholderHandler.setPlaceholders(player, this.falseResult);
        return PlaceholderHandler.setPlaceholders(player, this.trueResult);
    }
}

