/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook
implements DeluxeHook {
    DeluxeChat plugin;
    private static Permission perms = null;
    private static Economy econ = null;
    private static Chat chat = null;

    public VaultHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        if (Bukkit.getPluginManager().isPluginEnabled("Vault")) {
            boolean bl;
            if (this.setupEconomy() && (bl = PlaceholderHandler.registerPlaceholderHook("Vaulteco", new DeluxePlaceholderHook(){

                @Override
                public String onPlaceholderRequest(Player player, String string) {
                    if (string.equals("balance")) {
                        return String.valueOf(VaultHook.this.getBalance((OfflinePlayer)player));
                    }
                    if (string.equals("balance_fixed")) {
                        return VaultHook.this.rounded(VaultHook.this.getBalance((OfflinePlayer)player));
                    }
                    if (string.equals("balance_formatted")) {
                        return VaultHook.this.formatted(VaultHook.this.getBalance((OfflinePlayer)player));
                    }
                    return null;
                }
            }, true))) {
                this.plugin.log.info("Hooked into Vault for economy placeholders!");
            }
            if (this.setupPerms() && this.setupChat() && (bl = PlaceholderHandler.registerPlaceholderHook("Vault", new DeluxePlaceholderHook(){

                @Override
                public String onPlaceholderRequest(Player player, String string) {
                    switch (string) {
                        case "rank": 
                        case "group": {
                            return VaultHook.this.getMainGroup(player) != null ? VaultHook.this.getMainGroup(player) : "";
                        }
                        case "prefix": {
                            return VaultHook.this.getPlayerPrefix(player) != null ? VaultHook.this.getPlayerPrefix(player) : "";
                        }
                        case "groupprefix": 
                        case "rankprefix": {
                            return VaultHook.this.getGroupPrefix(player) != null ? VaultHook.this.getGroupPrefix(player) : "";
                        }
                        case "suffix": {
                            return VaultHook.this.getPlayerSuffix(player) != null ? VaultHook.this.getPlayerSuffix(player) : "";
                        }
                        case "ranksuffix": 
                        case "groupsuffix": {
                            return VaultHook.this.getGroupSuffix(player) != null ? VaultHook.this.getGroupSuffix(player) : "";
                        }
                    }
                    if (string.startsWith("rankprefix_")) {
                        int n = 1;
                        try {
                            n = Integer.parseInt(string.split("rankprefix_")[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return VaultHook.this.getGroupPrefix(player, n);
                    }
                    if (string.startsWith("ranksuffix_")) {
                        int n = 1;
                        try {
                            n = Integer.parseInt(string.split("ranksuffix_")[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return VaultHook.this.getGroupSuffix(player, n);
                    }
                    if (string.startsWith("groupprefix_")) {
                        int n = 1;
                        try {
                            n = Integer.parseInt(string.split("groupprefix_")[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return VaultHook.this.getGroupPrefix(player, n);
                    }
                    if (string.startsWith("groupsuffix_")) {
                        int n = 1;
                        try {
                            n = Integer.parseInt(string.split("groupsuffix_")[1]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return VaultHook.this.getGroupSuffix(player, n);
                    }
                    return null;
                }
            }, true))) {
                this.plugin.log.info("Hooked into Vault for permissions placeholders!");
            }
        }
    }

    private String rounded(double d) {
        long l = (long)d;
        return String.valueOf(l);
    }

    private String formatted(double d) {
        int n;
        String string;
        String string2;
        if (d >= 1.0E15) {
            int n2;
            String string3 = String.format("%.2f", d / 1.0E15);
            String string4 = string3.substring((n2 = string3.indexOf(".")) + 1);
            if (string4.endsWith("0")) {
                string3 = string4.startsWith("0") ? string3.substring(0, string3.length() - 3) : string3.substring(0, string3.length() - 1);
            }
            return String.valueOf(string3) + " Quadrillion";
        }
        if (d >= 1.0E12) {
            int n3;
            String string5 = String.format("%.2f", d / 1.0E12);
            String string6 = string5.substring((n3 = string5.indexOf(".")) + 1);
            if (string6.endsWith("0")) {
                string5 = string6.startsWith("0") ? string5.substring(0, string5.length() - 3) : string5.substring(0, string5.length() - 1);
            }
            return String.valueOf(string5) + " Trillion";
        }
        if (d >= 1.0E9) {
            int n4;
            String string7 = String.format("%.2f", d / 1.0E9);
            String string8 = string7.substring((n4 = string7.indexOf(".")) + 1);
            if (string8.endsWith("0")) {
                string7 = string8.startsWith("0") ? string7.substring(0, string7.length() - 3) : string7.substring(0, string7.length() - 1);
            }
            return String.valueOf(string7) + " Billion";
        }
        if (d >= 1000000.0) {
            int n5;
            String string9 = String.format("%.2f", d / 1000000.0);
            String string10 = string9.substring((n5 = string9.indexOf(".")) + 1);
            if (string10.endsWith("0")) {
                string9 = string10.startsWith("0") ? string9.substring(0, string9.length() - 3) : string9.substring(0, string9.length() - 1);
            }
            return String.valueOf(string9) + " Million";
        }
        if (d >= 1000.0 && (string2 = (string = String.format("%.2f", d / 1000.0)).substring((n = string.indexOf(".")) + 1)).endsWith("0")) {
            string = string2.startsWith("0") ? string.substring(0, string.length() - 3) : string.substring(0, string.length() - 1);
            return String.valueOf(string) + " Thousand";
        }
        int n6 = (int)d;
        return String.valueOf(n6);
    }

    private boolean setupEconomy() {
        if (this.plugin.getConfig().getBoolean("hooks.vault_eco")) {
            RegisteredServiceProvider registeredServiceProvider = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
            if (registeredServiceProvider == null) {
                return false;
            }
            econ = (Economy)registeredServiceProvider.getProvider();
            return econ != null;
        }
        return false;
    }

    private boolean setupChat() {
        if (this.plugin.getConfig().getBoolean("hooks.vault_perms")) {
            RegisteredServiceProvider registeredServiceProvider = Bukkit.getServer().getServicesManager().getRegistration(Chat.class);
            if (registeredServiceProvider != null && registeredServiceProvider.getPlugin() != null) {
                chat = (Chat)registeredServiceProvider.getProvider();
            }
            return chat != null;
        }
        return false;
    }

    private boolean setupPerms() {
        if (this.plugin.getConfig().getBoolean("hooks.vault_perms")) {
            RegisteredServiceProvider registeredServiceProvider = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
            if (registeredServiceProvider != null && registeredServiceProvider.getPlugin() != null) {
                perms = (Permission)registeredServiceProvider.getProvider();
            }
            return perms != null;
        }
        return false;
    }

    public boolean useVaultChat() {
        return chat != null;
    }

    public boolean useVaultEcon() {
        return econ != null;
    }

    public boolean useVaultPerms() {
        return perms != null;
    }

    public String getVaultVersion() {
        return Bukkit.getServer().getPluginManager().getPlugin("Vault").getDescription().getVersion();
    }

    public String[] getGroups(Player player) {
        if (perms.getPlayerGroups(player) != null) {
            return perms.getPlayerGroups(player);
        }
        return new String[]{""};
    }

    public double getBalance(OfflinePlayer offlinePlayer) {
        if (econ != null) {
            return econ.getBalance(offlinePlayer);
        }
        return 0.0;
    }

    public String getMainGroup(Player player) {
        if (perms.getPrimaryGroup(player) != null) {
            return String.valueOf(perms.getPrimaryGroup(player));
        }
        return "";
    }

    public boolean opHasPermission(Player player, String string) {
        if (perms.getPrimaryGroup(player) != null) {
            return perms.groupHas(player.getWorld(), perms.getPrimaryGroup(player), string);
        }
        return false;
    }

    public boolean addPerm(Player player, String string) {
        return perms.playerAdd(player, string);
    }

    public String getPlayerPrefix(Player player) {
        if (chat.getPlayerPrefix(player) != null) {
            return String.valueOf(chat.getPlayerPrefix(player));
        }
        return "";
    }

    public String getPlayerSuffix(Player player) {
        if (chat.getPlayerSuffix(player) != null) {
            return String.valueOf(chat.getPlayerSuffix(player));
        }
        return "";
    }

    public String getGroupSuffix(Player player) {
        if (perms.getPrimaryGroup(player) == null) {
            return "";
        }
        if (chat.getGroupSuffix(player.getWorld(), perms.getPrimaryGroup(player)) != null) {
            return String.valueOf(chat.getGroupSuffix(player.getWorld(), perms.getPrimaryGroup(player)));
        }
        return "";
    }

    public String getGroupPrefix(Player player) {
        if (perms.getPrimaryGroup(player) == null) {
            return "";
        }
        if (chat.getGroupPrefix(player.getWorld(), perms.getPrimaryGroup(player)) != null) {
            return String.valueOf(chat.getGroupPrefix(player.getWorld(), perms.getPrimaryGroup(player)));
        }
        return "";
    }

    public String getGroupSuffix(Player player, int n) {
        if (perms.getPlayerGroups(player) == null) {
            return "";
        }
        String[] stringArray = perms.getPlayerGroups(player);
        if (n > stringArray.length) {
            return "";
        }
        int n2 = 1;
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string = stringArray2[n4];
            if (n2 < n) {
                ++n2;
            } else if (chat.getGroupSuffix(player.getWorld(), string) != null) {
                return String.valueOf(chat.getGroupSuffix(player.getWorld(), string));
            }
            ++n4;
        }
        return "";
    }

    public String getGroupPrefix(Player player, int n) {
        if (perms.getPlayerGroups(player) == null) {
            return "";
        }
        String[] stringArray = perms.getPlayerGroups(player);
        if (n > stringArray.length) {
            return "";
        }
        int n2 = 1;
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string = stringArray2[n4];
            if (n2 < n) {
                ++n2;
            } else if (chat.getGroupPrefix(player.getWorld(), string) != null) {
                return String.valueOf(chat.getGroupPrefix(player.getWorld(), string));
            }
            ++n4;
        }
        return "";
    }

    public boolean hasPerm(Player player, String string) {
        if (perms != null) {
            return perms.has(player, string);
        }
        return player.hasPermission(string);
    }

    public String[] getServerGroups() {
        if (perms.getGroups() != null) {
            return perms.getGroups();
        }
        return new String[]{""};
    }
}

