/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import com.palmergames.bukkit.towny.object.TownyUniverse;
import java.util.List;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class TownyHook {
    DeluxeChat plugin;
    private boolean useTowny;
    private boolean useTownyChat;

    public TownyHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    public void hook() {
        if (Bukkit.getPluginManager().isPluginEnabled("Towny")) {
            this.useTowny = PlaceholderHandler.registerPlaceholderHook("Towny", new DeluxePlaceholderHook(){

                @Override
                public String onPlaceholderRequest(Player player, String string) {
                    switch (string) {
                        case "town": {
                            return TownyHook.this.getPlayersTown(player);
                        }
                        case "friends": {
                            return TownyHook.this.getPlayersFriends(player);
                        }
                        case "nation": {
                            return TownyHook.this.getPlayersNation(player);
                        }
                        case "title": {
                            return TownyHook.this.getPlayersTownyTitle(player);
                        }
                        case "town_residents": {
                            return TownyHook.this.getTownResidents(player);
                        }
                        case "town_size": {
                            return TownyHook.this.getTownSize(player);
                        }
                        case "town_tag": {
                            return TownyHook.this.getTownTag(player);
                        }
                        case "town_balance": {
                            return TownyHook.this.getTownBankBalance(player);
                        }
                        case "town_mayor": {
                            return TownyHook.this.getTownMayor(player);
                        }
                        case "surname": {
                            return TownyHook.this.getPlayersSurname(player);
                        }
                        case "town_rank": {
                            return TownyHook.this.getTownRank(player);
                        }
                        case "nation_rank": {
                            return TownyHook.this.getNationRank(player);
                        }
                    }
                    return null;
                }
            }, true);
            if (this.useTowny) {
                this.plugin.log.info("Hooked into Towny for placeholders!");
            }
            if (Bukkit.getPluginManager().isPluginEnabled("TownyChat")) {
                this.useTownyChat = true;
            }
        } else {
            this.useTowny = false;
            this.useTownyChat = false;
        }
    }

    public boolean townyChatEnabled() {
        return this.useTownyChat;
    }

    public boolean enabled() {
        return this.useTowny;
    }

    private String getPlayersTown(Player player) {
        if (!this.useTowny) {
            return "";
        }
        String string = "";
        try {
            string = String.valueOf(TownyUniverse.getDataSource().getResident(player.getName()).getTown().getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private String getPlayersFriends(Player player) {
        String string = "";
        try {
            string = String.valueOf(TownyUniverse.getDataSource().getResident(player.getName()).getFriends().size());
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    private String getPlayersNation(Player player) {
        String string = "";
        try {
            string = String.valueOf(TownyUniverse.getDataSource().getResident(player.getName()).getTown().getNation().getName());
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    private String getPlayersTownyTitle(Player player) {
        String string = "";
        try {
            string = String.valueOf(TownyUniverse.getDataSource().getResident(player.getName()).getTitle());
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    private String getPlayersSurname(Player player) {
        String string = "";
        try {
            string = String.valueOf(TownyUniverse.getDataSource().getResident(player.getName()).getSurname());
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    private String getTownResidents(Player player) {
        String string = "";
        try {
            string = String.valueOf(TownyUniverse.getDataSource().getResident(player.getName()).getTown().getNumResidents());
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    private String getTownBankBalance(Player player) {
        String string = "";
        try {
            string = String.valueOf(TownyUniverse.getDataSource().getResident(player.getName()).getTown().getHoldingBalance());
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    private String getTownMayor(Player player) {
        String string = "";
        try {
            string = String.valueOf(TownyUniverse.getDataSource().getResident(player.getName()).getTown().getMayor().getName());
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    private String getTownRank(Player player) {
        String string;
        block3: {
            string = "";
            try {
                List list = TownyUniverse.getDataSource().getResident(player.getName()).getTownRanks();
                if (list == null || list.isEmpty()) break block3;
                for (String string2 : list) {
                    if (!TownyUniverse.getDataSource().getResident(player.getName()).hasTownRank(string2)) continue;
                    string = string2;
                    break;
                }
            }
            catch (Exception exception) {
                return "";
            }
        }
        return string;
    }

    private String getNationRank(Player player) {
        String string;
        block3: {
            string = "";
            try {
                List list = TownyUniverse.getDataSource().getResident(player.getName()).getNationRanks();
                if (list == null || list.isEmpty()) break block3;
                for (String string2 : list) {
                    if (!TownyUniverse.getDataSource().getResident(player.getName()).hasNationRank(string2)) continue;
                    string = string2;
                    break;
                }
            }
            catch (Exception exception) {
                return "";
            }
        }
        return string;
    }

    private String getTownSize(Player player) {
        String string = "";
        try {
            string = String.valueOf(TownyUniverse.getDataSource().getResident(player.getName()).getTown().getTotalBlocks());
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }

    private String getTownTag(Player player) {
        String string = "";
        try {
            string = String.valueOf(TownyUniverse.getDataSource().getResident(player.getName()).getTown().getTag());
        }
        catch (Exception exception) {
            return "";
        }
        return string;
    }
}

