/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import java.util.Date;
import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.entity.Player;

public class PlayerPlaceholders
implements DeluxeHook {
    @Override
    public void hook() {
        PlaceholderHandler.registerPlaceholderHook("player", new DeluxePlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player player, String string) {
                if (string.startsWith("has_permission_")) {
                    String string2 = string.split("has_permission_")[1];
                    if (string2 == null || string2.isEmpty()) {
                        return "";
                    }
                    return player.hasPermission(string2) ? "yes" : "no";
                }
                switch (string) {
                    case "timestamp": {
                        return DeluxeChat.getTimestampFormat().format(new Date());
                    }
                    case "servername": 
                    case "server": {
                        return DeluxeChat.getServerName();
                    }
                    case "name": {
                        return player.getName();
                    }
                    case "displayname": {
                        return player.getDisplayName();
                    }
                    case "uuid": {
                        return player.getUniqueId().toString();
                    }
                    case "gamemode": {
                        return player.getGameMode().name();
                    }
                    case "world": {
                        return player.getWorld().getName();
                    }
                    case "x": {
                        return String.valueOf(player.getLocation().getBlockX());
                    }
                    case "y": {
                        return String.valueOf(player.getLocation().getBlockY());
                    }
                    case "z": {
                        return String.valueOf(player.getLocation().getBlockZ());
                    }
                    case "is_op": {
                        return player.isOp() ? "yes" : "no";
                    }
                    case "bed_x": {
                        return player.getBedSpawnLocation() != null ? String.valueOf(player.getBedSpawnLocation().getBlockX()) : "";
                    }
                    case "bed_y": {
                        return player.getBedSpawnLocation() != null ? String.valueOf(player.getBedSpawnLocation().getBlockY()) : "";
                    }
                    case "bed_z": {
                        return player.getBedSpawnLocation() != null ? String.valueOf(player.getBedSpawnLocation().getBlockZ()) : "";
                    }
                    case "bed_world": {
                        return player.getBedSpawnLocation() != null ? player.getBedSpawnLocation().getWorld().getName() : "";
                    }
                    case "ip": {
                        return player.getAddress().getHostName();
                    }
                    case "allow_flight": {
                        return player.getAllowFlight() ? "yes" : "no";
                    }
                    case "can_pickup_items": {
                        return player.getCanPickupItems() ? "yes" : "no";
                    }
                    case "compass_x": {
                        return player.getCompassTarget() != null ? String.valueOf(player.getCompassTarget().getBlockX()) : "";
                    }
                    case "compass_y": {
                        return player.getCompassTarget() != null ? String.valueOf(player.getCompassTarget().getBlockY()) : "";
                    }
                    case "compass_z": {
                        return player.getCompassTarget() != null ? String.valueOf(player.getCompassTarget().getBlockZ()) : "";
                    }
                    case "compass_world": {
                        return player.getCompassTarget() != null ? player.getCompassTarget().getWorld().getName() : "";
                    }
                    case "custom_name": {
                        return player.getCustomName() != null ? player.getCustomName() : player.getName();
                    }
                    case "exp": {
                        return String.valueOf(player.getExp());
                    }
                    case "exp_to_level": {
                        return String.valueOf(player.getExpToLevel());
                    }
                    case "level": {
                        return String.valueOf(player.getLevel());
                    }
                    case "first_join_date": {
                        Date date = new Date(player.getFirstPlayed());
                        return DeluxeChat.getTimestampFormat().format(date);
                    }
                    case "fly_speed": {
                        return String.valueOf(player.getFlySpeed());
                    }
                    case "food_level": {
                        return String.valueOf(player.getFoodLevel());
                    }
                    case "health": {
                        return String.valueOf(player.getHealth());
                    }
                    case "health_scale": {
                        return String.valueOf(player.getHealthScale());
                    }
                    case "item_in_hand": {
                        return player.getItemInHand() != null ? player.getItemInHand().getType().name() : "";
                    }
                    case "last_damage": {
                        return String.valueOf(player.getLastDamage());
                    }
                    case "max_health": {
                        return String.valueOf(player.getMaxHealth());
                    }
                    case "max_air": {
                        return String.valueOf(player.getMaximumAir());
                    }
                    case "max_no_damage_ticks": {
                        return String.valueOf(player.getMaximumNoDamageTicks());
                    }
                    case "no_damage_ticks": {
                        return String.valueOf(player.getNoDamageTicks());
                    }
                    case "time": {
                        return String.valueOf(player.getPlayerTime());
                    }
                    case "time_offset": {
                        return String.valueOf(player.getPlayerTimeOffset());
                    }
                    case "remaining_air": {
                        return String.valueOf(player.getRemainingAir());
                    }
                    case "saturation": {
                        return String.valueOf(player.getSaturation());
                    }
                    case "sleep_ticks": {
                        return String.valueOf(player.getSleepTicks());
                    }
                    case "ticks_lived": {
                        return String.valueOf(player.getTicksLived());
                    }
                    case "seconds_lived": {
                        return String.valueOf(player.getTicksLived() * 20);
                    }
                    case "minutes_lived": {
                        return String.valueOf(player.getTicksLived() * 20 / 60);
                    }
                    case "total_exp": {
                        return String.valueOf(player.getTotalExperience());
                    }
                    case "walk_speed": {
                        return String.valueOf(player.getWalkSpeed());
                    }
                }
                return player.getName();
            }
        }, true);
    }
}

