/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import pl.islandworld.IslandWorld;
import pl.islandworld.api.IslandWorldApi;

public class IslandWorldHook
implements DeluxeHook {
    DeluxeChat plugin;

    public IslandWorldHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        boolean bl;
        IslandWorld islandWorld;
        if (Bukkit.getPluginManager().isPluginEnabled("IslandWorld") && (islandWorld = IslandWorld.getInstance()) != null && IslandWorldApi.isInitialized() && (bl = PlaceholderHandler.registerPlaceholderHook((Plugin)islandWorld, new DeluxePlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player player, String string) {
                switch (string) {
                    case "points_with_party": {
                        return IslandWorldHook.this.getPoints(player, true);
                    }
                    case "points_without_party": {
                        return IslandWorldHook.this.getPoints(player, false);
                    }
                    case "island_members": {
                        return IslandWorldHook.this.getMembers(player, false);
                    }
                    case "all_members": {
                        return IslandWorldHook.this.getMembers(player, true);
                    }
                    case "can_build": {
                        return IslandWorldHook.this.canBuild(player, true);
                    }
                    case "in_party": {
                        return IslandWorldHook.this.inParty(player);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into IslandWorld for placeholders!");
        }
    }

    private String getPoints(Player player, boolean bl) {
        return String.valueOf(IslandWorldApi.getPoints((String)player.getName(), (boolean)bl, (boolean)false));
    }

    private String inParty(Player player) {
        if (IslandWorldApi.isHelpingIsland((String)player.getName())) {
            return "&aYes";
        }
        return "&cNo";
    }

    private String getMembers(Player player, boolean bl) {
        String[] stringArray = IslandWorldApi.getMembers((String)player.getName(), (boolean)bl);
        if (stringArray == null) {
            return "0";
        }
        return String.valueOf(stringArray.length);
    }

    private String canBuild(Player player, boolean bl) {
        if (IslandWorldApi.canBuildOnLocation((Player)player, (Location)player.getLocation(), (boolean)bl)) {
            return "&aYes";
        }
        return "&cNo";
    }
}

