/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import net.brcdev.gangs.GangsPlusApi;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class GangsPlusHook
implements DeluxeHook {
    DeluxeChat plugin;

    public GangsPlusHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        boolean bl;
        if (Bukkit.getPluginManager().getPlugin("GangsPlus") != null && (bl = PlaceholderHandler.registerPlaceholderHook("gangsplus", new DeluxePlaceholderHook(){

            @Override
            public String onPlaceholderRequest(Player player, String string) {
                switch (string) {
                    case "in_gang": {
                        return GangsPlusHook.this.inGang(player);
                    }
                    case "gang": {
                        return GangsPlusHook.this.getGang(player);
                    }
                    case "gang_tag": {
                        return GangsPlusHook.this.getGangTag(player);
                    }
                    case "gang_rank": {
                        return GangsPlusHook.this.getGangRank(player);
                    }
                    case "gang_homes": {
                        return GangsPlusHook.this.getGangHomes(player);
                    }
                    case "gang_friendlyfire": {
                        return GangsPlusHook.this.getGangFF(player);
                    }
                    case "gang_online": {
                        return GangsPlusHook.this.getGangOnline(player);
                    }
                    case "gang_size": {
                        return GangsPlusHook.this.getGangSize(player);
                    }
                    case "gang_leader": {
                        return GangsPlusHook.this.getGangLeader(player);
                    }
                    case "gang_level": {
                        return GangsPlusHook.this.getGangLevel(player);
                    }
                    case "gang_wins": {
                        return GangsPlusHook.this.getGangWins(player);
                    }
                    case "gang_losses": {
                        return GangsPlusHook.this.getGangLosses(player);
                    }
                    case "gang_wlr": {
                        return GangsPlusHook.this.getGangWLR(player);
                    }
                    case "gang_kills": {
                        return GangsPlusHook.this.getGangKills(player);
                    }
                    case "gang_deaths": {
                        return GangsPlusHook.this.getGangDeaths(player);
                    }
                    case "gang_kdr": {
                        return GangsPlusHook.this.getGangKDR(player);
                    }
                    case "gang_bank_money": {
                        return GangsPlusHook.this.getGangBankMoney(player);
                    }
                }
                return null;
            }
        }, true))) {
            this.plugin.log.info("Hooked into GangsPlus for placeholders!");
        }
    }

    private String inGang(Player player) {
        return GangsPlusApi.isInGang((Player)player) ? DeluxeChat.getBooleanTrue() : DeluxeChat.getBooleanFalse();
    }

    private String getGang(Player player) {
        if (GangsPlusApi.isInGang((Player)player)) {
            return GangsPlusApi.getPlayersGang((Player)player).getName();
        }
        return "";
    }

    private String getGangTag(Player player) {
        if (GangsPlusApi.isInGang((Player)player)) {
            return GangsPlusApi.getPlayersGang((Player)player).getFormattedName();
        }
        return "";
    }

    private String getGangLeader(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "";
        }
        return GangsPlusApi.getPlayersGang((Player)player).getOwnerMemberData().getName();
    }

    private String getGangSize(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "0";
        }
        return String.valueOf(GangsPlusApi.getPlayersGang((Player)player).getMembers().size());
    }

    private String getGangKills(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "0";
        }
        return String.valueOf(GangsPlusApi.getPlayersGang((Player)player).getKills());
    }

    private String getGangDeaths(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "0";
        }
        return String.valueOf(GangsPlusApi.getPlayersGang((Player)player).getDeaths());
    }

    private String getGangKDR(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "0";
        }
        return String.valueOf(GangsPlusApi.getPlayersGang((Player)player).getKdRatio());
    }

    private String getGangBankMoney(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "0";
        }
        return String.valueOf(GangsPlusApi.getPlayersGang((Player)player).getBankMoney());
    }

    private String getGangLevel(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "0";
        }
        return String.valueOf(GangsPlusApi.getPlayersGang((Player)player).getLevel());
    }

    private String getGangLosses(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "0";
        }
        return String.valueOf(GangsPlusApi.getPlayersGang((Player)player).getFightsLost());
    }

    private String getGangWLR(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "0";
        }
        return String.valueOf(GangsPlusApi.getPlayersGang((Player)player).getWlRatio());
    }

    private String getGangWins(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "0";
        }
        return String.valueOf(GangsPlusApi.getPlayersGang((Player)player).getFightsWon());
    }

    private String getGangOnline(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "0";
        }
        return String.valueOf(GangsPlusApi.getPlayersGang((Player)player).getOnlineMembers().size());
    }

    private String getGangRank(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "";
        }
        return String.valueOf(GangsPlusApi.getPlayersGang((Player)player).getMemberData((OfflinePlayer)player).getRank());
    }

    private String getGangHomes(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "0";
        }
        if (GangsPlusApi.getPlayersGang((Player)player).getHomes() != null) {
            return String.valueOf(GangsPlusApi.getPlayersGang((Player)player).getHomes().size());
        }
        return "0";
    }

    private String getGangFF(Player player) {
        if (!GangsPlusApi.isInGang((Player)player)) {
            return "";
        }
        return GangsPlusApi.getPlayersGang((Player)player).isFriendlyFire() ? DeluxeChat.getBooleanTrue() : DeluxeChat.getBooleanFalse();
    }
}

