/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat.hooks;

import me.clip.deluxechat.DeluxeChat;
import me.clip.deluxechat.hooks.DeluxeHook;
import me.clip.deluxechat.placeholders.DeluxePlaceholderHook;
import me.clip.deluxechat.placeholders.PlaceholderHandler;
import me.clip.ezprestige.EZPrestige;
import me.clip.ezprestige.PrestigeManager;
import me.clip.ezprestige.objects.Prestige;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EZPrestigeHook
implements DeluxeHook {
    DeluxeChat plugin;
    private EZPrestige ezprestige;

    public EZPrestigeHook(DeluxeChat deluxeChat) {
        this.plugin = deluxeChat;
    }

    @Override
    public void hook() {
        if (Bukkit.getPluginManager().isPluginEnabled("EZPrestige")) {
            boolean bl;
            this.ezprestige = (EZPrestige)Bukkit.getPluginManager().getPlugin("EZPrestige");
            if (this.ezprestige != null && (bl = PlaceholderHandler.registerPlaceholderHook((Plugin)this.ezprestige, new DeluxePlaceholderHook(){

                @Override
                public String onPlaceholderRequest(Player player, String string) {
                    switch (string) {
                        case "prestige": {
                            return EZPrestigeHook.this.getCurrentPrestige(player);
                        }
                        case "prestigetag": {
                            return EZPrestigeHook.this.getCurrentPrestigeTag(player);
                        }
                        case "nextprestige": {
                            return EZPrestigeHook.this.getNextPrestige(player);
                        }
                        case "nextprestigetag": {
                            return EZPrestigeHook.this.getNextPrestigeTag(player);
                        }
                    }
                    return null;
                }
            }, true))) {
                this.plugin.log.info("Hooked into EZPrestige for placeholders!");
            }
        }
    }

    private String getCurrentPrestigeTag(Player player) {
        String string;
        if (player.isOp() && (string = EZPrestige.getOptions().getOpPrestigeChatTag()) != null) {
            return string;
        }
        string = PrestigeManager.getCurrentPrestige((Player)player);
        if (string == null) {
            String string2 = EZPrestige.getOptions().getNoPrestigeChatTag();
            return string2 != null ? string2 : "";
        }
        return string.getDisplayTag();
    }

    private String getCurrentPrestige(Player player) {
        Prestige prestige = PrestigeManager.getCurrentPrestige((Player)player);
        if (prestige == null) {
            return "0";
        }
        return String.valueOf(prestige.getPrestige());
    }

    private String getNextPrestigeTag(Player player) {
        Prestige prestige = PrestigeManager.getNextPrestige((Player)player);
        if (prestige == null) {
            return "";
        }
        return prestige.getDisplayTag();
    }

    private String getNextPrestige(Player player) {
        Prestige prestige = PrestigeManager.getNextPrestige((Player)player);
        if (prestige == null) {
            return "";
        }
        return String.valueOf(prestige.getPrestige());
    }
}

