/*
 * Decompiled with CFR 0.152.
 */
package me.clip.deluxechat;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigWrapper {
    private final JavaPlugin plugin;
    private FileConfiguration config;
    private File configFile;
    private final String folderName;
    private final String fileName;

    public ConfigWrapper(JavaPlugin javaPlugin, String string, String string2) {
        this.plugin = javaPlugin;
        this.folderName = string;
        this.fileName = string2;
    }

    public void createNewFile(String string, String string2) {
        this.reloadConfig();
        this.saveConfig();
        this.loadConfig(string2);
        if (string != null) {
            this.plugin.getLogger().info(string);
        }
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public void loadConfig(String string) {
        this.config.options().header(string);
        this.config.options().copyDefaults(true);
        this.saveConfig();
    }

    public void reloadConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.plugin.getDataFolder() + this.folderName, this.fileName);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public void saveConfig() {
        if (this.config == null || this.configFile == null) {
            return;
        }
        try {
            this.getConfig().save(this.configFile);
        }
        catch (IOException iOException) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not save config to " + this.configFile, iOException);
        }
    }
}

