/*
 * Decompiled with CFR 0.152.
 */
package net.craftminecraft.bungee.bungeeyaml.bukkitapi.file;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.craftminecraft.bungee.bungeeyaml.bukkitapi.Configuration;
import net.craftminecraft.bungee.bungeeyaml.bukkitapi.ConfigurationSection;
import net.craftminecraft.bungee.bungeeyaml.bukkitapi.InvalidConfigurationException;
import net.craftminecraft.bungee.bungeeyaml.bukkitapi.file.FileConfiguration;
import net.craftminecraft.bungee.bungeeyaml.bukkitapi.file.YamlConfigurationOptions;
import net.craftminecraft.bungee.bungeeyaml.bukkitapi.file.YamlConstructor;
import net.craftminecraft.bungee.bungeeyaml.bukkitapi.file.YamlRepresenter;
import net.md_5.bungee.api.ProxyServer;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public class YamlConfiguration
extends FileConfiguration {
    protected static final String COMMENT_PREFIX = "# ";
    protected static final String BLANK_CONFIG = "{}\n";
    private final DumperOptions yamlOptions = new DumperOptions();
    private final Representer yamlRepresenter = new YamlRepresenter();
    private final Yaml yaml = new Yaml((BaseConstructor)new YamlConstructor(), this.yamlRepresenter, this.yamlOptions);

    @Override
    public String saveToString() {
        this.yamlOptions.setIndent(this.options().indent());
        this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        StringBuilder builder = new StringBuilder(this.buildHeader());
        if (builder.length() > 0) {
            builder.append('\n');
        }
        builder.append(this.saveConfigSectionWithComments(this, false));
        String dump = builder.toString();
        if (dump.equals(BLANK_CONFIG)) {
            dump = "";
        }
        return dump;
    }

    public String saveConfigSectionWithComments(ConfigurationSection section, boolean depth) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object> entry : section.getValues(false).entrySet()) {
            String comment = this.getComment(entry.getKey());
            if (comment != null) {
                builder.append(this.buildComment(comment));
            }
            if (entry.getValue() instanceof ConfigurationSection) {
                builder.append('\n');
                if (Character.isLetterOrDigit(entry.getKey().codePointAt(0))) {
                    builder.append(entry.getKey());
                } else {
                    builder.append("'" + entry.getKey() + "'");
                }
                builder.append(":" + this.yamlOptions.getLineBreak().getString());
                builder.append(this.saveConfigSectionWithComments((ConfigurationSection)entry.getValue(), true));
                builder.append('\n');
                continue;
            }
            builder.append(this.yaml.dump(Collections.singletonMap(entry.getKey(), entry.getValue())));
        }
        String dump = builder.toString();
        if (depth) {
            String[] lines = dump.split(Pattern.quote(this.yamlOptions.getLineBreak().getString()));
            StringBuilder indented = new StringBuilder();
            int i = 0;
            while (i < lines.length) {
                int indent = 0;
                while (indent < this.yamlOptions.getIndent()) {
                    indented.append(" ");
                    ++indent;
                }
                indented.append(String.valueOf(lines[i]) + this.yamlOptions.getLineBreak().getString());
                ++i;
            }
            return indented.toString();
        }
        return dump;
    }

    @Override
    public void loadFromString(String contents) throws InvalidConfigurationException {
        Map input;
        Preconditions.checkNotNull((Object)contents, (Object)"Contents cannot be null");
        try {
            input = (Map)this.yaml.load(contents);
        }
        catch (YAMLException e) {
            throw new InvalidConfigurationException(e);
        }
        catch (ClassCastException e) {
            throw new InvalidConfigurationException("Top level is not a Map.");
        }
        String header = this.parseHeader(contents);
        if (header.length() > 0) {
            this.options().header(header);
        }
        if (input != null) {
            this.convertMapsToSections(input, this);
        }
    }

    protected void convertMapsToSections(Map<?, ?> input, ConfigurationSection section) {
        for (Map.Entry<?, ?> entry : input.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Map) {
                this.convertMapsToSections((Map)value, section.createSection(key));
                continue;
            }
            section.set(key, value);
        }
    }

    protected String parseHeader(String input) {
        String[] lines = input.split("\r?\n", -1);
        StringBuilder result = new StringBuilder();
        boolean readingHeader = true;
        boolean foundHeader = false;
        int i = 0;
        while (i < lines.length && readingHeader) {
            String line = lines[i];
            if (line.startsWith(COMMENT_PREFIX)) {
                if (i > 0) {
                    result.append("\n");
                }
                if (line.length() > COMMENT_PREFIX.length()) {
                    result.append(line.substring(COMMENT_PREFIX.length()));
                }
                foundHeader = true;
            } else if (foundHeader && line.length() == 0) {
                result.append("\n");
            } else if (foundHeader) {
                readingHeader = false;
            }
            ++i;
        }
        return result.toString();
    }

    @Override
    protected String buildHeader() {
        FileConfiguration filedefaults;
        String defaultsHeader;
        Configuration def;
        String header = this.options().header();
        if (this.options().copyHeader() && (def = this.getDefaults()) != null && def instanceof FileConfiguration && (defaultsHeader = (filedefaults = (FileConfiguration)def).buildHeader()) != null && defaultsHeader.length() > 0) {
            return defaultsHeader;
        }
        if (header == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String[] lines = header.split("\r?\n", -1);
        boolean startedHeader = false;
        int i = lines.length - 1;
        while (i >= 0) {
            builder.insert(0, "\n");
            if (startedHeader || lines[i].length() != 0) {
                builder.insert(0, lines[i]);
                builder.insert(0, COMMENT_PREFIX);
                startedHeader = true;
            }
            --i;
        }
        return builder.toString();
    }

    @Override
    public YamlConfigurationOptions options() {
        if (this.options == null) {
            this.options = new YamlConfigurationOptions(this);
        }
        return (YamlConfigurationOptions)this.options;
    }

    public static YamlConfiguration loadConfiguration(File file) {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            ProxyServer.getInstance().getLogger().log(Level.SEVERE, "Cannot load " + file, ex);
        }
        catch (InvalidConfigurationException ex) {
            ProxyServer.getInstance().getLogger().log(Level.SEVERE, "Cannot load " + file, ex);
        }
        return config;
    }

    public static YamlConfiguration loadConfiguration(InputStream stream) {
        Preconditions.checkNotNull((Object)stream, (Object)"Stream cannot be null");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(stream);
        }
        catch (IOException ex) {
            ProxyServer.getInstance().getLogger().log(Level.SEVERE, "Cannot load configuration from stream", ex);
        }
        catch (InvalidConfigurationException ex) {
            ProxyServer.getInstance().getLogger().log(Level.SEVERE, "Cannot load configuration from stream", ex);
        }
        return config;
    }

    protected String buildComment(String comment) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = comment.split("\r?\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            builder.append(COMMENT_PREFIX);
            builder.append(line);
            builder.append('\n');
            ++n2;
        }
        return builder.toString();
    }
}

