/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter.auth;

import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class OAuth2Token
implements Serializable {
    private static final long serialVersionUID = -8985359441959903216L;
    private String tokenType;
    private String accessToken;

    OAuth2Token(HttpResponse httpResponse) {
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.tokenType = OAuth2Token.getRawString("token_type", jSONObject);
        try {
            this.accessToken = URLDecoder.decode(OAuth2Token.getRawString("access_token", jSONObject), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public OAuth2Token(String string, String string2) {
        this.tokenType = string;
        this.accessToken = string2;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    String generateAuthorizationHeader() {
        String string = "";
        try {
            string = URLEncoder.encode(this.accessToken, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "Bearer " + string;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof OAuth2Token)) {
            return false;
        }
        OAuth2Token oAuth2Token = (OAuth2Token)object;
        if (this.tokenType != null ? !this.tokenType.equals(oAuth2Token.tokenType) : oAuth2Token.tokenType != null) {
            return false;
        }
        return !(this.accessToken != null ? !this.accessToken.equals(oAuth2Token.accessToken) : oAuth2Token.accessToken != null);
    }

    public int hashCode() {
        int n2 = this.tokenType != null ? this.tokenType.hashCode() : 0;
        n2 = 31 * n2 + (this.accessToken != null ? this.accessToken.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "OAuth2Token{tokenType='" + this.tokenType + '\'' + ", accessToken='" + this.accessToken + '\'' + '}';
    }

    private static String getRawString(String string, JSONObject jSONObject) {
        try {
            if (jSONObject.isNull(string)) {
                return null;
            }
            return jSONObject.getString(string);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }
}

