/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.AccountSettings;
import be.maximvdw.tabcore.twitter.Category;
import be.maximvdw.tabcore.twitter.DirectMessage;
import be.maximvdw.tabcore.twitter.Friendship;
import be.maximvdw.tabcore.twitter.GeoLocation;
import be.maximvdw.tabcore.twitter.GeoQuery;
import be.maximvdw.tabcore.twitter.HttpParameter;
import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.IDs;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.Location;
import be.maximvdw.tabcore.twitter.OEmbed;
import be.maximvdw.tabcore.twitter.OEmbedRequest;
import be.maximvdw.tabcore.twitter.PagableResponseList;
import be.maximvdw.tabcore.twitter.Paging;
import be.maximvdw.tabcore.twitter.Place;
import be.maximvdw.tabcore.twitter.Query;
import be.maximvdw.tabcore.twitter.QueryResult;
import be.maximvdw.tabcore.twitter.RateLimitStatus;
import be.maximvdw.tabcore.twitter.Relationship;
import be.maximvdw.tabcore.twitter.ResponseList;
import be.maximvdw.tabcore.twitter.SavedSearch;
import be.maximvdw.tabcore.twitter.Status;
import be.maximvdw.tabcore.twitter.StatusUpdate;
import be.maximvdw.tabcore.twitter.StringUtil;
import be.maximvdw.tabcore.twitter.Trends;
import be.maximvdw.tabcore.twitter.Twitter;
import be.maximvdw.tabcore.twitter.TwitterAPIConfiguration;
import be.maximvdw.tabcore.twitter.TwitterAPIMonitor;
import be.maximvdw.tabcore.twitter.TwitterBaseImpl;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.UploadedMedia;
import be.maximvdw.tabcore.twitter.User;
import be.maximvdw.tabcore.twitter.UserList;
import be.maximvdw.tabcore.twitter.api.DirectMessagesResources;
import be.maximvdw.tabcore.twitter.api.FavoritesResources;
import be.maximvdw.tabcore.twitter.api.FriendsFollowersResources;
import be.maximvdw.tabcore.twitter.api.HelpResources;
import be.maximvdw.tabcore.twitter.api.ListsResources;
import be.maximvdw.tabcore.twitter.api.PlacesGeoResources;
import be.maximvdw.tabcore.twitter.api.SavedSearchesResources;
import be.maximvdw.tabcore.twitter.api.SearchResource;
import be.maximvdw.tabcore.twitter.api.SpamReportingResource;
import be.maximvdw.tabcore.twitter.api.SuggestedUsersResources;
import be.maximvdw.tabcore.twitter.api.TimelinesResources;
import be.maximvdw.tabcore.twitter.api.TrendsResources;
import be.maximvdw.tabcore.twitter.api.TweetsResources;
import be.maximvdw.tabcore.twitter.api.UsersResources;
import be.maximvdw.tabcore.twitter.auth.Authorization;
import be.maximvdw.tabcore.twitter.conf.Configuration;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TwitterImpl
extends TwitterBaseImpl
implements Twitter {
    private static final long serialVersionUID = 9170943084096085770L;
    private final String IMPLICIT_PARAMS_STR;
    private final HttpParameter[] IMPLICIT_PARAMS;
    private final HttpParameter INCLUDE_MY_RETWEET;
    private static final ConcurrentHashMap<Configuration, HttpParameter[]> implicitParamsMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Configuration, String> implicitParamsStrMap = new ConcurrentHashMap();

    TwitterImpl(Configuration configuration, Authorization authorization) {
        super(configuration, authorization);
        this.INCLUDE_MY_RETWEET = new HttpParameter("include_my_retweet", configuration.isIncludeMyRetweetEnabled());
        if (implicitParamsMap.containsKey(configuration)) {
            this.IMPLICIT_PARAMS = implicitParamsMap.get(configuration);
            this.IMPLICIT_PARAMS_STR = implicitParamsStrMap.get(configuration);
        } else {
            boolean bl2;
            String string = configuration.isIncludeEntitiesEnabled() ? "include_entities=true" : "";
            boolean bl3 = bl2 = configuration.getContributingTo() != -1L;
            if (bl2) {
                if (!"".equals(string)) {
                    string = string + "?";
                }
                string = string + "contributingto=" + configuration.getContributingTo();
            }
            ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>(3);
            if (configuration.isIncludeEntitiesEnabled()) {
                arrayList.add(new HttpParameter("include_entities", "true"));
            }
            if (bl2) {
                arrayList.add(new HttpParameter("contributingto", configuration.getContributingTo()));
            }
            if (configuration.isTrimUserEnabled()) {
                arrayList.add(new HttpParameter("trim_user", "1"));
            }
            HttpParameter[] httpParameterArray = arrayList.toArray(new HttpParameter[arrayList.size()]);
            implicitParamsStrMap.putIfAbsent(configuration, string);
            implicitParamsMap.putIfAbsent(configuration, httpParameterArray);
            this.IMPLICIT_PARAMS = httpParameterArray;
            this.IMPLICIT_PARAMS_STR = string;
        }
    }

    @Override
    public ResponseList<Status> getMentionsTimeline() {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/mentions_timeline.json"));
    }

    @Override
    public ResponseList<Status> getMentionsTimeline(Paging paging) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/mentions_timeline.json", paging.asPostParameterArray()));
    }

    @Override
    public ResponseList<Status> getHomeTimeline() {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/home_timeline.json", this.INCLUDE_MY_RETWEET));
    }

    @Override
    public ResponseList<Status> getHomeTimeline(Paging paging) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/home_timeline.json", this.mergeParameters(paging.asPostParameterArray(), new HttpParameter[]{this.INCLUDE_MY_RETWEET})));
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe() {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/retweets_of_me.json"));
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe(Paging paging) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/retweets_of_me.json", paging.asPostParameterArray()));
    }

    @Override
    public ResponseList<Status> getUserTimeline(String string, Paging paging) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/user_timeline.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("screen_name", string), this.INCLUDE_MY_RETWEET}, paging.asPostParameterArray())));
    }

    @Override
    public ResponseList<Status> getUserTimeline(long l2, Paging paging) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/user_timeline.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("user_id", l2), this.INCLUDE_MY_RETWEET}, paging.asPostParameterArray())));
    }

    @Override
    public ResponseList<Status> getUserTimeline(String string) {
        return this.getUserTimeline(string, new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline(long l2) {
        return this.getUserTimeline(l2, new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline() {
        return this.getUserTimeline(new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline(Paging paging) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/user_timeline.json", this.mergeParameters(new HttpParameter[]{this.INCLUDE_MY_RETWEET}, paging.asPostParameterArray())));
    }

    @Override
    public ResponseList<Status> getRetweets(long l2) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/retweets/" + l2 + ".json?count=100"));
    }

    @Override
    public IDs getRetweeterIds(long l2, long l3) {
        return this.getRetweeterIds(l2, 100, l3);
    }

    @Override
    public IDs getRetweeterIds(long l2, int n2, long l3) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "statuses/retweeters/ids.json?id=" + l2 + "&cursor=" + l3 + "&count=" + n2));
    }

    @Override
    public Status showStatus(long l2) {
        return this.factory.createStatus(this.get(this.conf.getRestBaseURL() + "statuses/show/" + l2 + ".json", this.INCLUDE_MY_RETWEET));
    }

    @Override
    public Status destroyStatus(long l2) {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/destroy/" + l2 + ".json"));
    }

    @Override
    public Status updateStatus(String string) {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/update.json", new HttpParameter("status", string)));
    }

    @Override
    public Status updateStatus(StatusUpdate statusUpdate) {
        String string = this.conf.getRestBaseURL() + (statusUpdate.isForUpdateWithMedia() ? "statuses/update_with_media.json" : "statuses/update.json");
        return this.factory.createStatus(this.post(string, statusUpdate.asHttpParameterArray()));
    }

    @Override
    public Status retweetStatus(long l2) {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/retweet/" + l2 + ".json"));
    }

    @Override
    public OEmbed getOEmbed(OEmbedRequest oEmbedRequest) {
        return this.factory.createOEmbed(this.get(this.conf.getRestBaseURL() + "statuses/oembed.json", oEmbedRequest.asHttpParameterArray()));
    }

    @Override
    public ResponseList<Status> lookup(long ... lArray) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/lookup.json?id=" + StringUtil.join(lArray)));
    }

    @Override
    public UploadedMedia uploadMedia(File file) {
        this.checkFileValidity(file);
        return new UploadedMedia(this.post(this.conf.getUploadBaseURL() + "media/upload.json", new HttpParameter("media", file)).asJSONObject());
    }

    @Override
    public UploadedMedia uploadMedia(String string, InputStream inputStream) {
        return new UploadedMedia(this.post(this.conf.getUploadBaseURL() + "media/upload.json", new HttpParameter("media", string, inputStream)).asJSONObject());
    }

    @Override
    public QueryResult search(Query query) {
        if (query.nextPage() != null) {
            return this.factory.createQueryResult(this.get(this.conf.getRestBaseURL() + "search/tweets.json" + query.nextPage()), query);
        }
        return this.factory.createQueryResult(this.get(this.conf.getRestBaseURL() + "search/tweets.json", query.asHttpParameterArray()), query);
    }

    @Override
    public ResponseList<DirectMessage> getDirectMessages() {
        return this.factory.createDirectMessageList(this.get(this.conf.getRestBaseURL() + "direct_messages.json?full_text=true"));
    }

    @Override
    public ResponseList<DirectMessage> getDirectMessages(Paging paging) {
        return this.factory.createDirectMessageList(this.get(this.conf.getRestBaseURL() + "direct_messages.json", this.mergeParameters(paging.asPostParameterArray(), new HttpParameter("full_text", true))));
    }

    @Override
    public ResponseList<DirectMessage> getSentDirectMessages() {
        return this.factory.createDirectMessageList(this.get(this.conf.getRestBaseURL() + "direct_messages/sent.json?full_text=true"));
    }

    @Override
    public ResponseList<DirectMessage> getSentDirectMessages(Paging paging) {
        return this.factory.createDirectMessageList(this.get(this.conf.getRestBaseURL() + "direct_messages/sent.json", this.mergeParameters(paging.asPostParameterArray(), new HttpParameter("full_text", true))));
    }

    @Override
    public DirectMessage showDirectMessage(long l2) {
        return this.factory.createDirectMessage(this.get(this.conf.getRestBaseURL() + "direct_messages/show.json?id=" + l2 + "&full_text=true"));
    }

    @Override
    public DirectMessage destroyDirectMessage(long l2) {
        return this.factory.createDirectMessage(this.post(this.conf.getRestBaseURL() + "direct_messages/destroy.json?id=" + l2 + "&full_text=true"));
    }

    @Override
    public DirectMessage sendDirectMessage(long l2, String string) {
        return this.factory.createDirectMessage(this.post(this.conf.getRestBaseURL() + "direct_messages/new.json", new HttpParameter("user_id", l2), new HttpParameter("text", string), new HttpParameter("full_text", true)));
    }

    @Override
    public DirectMessage sendDirectMessage(String string, String string2) {
        return this.factory.createDirectMessage(this.post(this.conf.getRestBaseURL() + "direct_messages/new.json", new HttpParameter("screen_name", string), new HttpParameter("text", string2), new HttpParameter("full_text", true)));
    }

    @Override
    public InputStream getDMImageAsStream(String string) {
        return this.get(string).asStream();
    }

    @Override
    public IDs getNoRetweetsFriendships() {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friendships/no_retweets/ids.json"));
    }

    @Override
    public IDs getFriendsIDs(long l2) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json?cursor=" + l2));
    }

    @Override
    public IDs getFriendsIDs(long l2, long l3) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json?user_id=" + l2 + "&cursor=" + l3));
    }

    @Override
    public IDs getFriendsIDs(long l2, long l3, int n2) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json?user_id=" + l2 + "&cursor=" + l3 + "&count=" + n2));
    }

    @Override
    public IDs getFriendsIDs(String string, long l2) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json", new HttpParameter("screen_name", string), new HttpParameter("cursor", l2)));
    }

    @Override
    public IDs getFriendsIDs(String string, long l2, int n2) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json", new HttpParameter("screen_name", string), new HttpParameter("cursor", l2), new HttpParameter("count", n2)));
    }

    @Override
    public IDs getFollowersIDs(long l2) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json?cursor=" + l2));
    }

    @Override
    public IDs getFollowersIDs(long l2, long l3) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json?user_id=" + l2 + "&cursor=" + l3));
    }

    @Override
    public IDs getFollowersIDs(long l2, long l3, int n2) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json?user_id=" + l2 + "&cursor=" + l3 + "&count=" + n2));
    }

    @Override
    public IDs getFollowersIDs(String string, long l2) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json", new HttpParameter("screen_name", string), new HttpParameter("cursor", l2)));
    }

    @Override
    public IDs getFollowersIDs(String string, long l2, int n2) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json", new HttpParameter("screen_name", string), new HttpParameter("cursor", l2), new HttpParameter("count", n2)));
    }

    @Override
    public ResponseList<Friendship> lookupFriendships(long ... lArray) {
        return this.factory.createFriendshipList(this.get(this.conf.getRestBaseURL() + "friendships/lookup.json?user_id=" + StringUtil.join(lArray)));
    }

    @Override
    public ResponseList<Friendship> lookupFriendships(String ... stringArray) {
        return this.factory.createFriendshipList(this.get(this.conf.getRestBaseURL() + "friendships/lookup.json?screen_name=" + StringUtil.join(stringArray)));
    }

    @Override
    public IDs getIncomingFriendships(long l2) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friendships/incoming.json?cursor=" + l2));
    }

    @Override
    public IDs getOutgoingFriendships(long l2) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friendships/outgoing.json?cursor=" + l2));
    }

    @Override
    public User createFriendship(long l2) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/create.json?user_id=" + l2));
    }

    @Override
    public User createFriendship(String string) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/create.json", new HttpParameter("screen_name", string)));
    }

    @Override
    public User createFriendship(long l2, boolean bl2) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/create.json?user_id=" + l2 + "&follow=" + bl2));
    }

    @Override
    public User createFriendship(String string, boolean bl2) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/create.json", new HttpParameter("screen_name", string), new HttpParameter("follow", bl2)));
    }

    @Override
    public User destroyFriendship(long l2) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/destroy.json?user_id=" + l2));
    }

    @Override
    public User destroyFriendship(String string) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/destroy.json", new HttpParameter("screen_name", string)));
    }

    @Override
    public Relationship updateFriendship(long l2, boolean bl2, boolean bl3) {
        return this.factory.createRelationship(this.post(this.conf.getRestBaseURL() + "friendships/update.json", new HttpParameter("user_id", l2), new HttpParameter("device", bl2), new HttpParameter("retweets", bl3)));
    }

    @Override
    public Relationship updateFriendship(String string, boolean bl2, boolean bl3) {
        return this.factory.createRelationship(this.post(this.conf.getRestBaseURL() + "friendships/update.json", new HttpParameter("screen_name", string), new HttpParameter("device", bl2), new HttpParameter("retweets", bl3)));
    }

    @Override
    public Relationship showFriendship(long l2, long l3) {
        return this.factory.createRelationship(this.get(this.conf.getRestBaseURL() + "friendships/show.json", new HttpParameter("source_id", l2), new HttpParameter("target_id", l3)));
    }

    @Override
    public Relationship showFriendship(String string, String string2) {
        return this.factory.createRelationship(this.get(this.conf.getRestBaseURL() + "friendships/show.json", HttpParameter.getParameterArray("source_screen_name", string, "target_screen_name", string2)));
    }

    @Override
    public PagableResponseList<User> getFriendsList(long l2, long l3) {
        return this.getFriendsList(l2, l3, 20);
    }

    @Override
    public PagableResponseList<User> getFriendsList(long l2, long l3, int n2) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "friends/list.json?user_id=" + l2 + "&cursor=" + l3 + "&count=" + n2));
    }

    @Override
    public PagableResponseList<User> getFriendsList(String string, long l2) {
        return this.getFriendsList(string, l2, 20);
    }

    @Override
    public PagableResponseList<User> getFriendsList(String string, long l2, int n2) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "friends/list.json", new HttpParameter("screen_name", string), new HttpParameter("cursor", l2), new HttpParameter("count", n2)));
    }

    @Override
    public PagableResponseList<User> getFriendsList(long l2, long l3, int n2, boolean bl2, boolean bl3) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "friends/list.json?user_id=" + l2 + "&cursor=" + l3 + "&count=" + n2 + "&skip_status=" + bl2 + "&include_user_entities=" + bl3));
    }

    @Override
    public PagableResponseList<User> getFriendsList(String string, long l2, int n2, boolean bl2, boolean bl3) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "friends/list.json", new HttpParameter("screen_name", string), new HttpParameter("cursor", l2), new HttpParameter("count", n2), new HttpParameter("skip_status", bl2), new HttpParameter("include_user_entities", bl3)));
    }

    @Override
    public PagableResponseList<User> getFollowersList(long l2, long l3) {
        return this.getFollowersList(l2, l3, 20);
    }

    @Override
    public PagableResponseList<User> getFollowersList(String string, long l2) {
        return this.getFollowersList(string, l2, 20);
    }

    @Override
    public PagableResponseList<User> getFollowersList(long l2, long l3, int n2) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "followers/list.json?user_id=" + l2 + "&cursor=" + l3 + "&count=" + n2));
    }

    @Override
    public PagableResponseList<User> getFollowersList(String string, long l2, int n2) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "followers/list.json", new HttpParameter("screen_name", string), new HttpParameter("cursor", l2), new HttpParameter("count", n2)));
    }

    @Override
    public PagableResponseList<User> getFollowersList(long l2, long l3, int n2, boolean bl2, boolean bl3) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "followers/list.json?user_id=" + l2 + "&cursor=" + l3 + "&count=" + n2 + "&skip_status=" + bl2 + "&include_user_entities=" + bl3));
    }

    @Override
    public PagableResponseList<User> getFollowersList(String string, long l2, int n2, boolean bl2, boolean bl3) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "followers/list.json", new HttpParameter("screen_name", string), new HttpParameter("cursor", l2), new HttpParameter("count", n2), new HttpParameter("skip_status", bl2), new HttpParameter("include_user_entities", bl3)));
    }

    @Override
    public AccountSettings getAccountSettings() {
        return this.factory.createAccountSettings(this.get(this.conf.getRestBaseURL() + "account/settings.json"));
    }

    @Override
    public User verifyCredentials() {
        return super.fillInIDAndScreenName();
    }

    @Override
    public AccountSettings updateAccountSettings(Integer n2, Boolean bl2, String string, String string2, String string3, String string4) {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>(6);
        if (n2 != null) {
            arrayList.add(new HttpParameter("trend_location_woeid", n2));
        }
        if (bl2 != null) {
            arrayList.add(new HttpParameter("sleep_time_enabled", bl2.toString()));
        }
        if (string != null) {
            arrayList.add(new HttpParameter("start_sleep_time", string));
        }
        if (string2 != null) {
            arrayList.add(new HttpParameter("end_sleep_time", string2));
        }
        if (string3 != null) {
            arrayList.add(new HttpParameter("time_zone", string3));
        }
        if (string4 != null) {
            arrayList.add(new HttpParameter("lang", string4));
        }
        return this.factory.createAccountSettings(this.post(this.conf.getRestBaseURL() + "account/settings.json", arrayList.toArray(new HttpParameter[arrayList.size()])));
    }

    @Override
    public User updateProfile(String string, String string2, String string3, String string4) {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>(4);
        this.addParameterToList(arrayList, "name", string);
        this.addParameterToList(arrayList, "url", string2);
        this.addParameterToList(arrayList, "location", string3);
        this.addParameterToList(arrayList, "description", string4);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile.json", arrayList.toArray(new HttpParameter[arrayList.size()])));
    }

    @Override
    public User updateProfileBackgroundImage(File file, boolean bl2) {
        this.checkFileValidity(file);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_background_image.json", new HttpParameter("image", file), new HttpParameter("tile", bl2)));
    }

    @Override
    public User updateProfileBackgroundImage(InputStream inputStream, boolean bl2) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_background_image.json", new HttpParameter("image", "image", inputStream), new HttpParameter("tile", bl2)));
    }

    @Override
    public User updateProfileColors(String string, String string2, String string3, String string4, String string5) {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>(6);
        this.addParameterToList(arrayList, "profile_background_color", string);
        this.addParameterToList(arrayList, "profile_text_color", string2);
        this.addParameterToList(arrayList, "profile_link_color", string3);
        this.addParameterToList(arrayList, "profile_sidebar_fill_color", string4);
        this.addParameterToList(arrayList, "profile_sidebar_border_color", string5);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_colors.json", arrayList.toArray(new HttpParameter[arrayList.size()])));
    }

    private void addParameterToList(List<HttpParameter> list, String string, String string2) {
        if (string2 != null) {
            list.add(new HttpParameter(string, string2));
        }
    }

    @Override
    public User updateProfileImage(File file) {
        this.checkFileValidity(file);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_image.json", new HttpParameter("image", file)));
    }

    @Override
    public User updateProfileImage(InputStream inputStream) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_image.json", new HttpParameter("image", "image", inputStream)));
    }

    private void checkFileValidity(File file) {
        if (!file.exists()) {
            throw new TwitterException(new FileNotFoundException(file + " is not found."));
        }
        if (!file.isFile()) {
            throw new TwitterException(new IOException(file + " is not a file."));
        }
    }

    @Override
    public PagableResponseList<User> getBlocksList() {
        return this.getBlocksList(-1L);
    }

    @Override
    public PagableResponseList<User> getBlocksList(long l2) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "blocks/list.json?cursor=" + l2));
    }

    @Override
    public IDs getBlocksIDs() {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "blocks/ids.json"));
    }

    @Override
    public IDs getBlocksIDs(long l2) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "blocks/ids.json?cursor=" + l2));
    }

    @Override
    public User createBlock(long l2) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/create.json?user_id=" + l2));
    }

    @Override
    public User createBlock(String string) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/create.json", new HttpParameter("screen_name", string)));
    }

    @Override
    public User destroyBlock(long l2) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/destroy.json?user_id=" + l2));
    }

    @Override
    public User destroyBlock(String string) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/destroy.json", new HttpParameter("screen_name", string)));
    }

    @Override
    public PagableResponseList<User> getMutesList(long l2) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "mutes/users/list.json?cursor=" + l2));
    }

    @Override
    public IDs getMutesIDs(long l2) {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "mutes/users/ids.json?cursor=" + l2));
    }

    @Override
    public User createMute(long l2) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "mutes/users/create.json?user_id=" + l2));
    }

    @Override
    public User createMute(String string) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "mutes/users/create.json", new HttpParameter("screen_name", string)));
    }

    @Override
    public User destroyMute(long l2) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "mutes/users/destroy.json?user_id=" + l2));
    }

    @Override
    public User destroyMute(String string) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "mutes/users/destroy.json", new HttpParameter("screen_name", string)));
    }

    @Override
    public ResponseList<User> lookupUsers(long ... lArray) {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/lookup.json", new HttpParameter("user_id", StringUtil.join(lArray))));
    }

    @Override
    public ResponseList<User> lookupUsers(String ... stringArray) {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/lookup.json", new HttpParameter("screen_name", StringUtil.join(stringArray))));
    }

    @Override
    public User showUser(long l2) {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "users/show.json?user_id=" + l2));
    }

    @Override
    public User showUser(String string) {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "users/show.json", new HttpParameter("screen_name", string)));
    }

    @Override
    public ResponseList<User> searchUsers(String string, int n2) {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/search.json", new HttpParameter("q", string), new HttpParameter("per_page", 20), new HttpParameter("page", n2)));
    }

    @Override
    public ResponseList<User> getContributees(long l2) {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributees.json?user_id=" + l2));
    }

    @Override
    public ResponseList<User> getContributees(String string) {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributees.json", new HttpParameter("screen_name", string)));
    }

    @Override
    public ResponseList<User> getContributors(long l2) {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributors.json?user_id=" + l2));
    }

    @Override
    public ResponseList<User> getContributors(String string) {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributors.json", new HttpParameter("screen_name", string)));
    }

    @Override
    public void removeProfileBanner() {
        this.post(this.conf.getRestBaseURL() + "account/remove_profile_banner.json");
    }

    @Override
    public void updateProfileBanner(File file) {
        this.checkFileValidity(file);
        this.post(this.conf.getRestBaseURL() + "account/update_profile_banner.json", new HttpParameter("banner", file));
    }

    @Override
    public void updateProfileBanner(InputStream inputStream) {
        this.post(this.conf.getRestBaseURL() + "account/update_profile_banner.json", new HttpParameter("banner", "banner", inputStream));
    }

    @Override
    public ResponseList<User> getUserSuggestions(String string) {
        HttpResponse httpResponse;
        try {
            httpResponse = this.get(this.conf.getRestBaseURL() + "users/suggestions/" + URLEncoder.encode(string, "UTF-8") + ".json");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return this.factory.createUserListFromJSONArray_Users(httpResponse);
    }

    @Override
    public ResponseList<Category> getSuggestedUserCategories() {
        return this.factory.createCategoryList(this.get(this.conf.getRestBaseURL() + "users/suggestions.json"));
    }

    @Override
    public ResponseList<User> getMemberSuggestions(String string) {
        HttpResponse httpResponse;
        try {
            httpResponse = this.get(this.conf.getRestBaseURL() + "users/suggestions/" + URLEncoder.encode(string, "UTF-8") + "/members.json");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return this.factory.createUserListFromJSONArray(httpResponse);
    }

    @Override
    public ResponseList<Status> getFavorites() {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json"));
    }

    @Override
    public ResponseList<Status> getFavorites(long l2) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json?user_id=" + l2));
    }

    @Override
    public ResponseList<Status> getFavorites(String string) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json", new HttpParameter("screen_name", string)));
    }

    @Override
    public ResponseList<Status> getFavorites(Paging paging) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json", paging.asPostParameterArray()));
    }

    @Override
    public ResponseList<Status> getFavorites(long l2, Paging paging) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("user_id", l2)}, paging.asPostParameterArray())));
    }

    @Override
    public ResponseList<Status> getFavorites(String string, Paging paging) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("screen_name", string)}, paging.asPostParameterArray())));
    }

    @Override
    public Status destroyFavorite(long l2) {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "favorites/destroy.json?id=" + l2));
    }

    @Override
    public Status createFavorite(long l2) {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "favorites/create.json?id=" + l2));
    }

    @Override
    public ResponseList<UserList> getUserLists(String string) {
        return this.getUserLists(string, false);
    }

    @Override
    public ResponseList<UserList> getUserLists(String string, boolean bl2) {
        return this.factory.createUserListList(this.get(this.conf.getRestBaseURL() + "lists/list.json", new HttpParameter("screen_name", string), new HttpParameter("reverse", bl2)));
    }

    @Override
    public ResponseList<UserList> getUserLists(long l2) {
        return this.getUserLists(l2, false);
    }

    @Override
    public ResponseList<UserList> getUserLists(long l2, boolean bl2) {
        return this.factory.createUserListList(this.get(this.conf.getRestBaseURL() + "lists/list.json", new HttpParameter("user_id", l2), new HttpParameter("reverse", bl2)));
    }

    @Override
    public ResponseList<Status> getUserListStatuses(long l2, Paging paging) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "lists/statuses.json", this.mergeParameters(paging.asPostParameterArray(Paging.SMCP, "count"), new HttpParameter("list_id", l2))));
    }

    @Override
    public ResponseList<Status> getUserListStatuses(long l2, String string, Paging paging) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "lists/statuses.json", this.mergeParameters(paging.asPostParameterArray(Paging.SMCP, "count"), new HttpParameter[]{new HttpParameter("owner_id", l2), new HttpParameter("slug", string)})));
    }

    @Override
    public ResponseList<Status> getUserListStatuses(String string, String string2, Paging paging) {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "lists/statuses.json", this.mergeParameters(paging.asPostParameterArray(Paging.SMCP, "count"), new HttpParameter[]{new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2)})));
    }

    @Override
    public UserList destroyUserListMember(long l2, long l3) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy.json", new HttpParameter("list_id", l2), new HttpParameter("user_id", l3)));
    }

    @Override
    public UserList destroyUserListMember(long l2, String string, long l3) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy.json", new HttpParameter("owner_id", l2), new HttpParameter("slug", string), new HttpParameter("user_id", l3)));
    }

    @Override
    public UserList destroyUserListMember(long l2, String string) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy.json", new HttpParameter("list_id", l2), new HttpParameter("screen_name", string)));
    }

    @Override
    public UserList destroyUserListMember(String string, String string2, long l2) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy.json", new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2), new HttpParameter("user_id", l2)));
    }

    @Override
    public UserList destroyUserListMembers(long l2, String[] stringArray) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy_all.json", new HttpParameter("list_id", l2), new HttpParameter("screen_name", StringUtil.join(stringArray))));
    }

    @Override
    public UserList destroyUserListMembers(long l2, long[] lArray) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy_all.json", new HttpParameter("list_id", l2), new HttpParameter("user_id", StringUtil.join(lArray))));
    }

    @Override
    public UserList destroyUserListMembers(String string, String string2, String[] stringArray) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy_all.json", new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2), new HttpParameter("screen_name", StringUtil.join(stringArray))));
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long l2) {
        return this.getUserListMemberships(20, l2);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(int n2, long l2) {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/memberships.json", new HttpParameter("cursor", l2), new HttpParameter("count", n2)));
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String string, long l2) {
        return this.getUserListMemberships(string, l2, false);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String string, int n2, long l2) {
        return this.getUserListMemberships(string, n2, l2, false);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String string, long l2, boolean bl2) {
        return this.getUserListMemberships(string, 20, l2, bl2);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String string, int n2, long l2, boolean bl2) {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/memberships.json", new HttpParameter("screen_name", string), new HttpParameter("count", n2), new HttpParameter("cursor", l2), new HttpParameter("filter_to_owned_lists", bl2)));
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long l2, long l3) {
        return this.getUserListMemberships(l2, l3, false);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long l2, int n2, long l3) {
        return this.getUserListMemberships(l2, n2, l3, false);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long l2, long l3, boolean bl2) {
        return this.getUserListMemberships(l2, 20, l3, bl2);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long l2, int n2, long l3, boolean bl2) {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/memberships.json", new HttpParameter("user_id", l2), new HttpParameter("count", n2), new HttpParameter("cursor", l3), new HttpParameter("filter_to_owned_lists", bl2)));
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long l2, long l3) {
        return this.getUserListSubscribers(l2, 20, l3, false);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long l2, int n2, long l3) {
        return this.getUserListSubscribers(l2, n2, l3, false);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long l2, int n2, long l3, boolean bl2) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/subscribers.json", new HttpParameter("list_id", l2), new HttpParameter("count", n2), new HttpParameter("cursor", l3), new HttpParameter("skip_status", bl2)));
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long l2, String string, long l3) {
        return this.getUserListSubscribers(l2, string, 20, l3, false);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long l2, String string, int n2, long l3) {
        return this.getUserListSubscribers(l2, string, n2, l3, false);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long l2, String string, int n2, long l3, boolean bl2) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/subscribers.json", new HttpParameter("owner_id", l2), new HttpParameter("slug", string), new HttpParameter("count", n2), new HttpParameter("cursor", l3), new HttpParameter("skip_status", bl2)));
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(String string, String string2, long l2) {
        return this.getUserListSubscribers(string, string2, 20, l2, false);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(String string, String string2, int n2, long l2) {
        return this.getUserListSubscribers(string, string2, n2, l2, false);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(String string, String string2, int n2, long l2, boolean bl2) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/subscribers.json", new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2), new HttpParameter("count", n2), new HttpParameter("cursor", l2), new HttpParameter("skip_status", bl2)));
    }

    @Override
    public UserList createUserListSubscription(long l2) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/create.json", new HttpParameter("list_id", l2)));
    }

    @Override
    public UserList createUserListSubscription(long l2, String string) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/create.json", new HttpParameter("owner_id", l2), new HttpParameter("slug", string)));
    }

    @Override
    public UserList createUserListSubscription(String string, String string2) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/create.json", new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2)));
    }

    @Override
    public User showUserListSubscription(long l2, long l3) {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/subscribers/show.json?list_id=" + l2 + "&user_id=" + l3));
    }

    @Override
    public User showUserListSubscription(long l2, String string, long l3) {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/subscribers/show.json?owner_id=" + l2 + "&slug=" + string + "&user_id=" + l3));
    }

    @Override
    public User showUserListSubscription(String string, String string2, long l2) {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/subscribers/show.json", new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2), new HttpParameter("user_id", l2)));
    }

    @Override
    public UserList destroyUserListSubscription(long l2) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/destroy.json", new HttpParameter("list_id", l2)));
    }

    @Override
    public UserList destroyUserListSubscription(long l2, String string) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/destroy.json", new HttpParameter("owner_id", l2), new HttpParameter("slug", string)));
    }

    @Override
    public UserList destroyUserListSubscription(String string, String string2) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/destroy.json", new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2)));
    }

    @Override
    public UserList createUserListMembers(long l2, long ... lArray) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter("list_id", l2), new HttpParameter("user_id", StringUtil.join(lArray))));
    }

    @Override
    public UserList createUserListMembers(long l2, String string, long ... lArray) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter("owner_id", l2), new HttpParameter("slug", string), new HttpParameter("user_id", StringUtil.join(lArray))));
    }

    @Override
    public UserList createUserListMembers(String string, String string2, long ... lArray) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2), new HttpParameter("user_id", StringUtil.join(lArray))));
    }

    @Override
    public UserList createUserListMembers(long l2, String ... stringArray) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter("list_id", l2), new HttpParameter("screen_name", StringUtil.join(stringArray))));
    }

    @Override
    public UserList createUserListMembers(long l2, String string, String ... stringArray) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter("owner_id", l2), new HttpParameter("slug", string), new HttpParameter("screen_name", StringUtil.join(stringArray))));
    }

    @Override
    public UserList createUserListMembers(String string, String string2, String ... stringArray) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2), new HttpParameter("screen_name", StringUtil.join(stringArray))));
    }

    @Override
    public User showUserListMembership(long l2, long l3) {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/members/show.json?list_id=" + l2 + "&user_id=" + l3));
    }

    @Override
    public User showUserListMembership(long l2, String string, long l3) {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/members/show.json?owner_id=" + l2 + "&slug=" + string + "&user_id=" + l3));
    }

    @Override
    public User showUserListMembership(String string, String string2, long l2) {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/members/show.json", new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2), new HttpParameter("user_id", l2)));
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long l2, long l3) {
        return this.getUserListMembers(l2, 20, l3, false);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long l2, int n2, long l3) {
        return this.getUserListMembers(l2, n2, l3, false);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long l2, int n2, long l3, boolean bl2) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/members.json", new HttpParameter("list_id", l2), new HttpParameter("count", n2), new HttpParameter("cursor", l3), new HttpParameter("skip_status", bl2)));
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long l2, String string, long l3) {
        return this.getUserListMembers(l2, string, 20, l3, false);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long l2, String string, int n2, long l3) {
        return this.getUserListMembers(l2, string, n2, l3, false);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long l2, String string, int n2, long l3, boolean bl2) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/members.json", new HttpParameter("owner_id", l2), new HttpParameter("slug", string), new HttpParameter("count", n2), new HttpParameter("cursor", l3), new HttpParameter("skip_status", bl2)));
    }

    @Override
    public PagableResponseList<User> getUserListMembers(String string, String string2, long l2) {
        return this.getUserListMembers(string, string2, 20, l2, false);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(String string, String string2, int n2, long l2) {
        return this.getUserListMembers(string, string2, n2, l2, false);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(String string, String string2, int n2, long l2, boolean bl2) {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/members.json", new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2), new HttpParameter("count", n2), new HttpParameter("cursor", l2), new HttpParameter("skip_status", bl2)));
    }

    @Override
    public UserList createUserListMember(long l2, long l3) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create.json", new HttpParameter("user_id", l3), new HttpParameter("list_id", l2)));
    }

    @Override
    public UserList createUserListMember(long l2, String string, long l3) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create.json", new HttpParameter("user_id", l3), new HttpParameter("owner_id", l2), new HttpParameter("slug", string)));
    }

    @Override
    public UserList createUserListMember(String string, String string2, long l2) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create.json", new HttpParameter("user_id", l2), new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2)));
    }

    @Override
    public UserList destroyUserList(long l2) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/destroy.json", new HttpParameter("list_id", l2)));
    }

    @Override
    public UserList destroyUserList(long l2, String string) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/destroy.json", new HttpParameter("owner_id", l2), new HttpParameter("slug", string)));
    }

    @Override
    public UserList destroyUserList(String string, String string2) {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/destroy.json", new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2)));
    }

    @Override
    public UserList updateUserList(long l2, String string, boolean bl2, String string2) {
        return this.updateUserList(string, bl2, string2, new HttpParameter("list_id", l2));
    }

    @Override
    public UserList updateUserList(long l2, String string, String string2, boolean bl2, String string3) {
        return this.updateUserList(string2, bl2, string3, new HttpParameter("owner_id", l2), new HttpParameter("slug", string));
    }

    @Override
    public UserList updateUserList(String string, String string2, String string3, boolean bl2, String string4) {
        return this.updateUserList(string3, bl2, string4, new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2));
    }

    private UserList updateUserList(String string, boolean bl2, String string2, HttpParameter ... httpParameterArray) {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>();
        Collections.addAll(arrayList, httpParameterArray);
        if (string != null) {
            arrayList.add(new HttpParameter("name", string));
        }
        arrayList.add(new HttpParameter("mode", bl2 ? "public" : "private"));
        if (string2 != null) {
            arrayList.add(new HttpParameter("description", string2));
        }
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/update.json", arrayList.toArray(new HttpParameter[arrayList.size()])));
    }

    @Override
    public UserList createUserList(String string, boolean bl2, String string2) {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>();
        arrayList.add(new HttpParameter("name", string));
        arrayList.add(new HttpParameter("mode", bl2 ? "public" : "private"));
        if (string2 != null) {
            arrayList.add(new HttpParameter("description", string2));
        }
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/create.json", arrayList.toArray(new HttpParameter[arrayList.size()])));
    }

    @Override
    public UserList showUserList(long l2) {
        return this.factory.createAUserList(this.get(this.conf.getRestBaseURL() + "lists/show.json?list_id=" + l2));
    }

    @Override
    public UserList showUserList(long l2, String string) {
        return this.factory.createAUserList(this.get(this.conf.getRestBaseURL() + "lists/show.json?owner_id=" + l2 + "&slug=" + string));
    }

    @Override
    public UserList showUserList(String string, String string2) {
        return this.factory.createAUserList(this.get(this.conf.getRestBaseURL() + "lists/show.json", new HttpParameter("owner_screen_name", string), new HttpParameter("slug", string2)));
    }

    @Override
    public PagableResponseList<UserList> getUserListSubscriptions(String string, long l2) {
        return this.getUserListSubscriptions(string, 20, l2);
    }

    @Override
    public PagableResponseList<UserList> getUserListSubscriptions(String string, int n2, long l2) {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/subscriptions.json", new HttpParameter("screen_name", string), new HttpParameter("count", n2), new HttpParameter("cursor", l2)));
    }

    @Override
    public PagableResponseList<UserList> getUserListSubscriptions(long l2, long l3) {
        return this.getUserListSubscriptions(l2, 20, l3);
    }

    @Override
    public PagableResponseList<UserList> getUserListSubscriptions(long l2, int n2, long l3) {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/subscriptions.json", new HttpParameter("user_id", l2), new HttpParameter("count", n2), new HttpParameter("cursor", l3)));
    }

    @Override
    public PagableResponseList<UserList> getUserListsOwnerships(String string, long l2) {
        return this.getUserListsOwnerships(string, 20, l2);
    }

    @Override
    public PagableResponseList<UserList> getUserListsOwnerships(String string, int n2, long l2) {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/ownerships.json", new HttpParameter("screen_name", string), new HttpParameter("count", n2), new HttpParameter("cursor", l2)));
    }

    @Override
    public PagableResponseList<UserList> getUserListsOwnerships(long l2, long l3) {
        return this.getUserListsOwnerships(l2, 20, l3);
    }

    @Override
    public PagableResponseList<UserList> getUserListsOwnerships(long l2, int n2, long l3) {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/ownerships.json", new HttpParameter("user_id", l2), new HttpParameter("count", n2), new HttpParameter("cursor", l3)));
    }

    @Override
    public ResponseList<SavedSearch> getSavedSearches() {
        return this.factory.createSavedSearchList(this.get(this.conf.getRestBaseURL() + "saved_searches/list.json"));
    }

    @Override
    public SavedSearch showSavedSearch(long l2) {
        return this.factory.createSavedSearch(this.get(this.conf.getRestBaseURL() + "saved_searches/show/" + l2 + ".json"));
    }

    @Override
    public SavedSearch createSavedSearch(String string) {
        return this.factory.createSavedSearch(this.post(this.conf.getRestBaseURL() + "saved_searches/create.json", new HttpParameter("query", string)));
    }

    @Override
    public SavedSearch destroySavedSearch(long l2) {
        return this.factory.createSavedSearch(this.post(this.conf.getRestBaseURL() + "saved_searches/destroy/" + l2 + ".json"));
    }

    @Override
    public Place getGeoDetails(String string) {
        return this.factory.createPlace(this.get(this.conf.getRestBaseURL() + "geo/id/" + string + ".json"));
    }

    @Override
    public ResponseList<Place> reverseGeoCode(GeoQuery geoQuery) {
        try {
            return this.factory.createPlaceList(this.get(this.conf.getRestBaseURL() + "geo/reverse_geocode.json", geoQuery.asHttpParameterArray()));
        }
        catch (TwitterException twitterException) {
            if (twitterException.getStatusCode() == 404) {
                return this.factory.createEmptyResponseList();
            }
            throw twitterException;
        }
    }

    @Override
    public ResponseList<Place> searchPlaces(GeoQuery geoQuery) {
        return this.factory.createPlaceList(this.get(this.conf.getRestBaseURL() + "geo/search.json", geoQuery.asHttpParameterArray()));
    }

    @Override
    public ResponseList<Place> getSimilarPlaces(GeoLocation geoLocation, String string, String string2, String string3) {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>(3);
        arrayList.add(new HttpParameter("lat", geoLocation.getLatitude()));
        arrayList.add(new HttpParameter("long", geoLocation.getLongitude()));
        arrayList.add(new HttpParameter("name", string));
        if (string2 != null) {
            arrayList.add(new HttpParameter("contained_within", string2));
        }
        if (string3 != null) {
            arrayList.add(new HttpParameter("attribute:street_address", string3));
        }
        return this.factory.createPlaceList(this.get(this.conf.getRestBaseURL() + "geo/similar_places.json", arrayList.toArray(new HttpParameter[arrayList.size()])));
    }

    @Override
    public Trends getPlaceTrends(int n2) {
        return this.factory.createTrends(this.get(this.conf.getRestBaseURL() + "trends/place.json?id=" + n2));
    }

    @Override
    public ResponseList<Location> getAvailableTrends() {
        return this.factory.createLocationList(this.get(this.conf.getRestBaseURL() + "trends/available.json"));
    }

    @Override
    public ResponseList<Location> getClosestTrends(GeoLocation geoLocation) {
        return this.factory.createLocationList(this.get(this.conf.getRestBaseURL() + "trends/closest.json", new HttpParameter("lat", geoLocation.getLatitude()), new HttpParameter("long", geoLocation.getLongitude())));
    }

    @Override
    public User reportSpam(long l2) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "users/report_spam.json?user_id=" + l2));
    }

    @Override
    public User reportSpam(String string) {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "users/report_spam.json", new HttpParameter("screen_name", string)));
    }

    @Override
    public TwitterAPIConfiguration getAPIConfiguration() {
        return this.factory.createTwitterAPIConfiguration(this.get(this.conf.getRestBaseURL() + "help/configuration.json"));
    }

    @Override
    public ResponseList<HelpResources.Language> getLanguages() {
        return this.factory.createLanguageList(this.get(this.conf.getRestBaseURL() + "help/languages.json"));
    }

    @Override
    public String getPrivacyPolicy() {
        try {
            return this.get(this.conf.getRestBaseURL() + "help/privacy.json").asJSONObject().getString("privacy");
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    @Override
    public String getTermsOfService() {
        try {
            return this.get(this.conf.getRestBaseURL() + "help/tos.json").asJSONObject().getString("tos");
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    @Override
    public Map<String, RateLimitStatus> getRateLimitStatus() {
        return this.factory.createRateLimitStatuses(this.get(this.conf.getRestBaseURL() + "application/rate_limit_status.json"));
    }

    @Override
    public Map<String, RateLimitStatus> getRateLimitStatus(String ... stringArray) {
        return this.factory.createRateLimitStatuses(this.get(this.conf.getRestBaseURL() + "application/rate_limit_status.json?resources=" + StringUtil.join(stringArray)));
    }

    @Override
    public TimelinesResources timelines() {
        return this;
    }

    @Override
    public TweetsResources tweets() {
        return this;
    }

    @Override
    public SearchResource search() {
        return this;
    }

    @Override
    public DirectMessagesResources directMessages() {
        return this;
    }

    @Override
    public FriendsFollowersResources friendsFollowers() {
        return this;
    }

    @Override
    public UsersResources users() {
        return this;
    }

    @Override
    public SuggestedUsersResources suggestedUsers() {
        return this;
    }

    @Override
    public FavoritesResources favorites() {
        return this;
    }

    @Override
    public ListsResources list() {
        return this;
    }

    @Override
    public SavedSearchesResources savedSearches() {
        return this;
    }

    @Override
    public PlacesGeoResources placesGeo() {
        return this;
    }

    @Override
    public TrendsResources trends() {
        return this;
    }

    @Override
    public SpamReportingResource spamReporting() {
        return this;
    }

    @Override
    public HelpResources help() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse get(String string) {
        this.ensureAuthorizationEnabled();
        if (this.IMPLICIT_PARAMS_STR.length() > 0) {
            string = string.contains("?") ? string + "&" + this.IMPLICIT_PARAMS_STR : string + "?" + this.IMPLICIT_PARAMS_STR;
        }
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(string, null, this.auth, this);
        }
        HttpResponse httpResponse = null;
        long l2 = System.currentTimeMillis();
        try {
            httpResponse = this.http.get(string, null, this.auth, this);
        }
        finally {
            long l3 = System.currentTimeMillis() - l2;
            TwitterAPIMonitor.getInstance().methodCalled(string, l3, this.isOk(httpResponse));
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse get(String string, HttpParameter ... httpParameterArray) {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(string, this.mergeImplicitParams(httpParameterArray), this.auth, this);
        }
        HttpResponse httpResponse = null;
        long l2 = System.currentTimeMillis();
        try {
            httpResponse = this.http.get(string, this.mergeImplicitParams(httpParameterArray), this.auth, this);
        }
        finally {
            long l3 = System.currentTimeMillis() - l2;
            TwitterAPIMonitor.getInstance().methodCalled(string, l3, this.isOk(httpResponse));
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String string) {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(string, this.IMPLICIT_PARAMS, this.auth, this);
        }
        HttpResponse httpResponse = null;
        long l2 = System.currentTimeMillis();
        try {
            httpResponse = this.http.post(string, this.IMPLICIT_PARAMS, this.auth, this);
        }
        finally {
            long l3 = System.currentTimeMillis() - l2;
            TwitterAPIMonitor.getInstance().methodCalled(string, l3, this.isOk(httpResponse));
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String string, HttpParameter ... httpParameterArray) {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(string, this.mergeImplicitParams(httpParameterArray), this.auth, this);
        }
        HttpResponse httpResponse = null;
        long l2 = System.currentTimeMillis();
        try {
            httpResponse = this.http.post(string, this.mergeImplicitParams(httpParameterArray), this.auth, this);
        }
        finally {
            long l3 = System.currentTimeMillis() - l2;
            TwitterAPIMonitor.getInstance().methodCalled(string, l3, this.isOk(httpResponse));
        }
        return httpResponse;
    }

    private HttpParameter[] mergeParameters(HttpParameter[] httpParameterArray, HttpParameter[] httpParameterArray2) {
        if (httpParameterArray != null && httpParameterArray2 != null) {
            HttpParameter[] httpParameterArray3 = new HttpParameter[httpParameterArray.length + httpParameterArray2.length];
            System.arraycopy(httpParameterArray, 0, httpParameterArray3, 0, httpParameterArray.length);
            System.arraycopy(httpParameterArray2, 0, httpParameterArray3, httpParameterArray.length, httpParameterArray2.length);
            return httpParameterArray3;
        }
        if (null == httpParameterArray && null == httpParameterArray2) {
            return new HttpParameter[0];
        }
        if (httpParameterArray != null) {
            return httpParameterArray;
        }
        return httpParameterArray2;
    }

    private HttpParameter[] mergeParameters(HttpParameter[] httpParameterArray, HttpParameter httpParameter) {
        if (httpParameterArray != null && httpParameter != null) {
            HttpParameter[] httpParameterArray2 = new HttpParameter[httpParameterArray.length + 1];
            System.arraycopy(httpParameterArray, 0, httpParameterArray2, 0, httpParameterArray.length);
            httpParameterArray2[httpParameterArray2.length - 1] = httpParameter;
            return httpParameterArray2;
        }
        if (null == httpParameterArray && null == httpParameter) {
            return new HttpParameter[0];
        }
        if (httpParameterArray != null) {
            return httpParameterArray;
        }
        return new HttpParameter[]{httpParameter};
    }

    private HttpParameter[] mergeImplicitParams(HttpParameter ... httpParameterArray) {
        return this.mergeParameters(httpParameterArray, this.IMPLICIT_PARAMS);
    }

    private boolean isOk(HttpResponse httpResponse) {
        return httpResponse != null && httpResponse.getStatusCode() < 300;
    }

    @Override
    public String toString() {
        return "TwitterImpl{INCLUDE_MY_RETWEET=" + this.INCLUDE_MY_RETWEET + '}';
    }
}

