/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.ExceptionDiagnosis;
import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.HttpResponseCode;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONImplFactory;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.ParseUtil;
import be.maximvdw.tabcore.twitter.RateLimitStatus;
import be.maximvdw.tabcore.twitter.TwitterResponse;
import be.maximvdw.tabcore.twitter.Version;
import java.io.IOException;
import java.util.List;

public class TwitterException
extends Exception
implements HttpResponseCode,
TwitterResponse {
    private static final long serialVersionUID = 6006561839051121336L;
    private int statusCode = -1;
    private int errorCode = -1;
    private ExceptionDiagnosis exceptionDiagnosis = null;
    private HttpResponse response;
    private String errorMessage = null;
    private static final String[] FILTER = new String[]{"be.maximvdw.tabcore.twitter"};
    private boolean nested = false;

    public TwitterException(String string, Throwable throwable) {
        super(string, throwable);
        this.decode(string);
    }

    public TwitterException(String string) {
        this(string, (Throwable)null);
    }

    public TwitterException(Exception exception) {
        this(exception.getMessage(), exception);
        if (exception instanceof TwitterException) {
            ((TwitterException)exception).setNested();
        }
    }

    public TwitterException(String string, HttpResponse httpResponse) {
        this(string);
        this.response = httpResponse;
        this.statusCode = httpResponse.getStatusCode();
    }

    public TwitterException(String string, Exception exception, int n2) {
        this(string, exception);
        this.statusCode = n2;
    }

    public String getMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.errorMessage != null && this.errorCode != -1) {
            stringBuilder.append("message - ").append(this.errorMessage).append("\n");
            stringBuilder.append("code - ").append(this.errorCode).append("\n");
        } else {
            stringBuilder.append(super.getMessage());
        }
        if (this.statusCode != -1) {
            return TwitterException.getCause(this.statusCode) + "\n" + stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    private void decode(String string) {
        if (string != null && string.startsWith("{")) {
            try {
                JSONObject jSONObject = new JSONObject(string);
                if (!jSONObject.isNull("errors")) {
                    JSONObject jSONObject2 = jSONObject.getJSONArray("errors").getJSONObject(0);
                    this.errorMessage = jSONObject2.getString("message");
                    this.errorCode = ParseUtil.getInt("code", jSONObject2);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getResponseHeader(String string) {
        List<String> list;
        String string2 = null;
        if (this.response != null && (list = this.response.getResponseHeaderFields().get(string)).size() > 0) {
            string2 = list.get(0);
        }
        return string2;
    }

    public RateLimitStatus getRateLimitStatus() {
        if (null == this.response) {
            return null;
        }
        return JSONImplFactory.createRateLimitStatusFromResponseHeader(this.response);
    }

    public int getAccessLevel() {
        return ParseUtil.toAccessLevel(this.response);
    }

    public int getRetryAfter() {
        int n2 = -1;
        if (this.statusCode == 400) {
            RateLimitStatus rateLimitStatus = this.getRateLimitStatus();
            if (rateLimitStatus != null) {
                n2 = rateLimitStatus.getSecondsUntilReset();
            }
        } else if (this.statusCode == 420) {
            try {
                String string = this.response.getResponseHeader("Retry-After");
                if (string != null) {
                    n2 = Integer.valueOf(string);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    public boolean isCausedByNetworkIssue() {
        return this.getCause() instanceof IOException;
    }

    public boolean exceededRateLimitation() {
        return this.statusCode == 400 && this.getRateLimitStatus() != null || this.statusCode == 420 || this.statusCode == 429;
    }

    public boolean resourceNotFound() {
        return this.statusCode == 404;
    }

    public String getExceptionCode() {
        return this.getExceptionDiagnosis().asHexString();
    }

    private ExceptionDiagnosis getExceptionDiagnosis() {
        if (null == this.exceptionDiagnosis) {
            this.exceptionDiagnosis = new ExceptionDiagnosis(this, FILTER);
        }
        return this.exceptionDiagnosis;
    }

    void setNested() {
        this.nested = true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isErrorMessageAvailable() {
        return this.errorMessage != null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TwitterException twitterException = (TwitterException)object;
        if (this.errorCode != twitterException.errorCode) {
            return false;
        }
        if (this.nested != twitterException.nested) {
            return false;
        }
        if (this.statusCode != twitterException.statusCode) {
            return false;
        }
        if (this.errorMessage != null ? !this.errorMessage.equals(twitterException.errorMessage) : twitterException.errorMessage != null) {
            return false;
        }
        if (this.exceptionDiagnosis != null ? !this.exceptionDiagnosis.equals(twitterException.exceptionDiagnosis) : twitterException.exceptionDiagnosis != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals(twitterException.response) : twitterException.response != null);
    }

    public int hashCode() {
        int n2 = this.statusCode;
        n2 = 31 * n2 + this.errorCode;
        n2 = 31 * n2 + (this.exceptionDiagnosis != null ? this.exceptionDiagnosis.hashCode() : 0);
        n2 = 31 * n2 + (this.response != null ? this.response.hashCode() : 0);
        n2 = 31 * n2 + (this.errorMessage != null ? this.errorMessage.hashCode() : 0);
        n2 = 31 * n2 + (this.nested ? 1 : 0);
        return n2;
    }

    public String toString() {
        return this.getMessage() + (this.nested ? "" : "\nRelevant discussions can be found on the Internet at:\n\thttp://www.google.co.jp/search?q=" + this.getExceptionDiagnosis().getStackLineHashAsHex() + " or\n\thttp://www.google.co.jp/search?q=" + this.getExceptionDiagnosis().getLineNumberHashAsHex()) + "\nTwitterException{" + (this.nested ? "" : "exceptionCode=[" + this.getExceptionCode() + "], ") + "statusCode=" + this.statusCode + ", message=" + this.errorMessage + ", code=" + this.errorCode + ", retryAfter=" + this.getRetryAfter() + ", rateLimitStatus=" + this.getRateLimitStatus() + ", version=" + Version.getVersion() + '}';
    }

    private static String getCause(int n2) {
        String string;
        switch (n2) {
            case 304: {
                string = "There was no new data to return.";
                break;
            }
            case 400: {
                string = "The request was invalid. An accompanying error message will explain why. This is the status code will be returned during version 1.0 rate limiting(https://dev.twitter.com/pages/rate-limiting). In API v1.1, a request without authentication is considered invalid and you will get this response.";
                break;
            }
            case 401: {
                string = "Authentication credentials (https://dev.twitter.com/pages/auth) were missing or incorrect. Ensure that you have set valid consumer key/secret, access token/secret, and the system clock is in sync.";
                break;
            }
            case 403: {
                string = "The request is understood, but it has been refused. An accompanying error message will explain why. This code is used when requests are being denied due to update limits (https://support.twitter.com/articles/15364-about-twitter-limits-update-api-dm-and-following).";
                break;
            }
            case 404: {
                string = "The URI requested is invalid or the resource requested, such as a user, does not exists. Also returned when the requested format is not supported by the requested method.";
                break;
            }
            case 406: {
                string = "Returned by the Search API when an invalid format is specified in the request.\nReturned by the Streaming API when one or more of the parameters are not suitable for the resource. The track parameter, for example, would throw this error if:\n The track keyword is too long or too short.\n The bounding box specified is invalid.\n No predicates defined for filtered resource, for example, neither track nor follow parameter defined.\n Follow userid cannot be read.";
                break;
            }
            case 420: {
                string = "Returned by the Search and Trends API when you are being rate limited (https://dev.twitter.com/docs/rate-limiting).\nReturned by the Streaming API:\n Too many login attempts in a short period of time.\n Running too many copies of the same application authenticating with the same account name.";
                break;
            }
            case 422: {
                string = "Returned when an image uploaded to POST account/update_profile_banner(https://dev.twitter.com/docs/api/1/post/account/update_profile_banner) is unable to be processed.";
                break;
            }
            case 429: {
                string = "Returned in API v1.1 when a request cannot be served due to the application's rate limit having been exhausted for the resource. See Rate Limiting in API v1.1.(https://dev.twitter.com/docs/rate-limiting/1.1)";
                break;
            }
            case 500: {
                string = "Something is broken. Please post to the group (https://dev.twitter.com/docs/support) so the Twitter team can investigate.";
                break;
            }
            case 502: {
                string = "Twitter is down or being upgraded.";
                break;
            }
            case 503: {
                string = "The Twitter servers are up, but overloaded with requests. Try again later.";
                break;
            }
            case 504: {
                string = "The Twitter servers are up, but the request couldn't be serviced due to some failure within our stack. Try again later.";
                break;
            }
            default: {
                string = "";
            }
        }
        return n2 + ":" + string;
    }
}

