/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.Location;
import be.maximvdw.tabcore.twitter.LocationJSONImpl;
import be.maximvdw.tabcore.twitter.ParseUtil;
import be.maximvdw.tabcore.twitter.ResponseList;
import be.maximvdw.tabcore.twitter.ResponseListImpl;
import be.maximvdw.tabcore.twitter.Trend;
import be.maximvdw.tabcore.twitter.TrendJSONImpl;
import be.maximvdw.tabcore.twitter.Trends;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.TwitterObjectFactory;
import be.maximvdw.tabcore.twitter.TwitterResponseImpl;
import be.maximvdw.tabcore.twitter.conf.Configuration;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TrendsJSONImpl
extends TwitterResponseImpl
implements Trends,
Serializable {
    private static final long serialVersionUID = 2054973282133379835L;
    private Date asOf;
    private Date trendAt;
    private Trend[] trends;
    private Location location;

    @Override
    public int compareTo(Trends trends) {
        return this.trendAt.compareTo(trends.getTrendAt());
    }

    TrendsJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        this.init(httpResponse.asString(), configuration.isJSONStoreEnabled());
        if (configuration.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, httpResponse.asString());
        }
    }

    TrendsJSONImpl(String string) {
        this(string, false);
    }

    TrendsJSONImpl(String string, boolean bl2) {
        this.init(string, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void init(String string, boolean bl2) {
        try {
            JSONObject jSONObject;
            JSONArray jSONArray;
            if (string.startsWith("[")) {
                jSONArray = new JSONArray(string);
                if (jSONArray.length() <= 0) throw new TwitterException("No trends found on the specified woeid");
                jSONObject = jSONArray.getJSONObject(0);
            } else {
                jSONObject = new JSONObject(string);
            }
            this.asOf = ParseUtil.parseTrendsDate(jSONObject.getString("as_of"));
            this.location = TrendsJSONImpl.extractLocation(jSONObject, bl2);
            jSONArray = jSONObject.getJSONArray("trends");
            this.trendAt = this.asOf;
            this.trends = TrendsJSONImpl.jsonArrayToTrendArray(jSONArray, bl2);
            return;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException.getMessage(), jSONException);
        }
    }

    TrendsJSONImpl(Date date, Location location, Date date2, Trend[] trendArray) {
        this.asOf = date;
        this.location = location;
        this.trendAt = date2;
        this.trends = trendArray;
    }

    static ResponseList<Trends> createTrendsList(HttpResponse httpResponse, boolean bl2) {
        JSONObject jSONObject = httpResponse.asJSONObject();
        try {
            Date date = ParseUtil.parseTrendsDate(jSONObject.getString("as_of"));
            JSONObject jSONObject2 = jSONObject.getJSONObject("trends");
            Location location = TrendsJSONImpl.extractLocation(jSONObject, bl2);
            ResponseListImpl<Trends> responseListImpl = new ResponseListImpl<Trends>(jSONObject2.length(), httpResponse);
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                JSONArray jSONArray = jSONObject2.getJSONArray(string);
                Trend[] trendArray = TrendsJSONImpl.jsonArrayToTrendArray(jSONArray, bl2);
                if (string.length() == 19) {
                    responseListImpl.add(new TrendsJSONImpl(date, location, ParseUtil.getDate(string, "yyyy-MM-dd HH:mm:ss"), trendArray));
                    continue;
                }
                if (string.length() == 16) {
                    responseListImpl.add(new TrendsJSONImpl(date, location, ParseUtil.getDate(string, "yyyy-MM-dd HH:mm"), trendArray));
                    continue;
                }
                if (string.length() != 10) continue;
                responseListImpl.add(new TrendsJSONImpl(date, location, ParseUtil.getDate(string, "yyyy-MM-dd"), trendArray));
            }
            Collections.sort(responseListImpl);
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException.getMessage() + ":" + httpResponse.asString(), jSONException);
        }
    }

    private static Location extractLocation(JSONObject jSONObject, boolean bl2) {
        ResponseList<Location> responseList;
        if (jSONObject.isNull("locations")) {
            return null;
        }
        try {
            responseList = LocationJSONImpl.createLocationList(jSONObject.getJSONArray("locations"), bl2);
        }
        catch (JSONException jSONException) {
            throw new AssertionError((Object)"locations can't be null");
        }
        Location location = 0 != responseList.size() ? (Location)responseList.get(0) : null;
        return location;
    }

    private static Trend[] jsonArrayToTrendArray(JSONArray jSONArray, boolean bl2) {
        Trend[] trendArray = new Trend[jSONArray.length()];
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            JSONObject jSONObject = jSONArray.getJSONObject(i2);
            trendArray[i2] = new TrendJSONImpl(jSONObject, bl2);
        }
        return trendArray;
    }

    @Override
    public Trend[] getTrends() {
        return this.trends;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public Date getAsOf() {
        return this.asOf;
    }

    @Override
    public Date getTrendAt() {
        return this.trendAt;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Trends)) {
            return false;
        }
        Trends trends = (Trends)object;
        if (this.asOf != null ? !this.asOf.equals(trends.getAsOf()) : trends.getAsOf() != null) {
            return false;
        }
        if (this.trendAt != null ? !this.trendAt.equals(trends.getTrendAt()) : trends.getTrendAt() != null) {
            return false;
        }
        return Arrays.equals(this.trends, trends.getTrends());
    }

    public int hashCode() {
        int n2 = this.asOf != null ? this.asOf.hashCode() : 0;
        n2 = 31 * n2 + (this.trendAt != null ? this.trendAt.hashCode() : 0);
        n2 = 31 * n2 + (this.trends != null ? Arrays.hashCode(this.trends) : 0);
        return n2;
    }

    public String toString() {
        return "TrendsJSONImpl{asOf=" + this.asOf + ", trendAt=" + this.trendAt + ", trends=" + (this.trends == null ? null : Arrays.asList(this.trends)) + '}';
    }
}

