/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.ParseUtil;
import be.maximvdw.tabcore.twitter.Trend;
import be.maximvdw.tabcore.twitter.TwitterObjectFactory;
import java.io.Serializable;

final class TrendJSONImpl
implements Trend,
Serializable {
    private static final long serialVersionUID = -4353426776065521132L;
    private final String name;
    private String url = null;
    private String query = null;

    TrendJSONImpl(JSONObject jSONObject, boolean bl2) {
        this.name = ParseUtil.getRawString("name", jSONObject);
        this.url = ParseUtil.getRawString("url", jSONObject);
        this.query = ParseUtil.getRawString("query", jSONObject);
        if (bl2) {
            TwitterObjectFactory.registerJSONObject(this, jSONObject);
        }
    }

    TrendJSONImpl(JSONObject jSONObject) {
        this(jSONObject, false);
    }

    public String getName() {
        return this.name;
    }

    public String getURL() {
        return this.url;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Trend)) {
            return false;
        }
        Trend trend = (Trend)object;
        if (!this.name.equals(trend.getName())) {
            return false;
        }
        if (this.query != null ? !this.query.equals(trend.getQuery()) : trend.getQuery() != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(trend.getURL()) : trend.getURL() != null);
    }

    public int hashCode() {
        int n2 = this.name.hashCode();
        n2 = 31 * n2 + (this.url != null ? this.url.hashCode() : 0);
        n2 = 31 * n2 + (this.query != null ? this.query.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "TrendJSONImpl{name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", query='" + this.query + '\'' + '}';
    }
}

