/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.ParseUtil;
import be.maximvdw.tabcore.twitter.Query;
import be.maximvdw.tabcore.twitter.QueryResult;
import be.maximvdw.tabcore.twitter.Status;
import be.maximvdw.tabcore.twitter.StatusJSONImpl;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.TwitterObjectFactory;
import be.maximvdw.tabcore.twitter.TwitterResponseImpl;
import be.maximvdw.tabcore.twitter.conf.Configuration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QueryResultJSONImpl
extends TwitterResponseImpl
implements QueryResult,
Serializable {
    private static final long serialVersionUID = -5359566235429947156L;
    private long sinceId;
    private long maxId;
    private String refreshUrl;
    private int count;
    private double completedIn;
    private String query;
    private List<Status> tweets;
    private String nextResults;

    QueryResultJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject("search_metadata");
            this.completedIn = ParseUtil.getDouble("completed_in", jSONObject2);
            this.count = ParseUtil.getInt("count", jSONObject2);
            this.maxId = ParseUtil.getLong("max_id", jSONObject2);
            this.nextResults = jSONObject2.has("next_results") ? jSONObject2.getString("next_results") : null;
            this.query = ParseUtil.getURLDecodedString("query", jSONObject2);
            this.refreshUrl = ParseUtil.getUnescapedString("refresh_url", jSONObject2);
            this.sinceId = ParseUtil.getLong("since_id", jSONObject2);
            JSONArray jSONArray = jSONObject.getJSONArray("statuses");
            this.tweets = new ArrayList<Status>(jSONArray.length());
            if (configuration.isJSONStoreEnabled()) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject3 = jSONArray.getJSONObject(i2);
                this.tweets.add(new StatusJSONImpl(jSONObject3, configuration));
            }
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException.getMessage() + ":" + jSONObject.toString(), jSONException);
        }
    }

    QueryResultJSONImpl(Query query) {
        this.sinceId = query.getSinceId();
        this.count = query.getCount();
        this.tweets = new ArrayList<Status>(0);
    }

    @Override
    public long getSinceId() {
        return this.sinceId;
    }

    @Override
    public long getMaxId() {
        return this.maxId;
    }

    @Override
    public String getRefreshURL() {
        return this.refreshUrl;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public double getCompletedIn() {
        return this.completedIn;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public List<Status> getTweets() {
        return this.tweets;
    }

    @Override
    public Query nextQuery() {
        if (this.nextResults == null) {
            return null;
        }
        return Query.createWithNextPageQuery(this.nextResults);
    }

    @Override
    public boolean hasNext() {
        return this.nextResults != null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        QueryResult queryResult = (QueryResult)object;
        if (Double.compare(queryResult.getCompletedIn(), this.completedIn) != 0) {
            return false;
        }
        if (this.maxId != queryResult.getMaxId()) {
            return false;
        }
        if (this.count != queryResult.getCount()) {
            return false;
        }
        if (this.sinceId != queryResult.getSinceId()) {
            return false;
        }
        if (!this.query.equals(queryResult.getQuery())) {
            return false;
        }
        if (this.refreshUrl != null ? !this.refreshUrl.equals(queryResult.getRefreshURL()) : queryResult.getRefreshURL() != null) {
            return false;
        }
        return !(this.tweets != null ? !this.tweets.equals(queryResult.getTweets()) : queryResult.getTweets() != null);
    }

    public int hashCode() {
        int n2 = (int)(this.sinceId ^ this.sinceId >>> 32);
        n2 = 31 * n2 + (int)(this.maxId ^ this.maxId >>> 32);
        n2 = 31 * n2 + (this.refreshUrl != null ? this.refreshUrl.hashCode() : 0);
        n2 = 31 * n2 + this.count;
        long l2 = this.completedIn != 0.0 ? Double.doubleToLongBits(this.completedIn) : 0L;
        n2 = 31 * n2 + (int)(l2 ^ l2 >>> 32);
        n2 = 31 * n2 + this.query.hashCode();
        n2 = 31 * n2 + (this.tweets != null ? this.tweets.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "QueryResultJSONImpl{sinceId=" + this.sinceId + ", maxId=" + this.maxId + ", refreshUrl='" + this.refreshUrl + '\'' + ", count=" + this.count + ", completedIn=" + this.completedIn + ", query='" + this.query + '\'' + ", tweets=" + this.tweets + '}';
    }
}

