/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HTMLEntity;
import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.TwitterException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingQueue;

final class ParseUtil {
    private static final Map<String, LinkedBlockingQueue<SimpleDateFormat>> formatMapQueue = new HashMap<String, LinkedBlockingQueue<SimpleDateFormat>>();

    private ParseUtil() {
        throw new AssertionError();
    }

    static String getUnescapedString(String string, JSONObject jSONObject) {
        return HTMLEntity.unescape(ParseUtil.getRawString(string, jSONObject));
    }

    public static String getRawString(String string, JSONObject jSONObject) {
        try {
            if (jSONObject.isNull(string)) {
                return null;
            }
            return jSONObject.getString(string);
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    static String getURLDecodedString(String string, JSONObject jSONObject) {
        String string2 = ParseUtil.getRawString(string, jSONObject);
        if (string2 != null) {
            try {
                string2 = URLDecoder.decode(string2, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static Date parseTrendsDate(String string) {
        Date date;
        switch (string.length()) {
            case 10: {
                date = new Date(Long.parseLong(string) * 1000L);
                break;
            }
            case 20: {
                date = ParseUtil.getDate(string, "yyyy-MM-dd'T'HH:mm:ss'Z'");
                break;
            }
            default: {
                date = ParseUtil.getDate(string, "EEE, d MMM yyyy HH:mm:ss z");
            }
        }
        return date;
    }

    public static Date getDate(String string, JSONObject jSONObject) {
        return ParseUtil.getDate(string, jSONObject, "EEE MMM d HH:mm:ss z yyyy");
    }

    public static Date getDate(String string, JSONObject jSONObject, String string2) {
        String string3 = ParseUtil.getUnescapedString(string, jSONObject);
        if ("null".equals(string3) || null == string3) {
            return null;
        }
        return ParseUtil.getDate(string3, string2);
    }

    public static Date getDate(String string, String string2) {
        SimpleDateFormat simpleDateFormat;
        LinkedBlockingQueue<SimpleDateFormat> linkedBlockingQueue = formatMapQueue.get(string2);
        if (linkedBlockingQueue == null) {
            linkedBlockingQueue = new LinkedBlockingQueue();
            formatMapQueue.put(string2, linkedBlockingQueue);
        }
        if (null == (simpleDateFormat = linkedBlockingQueue.poll())) {
            simpleDateFormat = new SimpleDateFormat(string2, Locale.US);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        try {
            Date date = simpleDateFormat.parse(string);
            return date;
        }
        catch (ParseException parseException) {
            throw new TwitterException("Unexpected date format(" + string + ") returned from twitter.com", parseException);
        }
        finally {
            try {
                linkedBlockingQueue.put(simpleDateFormat);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static int getInt(String string, JSONObject jSONObject) {
        return ParseUtil.getInt(ParseUtil.getRawString(string, jSONObject));
    }

    public static int getInt(String string) {
        if (null == string || "".equals(string) || "null".equals(string)) {
            return -1;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static long getLong(String string, JSONObject jSONObject) {
        return ParseUtil.getLong(ParseUtil.getRawString(string, jSONObject));
    }

    public static long getLong(String string) {
        if (null == string || "".equals(string) || "null".equals(string)) {
            return -1L;
        }
        if (string.endsWith("+")) {
            string = string.substring(0, string.length() - 1);
            return Long.valueOf(string) + 1L;
        }
        return Long.valueOf(string);
    }

    public static double getDouble(String string, JSONObject jSONObject) {
        String string2 = ParseUtil.getRawString(string, jSONObject);
        if (null == string2 || "".equals(string2) || "null".equals(string2)) {
            return -1.0;
        }
        return Double.valueOf(string2);
    }

    public static boolean getBoolean(String string, JSONObject jSONObject) {
        String string2 = ParseUtil.getRawString(string, jSONObject);
        if (null == string2 || "null".equals(string2)) {
            return false;
        }
        return Boolean.valueOf(string2);
    }

    public static int toAccessLevel(HttpResponse httpResponse) {
        int n2;
        if (null == httpResponse) {
            return -1;
        }
        String string = httpResponse.getResponseHeader("X-Access-Level");
        if (null == string) {
            n2 = 0;
        } else {
            switch (string.length()) {
                case 4: {
                    n2 = 1;
                    break;
                }
                case 10: {
                    n2 = 2;
                    break;
                }
                case 25: {
                    n2 = 3;
                    break;
                }
                case 26: {
                    n2 = 3;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
        }
        return n2;
    }
}

