/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.PagableResponseList;
import be.maximvdw.tabcore.twitter.ParseUtil;
import be.maximvdw.tabcore.twitter.RateLimitStatus;
import be.maximvdw.tabcore.twitter.ResponseListImpl;
import be.maximvdw.tabcore.twitter.TwitterResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PagableResponseListImpl<T extends TwitterResponse>
extends ResponseListImpl<T>
implements PagableResponseList<T> {
    private static final long serialVersionUID = -8603601553967559275L;
    private final long previousCursor;
    private final long nextCursor;

    PagableResponseListImpl(RateLimitStatus rateLimitStatus, int n2) {
        super(rateLimitStatus, n2);
        this.previousCursor = 0L;
        this.nextCursor = 0L;
    }

    PagableResponseListImpl(int n2, JSONObject jSONObject, HttpResponse httpResponse) {
        super(n2, httpResponse);
        this.previousCursor = ParseUtil.getLong("previous_cursor", jSONObject);
        this.nextCursor = ParseUtil.getLong("next_cursor", jSONObject);
    }

    @Override
    public boolean hasPrevious() {
        return 0L != this.previousCursor;
    }

    @Override
    public long getPreviousCursor() {
        return this.previousCursor;
    }

    @Override
    public boolean hasNext() {
        return 0L != this.nextCursor;
    }

    @Override
    public long getNextCursor() {
        return this.nextCursor;
    }
}

