/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.AccountSettings;
import be.maximvdw.tabcore.twitter.AccountSettingsJSONImpl;
import be.maximvdw.tabcore.twitter.AccountTotals;
import be.maximvdw.tabcore.twitter.AccountTotalsJSONImpl;
import be.maximvdw.tabcore.twitter.Category;
import be.maximvdw.tabcore.twitter.CategoryJSONImpl;
import be.maximvdw.tabcore.twitter.DirectMessage;
import be.maximvdw.tabcore.twitter.DirectMessageJSONImpl;
import be.maximvdw.tabcore.twitter.Friendship;
import be.maximvdw.tabcore.twitter.FriendshipJSONImpl;
import be.maximvdw.tabcore.twitter.GeoLocation;
import be.maximvdw.tabcore.twitter.HashtagEntity;
import be.maximvdw.tabcore.twitter.HashtagEntityJSONImpl;
import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.IDs;
import be.maximvdw.tabcore.twitter.IDsJSONImpl;
import be.maximvdw.tabcore.twitter.JSONArray;
import be.maximvdw.tabcore.twitter.JSONException;
import be.maximvdw.tabcore.twitter.JSONObject;
import be.maximvdw.tabcore.twitter.LanguageJSONImpl;
import be.maximvdw.tabcore.twitter.Location;
import be.maximvdw.tabcore.twitter.LocationJSONImpl;
import be.maximvdw.tabcore.twitter.OEmbed;
import be.maximvdw.tabcore.twitter.OEmbedJSONImpl;
import be.maximvdw.tabcore.twitter.ObjectFactory;
import be.maximvdw.tabcore.twitter.PagableResponseList;
import be.maximvdw.tabcore.twitter.Place;
import be.maximvdw.tabcore.twitter.PlaceJSONImpl;
import be.maximvdw.tabcore.twitter.Query;
import be.maximvdw.tabcore.twitter.QueryResult;
import be.maximvdw.tabcore.twitter.QueryResultJSONImpl;
import be.maximvdw.tabcore.twitter.RateLimitStatus;
import be.maximvdw.tabcore.twitter.RateLimitStatusJSONImpl;
import be.maximvdw.tabcore.twitter.Relationship;
import be.maximvdw.tabcore.twitter.RelationshipJSONImpl;
import be.maximvdw.tabcore.twitter.ResponseList;
import be.maximvdw.tabcore.twitter.ResponseListImpl;
import be.maximvdw.tabcore.twitter.SavedSearch;
import be.maximvdw.tabcore.twitter.SavedSearchJSONImpl;
import be.maximvdw.tabcore.twitter.Status;
import be.maximvdw.tabcore.twitter.StatusJSONImpl;
import be.maximvdw.tabcore.twitter.Trends;
import be.maximvdw.tabcore.twitter.TrendsJSONImpl;
import be.maximvdw.tabcore.twitter.TwitterAPIConfiguration;
import be.maximvdw.tabcore.twitter.TwitterAPIConfigurationJSONImpl;
import be.maximvdw.tabcore.twitter.TwitterException;
import be.maximvdw.tabcore.twitter.URLEntity;
import be.maximvdw.tabcore.twitter.URLEntityJSONImpl;
import be.maximvdw.tabcore.twitter.User;
import be.maximvdw.tabcore.twitter.UserJSONImpl;
import be.maximvdw.tabcore.twitter.UserList;
import be.maximvdw.tabcore.twitter.UserListJSONImpl;
import be.maximvdw.tabcore.twitter.UserMentionEntity;
import be.maximvdw.tabcore.twitter.UserMentionEntityJSONImpl;
import be.maximvdw.tabcore.twitter.api.HelpResources;
import be.maximvdw.tabcore.twitter.conf.Configuration;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSONImplFactory
implements ObjectFactory {
    private static final long serialVersionUID = -1853541456182663343L;
    private final Configuration conf;

    public JSONImplFactory(Configuration configuration) {
        this.conf = configuration;
    }

    @Override
    public Status createStatus(JSONObject jSONObject) {
        return new StatusJSONImpl(jSONObject);
    }

    @Override
    public User createUser(JSONObject jSONObject) {
        return new UserJSONImpl(jSONObject);
    }

    @Override
    public UserList createAUserList(JSONObject jSONObject) {
        return new UserListJSONImpl(jSONObject);
    }

    @Override
    public Map<String, RateLimitStatus> createRateLimitStatuses(HttpResponse httpResponse) {
        return RateLimitStatusJSONImpl.createRateLimitStatuses(httpResponse, this.conf);
    }

    @Override
    public Status createStatus(HttpResponse httpResponse) {
        return new StatusJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<Status> createStatusList(HttpResponse httpResponse) {
        return StatusJSONImpl.createStatusList(httpResponse, this.conf);
    }

    static GeoLocation createGeoLocation(JSONObject jSONObject) {
        try {
            if (!jSONObject.isNull("coordinates")) {
                String string = jSONObject.getJSONObject("coordinates").getString("coordinates");
                string = string.substring(1, string.length() - 1);
                String[] stringArray = string.split(",");
                return new GeoLocation(Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[0]));
            }
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
        return null;
    }

    static GeoLocation[][] coordinatesAsGeoLocationArray(JSONArray jSONArray) {
        try {
            GeoLocation[][] geoLocationArray = new GeoLocation[jSONArray.length()][];
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONArray jSONArray2 = jSONArray.getJSONArray(i2);
                geoLocationArray[i2] = new GeoLocation[jSONArray2.length()];
                for (int i3 = 0; i3 < jSONArray2.length(); ++i3) {
                    JSONArray jSONArray3 = jSONArray2.getJSONArray(i3);
                    geoLocationArray[i2][i3] = new GeoLocation(jSONArray3.getDouble(1), jSONArray3.getDouble(0));
                }
            }
            return geoLocationArray;
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    public static RateLimitStatus createRateLimitStatusFromResponseHeader(HttpResponse httpResponse) {
        return RateLimitStatusJSONImpl.createFromResponseHeader(httpResponse);
    }

    @Override
    public Trends createTrends(HttpResponse httpResponse) {
        return new TrendsJSONImpl(httpResponse, this.conf);
    }

    @Override
    public User createUser(HttpResponse httpResponse) {
        return new UserJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<User> createUserList(HttpResponse httpResponse) {
        return UserJSONImpl.createUserList(httpResponse, this.conf);
    }

    @Override
    public ResponseList<User> createUserListFromJSONArray(HttpResponse httpResponse) {
        return UserJSONImpl.createUserList(httpResponse.asJSONArray(), httpResponse, this.conf);
    }

    @Override
    public ResponseList<User> createUserListFromJSONArray_Users(HttpResponse httpResponse) {
        try {
            return UserJSONImpl.createUserList(httpResponse.asJSONObject().getJSONArray("users"), httpResponse, this.conf);
        }
        catch (JSONException jSONException) {
            throw new TwitterException(jSONException);
        }
    }

    @Override
    public QueryResult createQueryResult(HttpResponse httpResponse, Query query) {
        try {
            return new QueryResultJSONImpl(httpResponse, this.conf);
        }
        catch (TwitterException twitterException) {
            if (404 == twitterException.getStatusCode()) {
                return new QueryResultJSONImpl(query);
            }
            throw twitterException;
        }
    }

    @Override
    public IDs createIDs(HttpResponse httpResponse) {
        return new IDsJSONImpl(httpResponse, this.conf);
    }

    @Override
    public PagableResponseList<User> createPagableUserList(HttpResponse httpResponse) {
        return UserJSONImpl.createPagableUserList(httpResponse, this.conf);
    }

    @Override
    public UserList createAUserList(HttpResponse httpResponse) {
        return new UserListJSONImpl(httpResponse, this.conf);
    }

    @Override
    public PagableResponseList<UserList> createPagableUserListList(HttpResponse httpResponse) {
        return UserListJSONImpl.createPagableUserListList(httpResponse, this.conf);
    }

    @Override
    public ResponseList<UserList> createUserListList(HttpResponse httpResponse) {
        return UserListJSONImpl.createUserListList(httpResponse, this.conf);
    }

    @Override
    public ResponseList<Category> createCategoryList(HttpResponse httpResponse) {
        return CategoryJSONImpl.createCategoriesList(httpResponse, this.conf);
    }

    @Override
    public DirectMessage createDirectMessage(HttpResponse httpResponse) {
        return new DirectMessageJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<DirectMessage> createDirectMessageList(HttpResponse httpResponse) {
        return DirectMessageJSONImpl.createDirectMessageList(httpResponse, this.conf);
    }

    @Override
    public Relationship createRelationship(HttpResponse httpResponse) {
        return new RelationshipJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<Friendship> createFriendshipList(HttpResponse httpResponse) {
        return FriendshipJSONImpl.createFriendshipList(httpResponse, this.conf);
    }

    @Override
    public AccountTotals createAccountTotals(HttpResponse httpResponse) {
        return new AccountTotalsJSONImpl(httpResponse, this.conf);
    }

    @Override
    public AccountSettings createAccountSettings(HttpResponse httpResponse) {
        return new AccountSettingsJSONImpl(httpResponse, this.conf);
    }

    @Override
    public SavedSearch createSavedSearch(HttpResponse httpResponse) {
        return new SavedSearchJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<SavedSearch> createSavedSearchList(HttpResponse httpResponse) {
        return SavedSearchJSONImpl.createSavedSearchList(httpResponse, this.conf);
    }

    @Override
    public ResponseList<Location> createLocationList(HttpResponse httpResponse) {
        return LocationJSONImpl.createLocationList(httpResponse, this.conf);
    }

    @Override
    public Place createPlace(HttpResponse httpResponse) {
        return new PlaceJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<Place> createPlaceList(HttpResponse httpResponse) {
        try {
            return PlaceJSONImpl.createPlaceList(httpResponse, this.conf);
        }
        catch (TwitterException twitterException) {
            if (twitterException.getStatusCode() == 404) {
                return new ResponseListImpl<Place>(0, null);
            }
            throw twitterException;
        }
    }

    @Override
    public TwitterAPIConfiguration createTwitterAPIConfiguration(HttpResponse httpResponse) {
        return new TwitterAPIConfigurationJSONImpl(httpResponse, this.conf);
    }

    @Override
    public ResponseList<HelpResources.Language> createLanguageList(HttpResponse httpResponse) {
        return LanguageJSONImpl.createLanguageList(httpResponse, this.conf);
    }

    @Override
    public <T> ResponseList<T> createEmptyResponseList() {
        return new ResponseListImpl(0, null);
    }

    @Override
    public OEmbed createOEmbed(HttpResponse httpResponse) {
        return new OEmbedJSONImpl(httpResponse, this.conf);
    }

    public static HashtagEntity createHashtagEntity(int n2, int n3, String string) {
        return new HashtagEntityJSONImpl(n2, n3, string);
    }

    public static UserMentionEntity createUserMentionEntity(int n2, int n3, String string, String string2, long l2) {
        return new UserMentionEntityJSONImpl(n2, n3, string, string2, l2);
    }

    public static URLEntity createUrlEntity(int n2, int n3, String string, String string2, String string3) {
        return new URLEntityJSONImpl(n2, n3, string, string2, string3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JSONImplFactory)) {
            return false;
        }
        JSONImplFactory jSONImplFactory = (JSONImplFactory)object;
        return !(this.conf != null ? !this.conf.equals(jSONImplFactory.conf) : jSONImplFactory.conf != null);
    }

    public int hashCode() {
        return this.conf != null ? this.conf.hashCode() : 0;
    }

    public String toString() {
        return "JSONImplFactory{conf=" + this.conf + '}';
    }
}

