/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import be.maximvdw.tabcore.twitter.HttpRequest;
import be.maximvdw.tabcore.twitter.HttpResponse;
import be.maximvdw.tabcore.twitter.TwitterException;

public final class HttpResponseEvent {
    private final HttpRequest request;
    private final HttpResponse response;
    private final TwitterException twitterException;

    HttpResponseEvent(HttpRequest httpRequest, HttpResponse httpResponse, TwitterException twitterException) {
        this.request = httpRequest;
        this.response = httpResponse;
        this.twitterException = twitterException;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public TwitterException getTwitterException() {
        return this.twitterException;
    }

    public boolean isAuthenticated() {
        return this.request.getAuthorization().isEnabled();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HttpResponseEvent httpResponseEvent = (HttpResponseEvent)object;
        if (this.request != null ? !this.request.equals(httpResponseEvent.request) : httpResponseEvent.request != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals(httpResponseEvent.response) : httpResponseEvent.response != null);
    }

    public int hashCode() {
        int n2 = this.request != null ? this.request.hashCode() : 0;
        n2 = 31 * n2 + (this.response != null ? this.response.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "HttpResponseEvent{request=" + this.request + ", response=" + this.response + '}';
    }
}

