/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.twitter;

import java.io.Serializable;

final class ExceptionDiagnosis
implements Serializable {
    private static final long serialVersionUID = 8501009773274399369L;
    private int stackLineHash;
    private int lineNumberHash;
    private String hexString = "";

    ExceptionDiagnosis(Throwable throwable) {
        this(throwable, new String[0]);
    }

    ExceptionDiagnosis(Throwable throwable, String[] stringArray) {
        Throwable throwable2 = throwable;
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        this.stackLineHash = 0;
        this.lineNumberHash = 0;
        block0: for (int i2 = stackTraceElementArray.length - 1; i2 >= 0; --i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            for (String string : stringArray) {
                if (!stackTraceElement.getClassName().startsWith(string)) continue;
                int n2 = stackTraceElement.getClassName().hashCode() + stackTraceElement.getMethodName().hashCode();
                this.stackLineHash = 31 * this.stackLineHash + n2;
                this.lineNumberHash = 31 * this.lineNumberHash + stackTraceElement.getLineNumber();
                continue block0;
            }
        }
        this.hexString = this.hexString + this.toHexString(this.stackLineHash) + "-" + this.toHexString(this.lineNumberHash);
        if (throwable.getCause() != null) {
            this.hexString = this.hexString + " " + new ExceptionDiagnosis(throwable.getCause(), stringArray).asHexString();
        }
    }

    int getStackLineHash() {
        return this.stackLineHash;
    }

    String getStackLineHashAsHex() {
        return this.toHexString(this.stackLineHash);
    }

    int getLineNumberHash() {
        return this.lineNumberHash;
    }

    String getLineNumberHashAsHex() {
        return this.toHexString(this.lineNumberHash);
    }

    String asHexString() {
        return this.hexString;
    }

    private String toHexString(int n2) {
        String string = "0000000" + Integer.toHexString(n2);
        return string.substring(string.length() - 8, string.length());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ExceptionDiagnosis exceptionDiagnosis = (ExceptionDiagnosis)object;
        if (this.lineNumberHash != exceptionDiagnosis.lineNumberHash) {
            return false;
        }
        return this.stackLineHash == exceptionDiagnosis.stackLineHash;
    }

    public int hashCode() {
        int n2 = this.stackLineHash;
        n2 = 31 * n2 + this.lineNumberHash;
        return n2;
    }

    public String toString() {
        return "ExceptionDiagnosis{stackLineHash=" + this.stackLineHash + ", lineNumberHash=" + this.lineNumberHash + '}';
    }
}

