/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Application;
import be.maximvdw.tabcore.facebook.Category;
import be.maximvdw.tabcore.facebook.Comment;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.IdNameEntity;
import be.maximvdw.tabcore.facebook.Like;
import be.maximvdw.tabcore.facebook.PagableList;
import be.maximvdw.tabcore.facebook.Place;
import be.maximvdw.tabcore.facebook.Post;
import be.maximvdw.tabcore.facebook.Privacy;
import be.maximvdw.tabcore.facebook.Reaction;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.Tag;
import be.maximvdw.tabcore.facebook.Targeting;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.ApplicationJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.CommentJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.LikeJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.PagableListImpl;
import be.maximvdw.tabcore.facebook.internal.json.PlaceJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.PrivacyJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.ReactionJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.json.TagJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.TargetingJSONImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PostJSONImpl
extends FacebookResponseImpl
implements Post,
Serializable {
    private static final long serialVersionUID = 9221631714701171423L;
    private String id;
    private Category from;
    private List<IdNameEntity> to;
    private String message;
    private List<Tag> messageTags;
    private URL picture;
    private URL fullPicture;
    private URL link;
    private String name;
    private String caption;
    private String description;
    private URL source;
    private List<Post.Property> properties;
    private URL icon;
    private List<Post.Action> actions;
    private Privacy privacy;
    private String type;
    private Integer sharesCount;
    private PagableList<Like> likes;
    private Place place;
    private String statusType;
    private String story;
    private Map<String, Tag[]> storyTags;
    private List<IdNameEntity> withTags;
    private PagableList<Comment> comments;
    private String objectId;
    private Application application;
    private Date createdTime;
    private Date updatedTime;
    private Boolean isPublished;
    private Integer scheduledPublishTime;
    private Targeting targeting;
    private PagableList<Reaction> reactions;
    private String parentId;

    PostJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    PostJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2;
            int n2;
            Object object;
            Object object2;
            Object object3;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                object3 = jSONObject.getJSONObject("from");
                this.from = new CategoryJSONImpl((JSONObject)object3);
            }
            if (!jSONObject.isNull("to")) {
                object3 = jSONObject.getJSONObject("to").getJSONArray("data");
                this.to = new ArrayList<IdNameEntity>();
                for (int i2 = 0; i2 < ((JSONArray)object3).length(); ++i2) {
                    object2 = ((JSONArray)object3).getJSONObject(i2);
                    this.to.add(new IdNameEntityJSONImpl((JSONObject)object2));
                }
            } else {
                this.to = Collections.emptyList();
            }
            this.message = z_F4JInternalParseUtil.getRawString("message", jSONObject);
            if (!jSONObject.isNull("message_tags")) {
                Object object4;
                Object object5;
                object3 = jSONObject.get("message_tags").toString();
                if (((String)object3).startsWith("[")) {
                    object5 = jSONObject.getJSONArray("message_tags");
                    this.messageTags = new ArrayList<Tag>();
                    for (int i3 = 0; i3 < ((JSONArray)object5).length(); ++i3) {
                        object4 = ((JSONArray)object5).getJSONObject(i3);
                        this.messageTags.add(new TagJSONImpl((JSONObject)object4));
                    }
                } else {
                    object5 = jSONObject.getJSONObject("message_tags");
                    object2 = ((JSONObject)object5).keys();
                    while (object2.hasNext()) {
                        object4 = (String)object2.next();
                        object = ((JSONObject)object5).getJSONArray((String)object4);
                        this.messageTags = new ArrayList<Tag>();
                        for (n2 = 0; n2 < object.length(); ++n2) {
                            jSONObject2 = object.getJSONObject(n2);
                            this.messageTags.add(new TagJSONImpl(jSONObject2));
                        }
                    }
                }
            } else {
                this.messageTags = Collections.emptyList();
            }
            this.picture = z_F4JInternalParseUtil.getURL("picture", jSONObject);
            this.fullPicture = z_F4JInternalParseUtil.getURL("full_picture", jSONObject);
            this.link = z_F4JInternalParseUtil.getURL("link", jSONObject);
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            this.caption = z_F4JInternalParseUtil.getRawString("caption", jSONObject);
            this.description = z_F4JInternalParseUtil.getRawString("description", jSONObject);
            this.source = z_F4JInternalParseUtil.getURL("source", jSONObject);
            if (!jSONObject.isNull("properties")) {
                object3 = jSONObject.getJSONArray("properties");
                this.properties = new ArrayList<Post.Property>();
                for (int i4 = 0; i4 < ((JSONArray)object3).length(); ++i4) {
                    JSONObject jSONObject3 = ((JSONArray)object3).getJSONObject(i4);
                    this.properties.add(new PropertyJSONImpl(jSONObject3));
                }
            } else {
                this.properties = Collections.emptyList();
            }
            this.icon = z_F4JInternalParseUtil.getURL("icon", jSONObject);
            if (!jSONObject.isNull("actions")) {
                object3 = jSONObject.getJSONArray("actions");
                this.actions = new ArrayList<Post.Action>();
                for (int i5 = 0; i5 < ((JSONArray)object3).length(); ++i5) {
                    JSONObject jSONObject4 = ((JSONArray)object3).getJSONObject(i5);
                    this.actions.add(new ActionJSONImpl(jSONObject4));
                }
            } else {
                this.actions = Collections.emptyList();
            }
            if (!jSONObject.isNull("privacy")) {
                object3 = jSONObject.getJSONObject("privacy");
                this.privacy = new PrivacyJSONImpl((JSONObject)object3);
            }
            this.type = z_F4JInternalParseUtil.getRawString("type", jSONObject);
            if (!jSONObject.isNull("shares") && !((JSONObject)(object3 = jSONObject.getJSONObject("shares"))).isNull("count")) {
                this.sharesCount = z_F4JInternalParseUtil.getInt("count", (JSONObject)object3);
            }
            if (!jSONObject.isNull("likes")) {
                object3 = jSONObject.getJSONObject("likes");
                if (!((JSONObject)object3).isNull("data")) {
                    JSONArray jSONArray = ((JSONObject)object3).getJSONArray("data");
                    int n3 = jSONArray.length();
                    this.likes = new PagableListImpl<Like>(n3, (JSONObject)object3, new Like[0]);
                    for (int i6 = 0; i6 < n3; ++i6) {
                        object = new LikeJSONImpl(jSONArray.getJSONObject(i6));
                        this.likes.add(object);
                    }
                } else {
                    this.likes = new PagableListImpl<Like>(1, (JSONObject)object3, new Like[0]);
                }
            } else {
                this.likes = new PagableListImpl<Like>(0);
            }
            if (!jSONObject.isNull("place")) {
                object3 = jSONObject.getJSONObject("place");
                this.place = new PlaceJSONImpl((JSONObject)object3);
            }
            this.statusType = z_F4JInternalParseUtil.getRawString("status_type", jSONObject);
            this.story = z_F4JInternalParseUtil.getRawString("story", jSONObject);
            if (!jSONObject.isNull("story_tags")) {
                object3 = jSONObject.getJSONObject("story_tags");
                this.storyTags = new HashMap<String, Tag[]>();
                Iterator iterator = ((JSONObject)object3).keys();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    JSONArray jSONArray = ((JSONObject)object3).getJSONArray(string);
                    object = new Tag[jSONArray.length()];
                    for (n2 = 0; n2 < jSONArray.length(); ++n2) {
                        jSONObject2 = jSONArray.getJSONObject(n2);
                        object[n2] = new TagJSONImpl(jSONObject2);
                    }
                    this.storyTags.put(string, (Tag[])object);
                }
            } else {
                this.storyTags = Collections.emptyMap();
            }
            if (!jSONObject.isNull("with_tags")) {
                object3 = jSONObject.getJSONObject("with_tags").getJSONArray("data");
                this.withTags = new ArrayList<IdNameEntity>();
                for (int i7 = 0; i7 < ((JSONArray)object3).length(); ++i7) {
                    JSONObject jSONObject5 = ((JSONArray)object3).getJSONObject(i7);
                    this.withTags.add(new IdNameEntityJSONImpl(jSONObject5));
                }
            } else {
                this.withTags = Collections.emptyList();
            }
            if (!jSONObject.isNull("comments")) {
                object3 = jSONObject.getJSONObject("comments");
                if (!((JSONObject)object3).isNull("data")) {
                    JSONArray jSONArray = ((JSONObject)object3).getJSONArray("data");
                    int n4 = jSONArray.length();
                    this.comments = new PagableListImpl<Comment>(n4, (JSONObject)object3, new Comment[0]);
                    for (int i8 = 0; i8 < n4; ++i8) {
                        object = new CommentJSONImpl(jSONArray.getJSONObject(i8));
                        this.comments.add(object);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, (JSONObject)object3, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
            if (!jSONObject.isNull("object_id")) {
                this.objectId = z_F4JInternalParseUtil.getRawString("object_id", jSONObject);
            }
            if (!jSONObject.isNull("parent_id")) {
                this.parentId = z_F4JInternalParseUtil.getRawString("parent_id", jSONObject);
            }
            if (!jSONObject.isNull("application")) {
                object3 = jSONObject.getJSONObject("application");
                this.application = new ApplicationJSONImpl((JSONObject)object3);
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
            if (!jSONObject.isNull("is_published")) {
                this.isPublished = z_F4JInternalParseUtil.getBoolean("is_published", jSONObject);
            }
            this.scheduledPublishTime = z_F4JInternalParseUtil.getInt("scheduled_publish_time", jSONObject);
            if (!jSONObject.isNull("targeting")) {
                this.targeting = new TargetingJSONImpl(jSONObject.getJSONObject("targeting"));
            }
            if (!jSONObject.isNull("reactions")) {
                object3 = jSONObject.getJSONObject("reactions");
                if (!((JSONObject)object3).isNull("data")) {
                    JSONArray jSONArray = ((JSONObject)object3).getJSONArray("data");
                    int n5 = jSONArray.length();
                    this.reactions = new PagableListImpl<Reaction>(n5, (JSONObject)object3, new Reaction[0]);
                    for (int i9 = 0; i9 < n5; ++i9) {
                        object = new ReactionJSONImpl(jSONArray.getJSONObject(i9));
                        this.reactions.add(object);
                    }
                } else {
                    this.reactions = new PagableListImpl<Reaction>(1, (JSONObject)object3, new Reaction[0]);
                }
            } else {
                this.reactions = new PagableListImpl<Reaction>(0);
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public List<IdNameEntity> getTo() {
        return this.to;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public List<Tag> getMessageTags() {
        return this.messageTags;
    }

    @Override
    public URL getPicture() {
        return this.picture;
    }

    @Override
    public URL getFullPicture() {
        return this.fullPicture;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCaption() {
        return this.caption;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public URL getSource() {
        return this.source;
    }

    @Override
    public List<Post.Property> getProperties() {
        return this.properties;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    @Override
    public List<Post.Action> getActions() {
        return this.actions;
    }

    @Override
    public Privacy getPrivacy() {
        return this.privacy;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Integer getSharesCount() {
        return this.sharesCount;
    }

    @Override
    public PagableList<Like> getLikes() {
        return this.likes;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public String getStatusType() {
        return this.statusType;
    }

    @Override
    public String getStory() {
        return this.story;
    }

    @Override
    public Map<String, Tag[]> getStoryTags() {
        return this.storyTags;
    }

    @Override
    public List<IdNameEntity> getWithTags() {
        return this.withTags;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public String getObjectId() {
        return this.objectId;
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public Boolean isPublished() {
        return this.isPublished;
    }

    @Override
    public Date getScheduledPublishTime() {
        if (this.scheduledPublishTime == null) {
            return null;
        }
        return new Date(this.scheduledPublishTime * 1000);
    }

    @Override
    public Targeting getTargeting() {
        return this.targeting;
    }

    static ResponseList<Post> createPostList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Post> responseListImpl = new ResponseListImpl<Post>(n2, jSONObject, new Post[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                PostJSONImpl postJSONImpl = new PostJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(postJSONImpl, jSONObject2);
                }
                responseListImpl.add(postJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PostJSONImpl postJSONImpl = (PostJSONImpl)object;
        return !(this.id == null ? postJSONImpl.id != null : !this.id.equals(postJSONImpl.id));
    }

    public String toString() {
        return "PostJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", to=" + this.to + ", message='" + this.message + '\'' + ", messageTags=" + this.messageTags + ", picture=" + this.picture + ", fullPicture=" + this.fullPicture + ", link=" + this.link + ", name='" + this.name + '\'' + ", caption='" + this.caption + '\'' + ", description='" + this.description + '\'' + ", source=" + this.source + ", properties=" + this.properties + ", icon='" + this.icon + '\'' + ", actions=" + this.actions + ", privacy=" + this.privacy + ", type='" + this.type + '\'' + ", sharesCount=" + this.sharesCount + ", likes=" + this.likes + ", place=" + this.place + ", statusType='" + this.statusType + '\'' + ", story='" + this.story + '\'' + ", storyTags=" + this.storyTags + ", withTags=" + this.withTags + ", comments=" + this.comments + ", objectId='" + this.objectId + '\'' + ", application=" + this.application + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", isPublished=" + this.isPublished + ", scheduledPublishTime=" + this.scheduledPublishTime + ", targeting=" + this.targeting + '}';
    }

    @Override
    public PagableList<Reaction> getReactions() {
        return this.reactions;
    }

    private class ActionJSONImpl
    implements Post.Action,
    Serializable {
        private static final long serialVersionUID = 2407371708630166786L;
        private final String name;
        private final String link;

        ActionJSONImpl(JSONObject jSONObject) {
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            this.link = z_F4JInternalParseUtil.getRawString("link", jSONObject);
        }

        public String getName() {
            return this.name;
        }

        public String getLink() {
            return this.link;
        }

        public String toString() {
            return "Post.ActionJSONImpl [name=" + this.name + ", link=" + this.link + "]";
        }
    }

    private class PropertyJSONImpl
    implements Post.Property,
    Serializable {
        private static final long serialVersionUID = -2917519371927503549L;
        private final String name;
        private final String text;
        private final String href;

        PropertyJSONImpl(JSONObject jSONObject) {
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            this.text = z_F4JInternalParseUtil.getRawString("text", jSONObject);
            this.href = z_F4JInternalParseUtil.getRawString("href", jSONObject);
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public String getHref() {
            return this.href;
        }

        public String toString() {
            return "Post.PropertyJSONImpl [name=" + this.name + ", text=" + this.text + ", href=" + this.href + "]";
        }
    }
}

