/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Category;
import be.maximvdw.tabcore.facebook.Comment;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.Image;
import be.maximvdw.tabcore.facebook.Like;
import be.maximvdw.tabcore.facebook.PagableList;
import be.maximvdw.tabcore.facebook.Photo;
import be.maximvdw.tabcore.facebook.Place;
import be.maximvdw.tabcore.facebook.Reaction;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.Tag;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.CategoryJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.CommentJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.ImageJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.LikeJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.PagableListImpl;
import be.maximvdw.tabcore.facebook.internal.json.PlaceJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.ReactionJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.json.TagJSONImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PhotoJSONImpl
extends FacebookResponseImpl
implements Photo,
Serializable {
    private static final long serialVersionUID = 831715533023012050L;
    private String id;
    private Category from;
    private PagableList<Tag> tags;
    private String name;
    private URL icon;
    private URL picture;
    private URL source;
    private Integer height;
    private Integer width;
    private List<Image> images;
    private URL link;
    private Place place;
    private Date createdTime;
    private Date updatedTime;
    private Integer position;
    private PagableList<Comment> comments;
    private PagableList<Like> likes;
    private Category album;
    private PagableList<Reaction> reactions;

    PhotoJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    PhotoJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            FacebookResponseImpl facebookResponseImpl;
            int n2;
            int n3;
            Object object;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                object = jSONObject.getJSONObject("from");
                this.from = new CategoryJSONImpl((JSONObject)object);
            }
            if (!jSONObject.isNull("tags")) {
                object = jSONObject.getJSONObject("tags");
                JSONArray jSONArray = ((JSONObject)object).getJSONArray("data");
                n3 = jSONArray.length();
                this.tags = new PagableListImpl<Tag>(n3, (JSONObject)object, new Tag[0]);
                for (n2 = 0; n2 < n3; ++n2) {
                    facebookResponseImpl = new TagJSONImpl(jSONArray.getJSONObject(n2));
                    this.tags.add(facebookResponseImpl);
                }
            } else {
                this.tags = new PagableListImpl<Tag>();
            }
            this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
            this.icon = z_F4JInternalParseUtil.getURL("icon", jSONObject);
            this.picture = z_F4JInternalParseUtil.getURL("picture", jSONObject);
            this.source = z_F4JInternalParseUtil.getURL("source", jSONObject);
            if (!jSONObject.isNull("height")) {
                this.height = z_F4JInternalParseUtil.getPrimitiveInt("height", jSONObject);
            }
            if (!jSONObject.isNull("width")) {
                this.width = z_F4JInternalParseUtil.getPrimitiveInt("width", jSONObject);
            }
            if (!jSONObject.isNull("images")) {
                this.images = new ArrayList<Image>();
                object = jSONObject.getJSONArray("images");
                for (int i2 = 0; i2 < ((JSONArray)object).length(); ++i2) {
                    JSONObject jSONObject2 = ((JSONArray)object).getJSONObject(i2);
                    this.images.add(new ImageJSONImpl(jSONObject2));
                }
            } else {
                this.images = Collections.emptyList();
            }
            this.link = z_F4JInternalParseUtil.getURL("link", jSONObject);
            if (!jSONObject.isNull("place")) {
                object = jSONObject.getJSONObject("place");
                this.place = new PlaceJSONImpl((JSONObject)object);
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
            if (!jSONObject.isNull("position")) {
                this.position = z_F4JInternalParseUtil.getPrimitiveInt("position", jSONObject);
            }
            if (!jSONObject.isNull("comments")) {
                object = jSONObject.getJSONObject("comments");
                if (!((JSONObject)object).isNull("data")) {
                    JSONArray jSONArray = ((JSONObject)object).getJSONArray("data");
                    n3 = jSONArray.length();
                    this.comments = new PagableListImpl<Comment>(n3, (JSONObject)object, new Comment[0]);
                    for (n2 = 0; n2 < n3; ++n2) {
                        facebookResponseImpl = new CommentJSONImpl(jSONArray.getJSONObject(n2));
                        this.comments.add(facebookResponseImpl);
                    }
                } else {
                    this.comments = new PagableListImpl<Comment>(1, (JSONObject)object, new Comment[0]);
                }
            } else {
                this.comments = new PagableListImpl<Comment>(0);
            }
            if (!jSONObject.isNull("likes")) {
                object = jSONObject.getJSONObject("likes");
                if (!((JSONObject)object).isNull("data")) {
                    JSONArray jSONArray = ((JSONObject)object).getJSONArray("data");
                    n3 = jSONArray.length();
                    this.likes = new PagableListImpl<Like>(n3, (JSONObject)object, new Like[0]);
                    for (n2 = 0; n2 < n3; ++n2) {
                        facebookResponseImpl = new LikeJSONImpl(jSONArray.getJSONObject(n2));
                        this.likes.add(facebookResponseImpl);
                    }
                } else {
                    this.likes = new PagableListImpl<Like>(1, (JSONObject)object, new Like[0]);
                }
            } else {
                this.likes = new PagableListImpl<Like>(0);
            }
            if (!jSONObject.isNull("album")) {
                this.album = new CategoryJSONImpl(jSONObject.getJSONObject("album"));
            }
            if (!jSONObject.isNull("reactions")) {
                object = jSONObject.getJSONObject("reactions");
                if (!((JSONObject)object).isNull("data")) {
                    JSONArray jSONArray = ((JSONObject)object).getJSONArray("data");
                    n3 = jSONArray.length();
                    this.reactions = new PagableListImpl<Reaction>(n3, (JSONObject)object, new Reaction[0]);
                    for (n2 = 0; n2 < n3; ++n2) {
                        facebookResponseImpl = new ReactionJSONImpl(jSONArray.getJSONObject(n2));
                        this.reactions.add(facebookResponseImpl);
                    }
                } else {
                    this.reactions = new PagableListImpl<Reaction>(1, (JSONObject)object, new Reaction[0]);
                }
            } else {
                this.reactions = new PagableListImpl<Reaction>(0);
            }
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Category getFrom() {
        return this.from;
    }

    @Override
    public PagableList<Tag> getTags() {
        return this.tags;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    @Override
    public URL getPicture() {
        return this.picture;
    }

    @Override
    public URL getSource() {
        return this.source;
    }

    @Override
    public Integer getHeight() {
        return this.height;
    }

    @Override
    public Integer getWidth() {
        return this.width;
    }

    @Override
    public List<Image> getImages() {
        return this.images;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public Integer getPosition() {
        return this.position;
    }

    @Override
    public PagableList<Comment> getComments() {
        return this.comments;
    }

    @Override
    public PagableList<Like> getLikes() {
        return this.likes;
    }

    @Override
    public Category getAlbum() {
        return this.album;
    }

    @Override
    public PagableList<Reaction> getReactions() {
        return this.reactions;
    }

    static ResponseList<Photo> createPhotoList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Photo> responseListImpl = new ResponseListImpl<Photo>(n2, jSONObject, new Photo[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                PhotoJSONImpl photoJSONImpl = new PhotoJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(photoJSONImpl, jSONObject2);
                }
                responseListImpl.add(photoJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PhotoJSONImpl photoJSONImpl = (PhotoJSONImpl)object;
        return !(this.id == null ? photoJSONImpl.id != null : !this.id.equals(photoJSONImpl.id));
    }

    public String toString() {
        return "PhotoJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", tags=" + this.tags + ", name='" + this.name + '\'' + ", icon=" + this.icon + ", picture=" + this.picture + ", source=" + this.source + ", height=" + this.height + ", width=" + this.width + ", images=" + this.images + ", link=" + this.link + ", place=" + this.place + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", position=" + this.position + ", comments=" + this.comments + ", likes=" + this.likes + ", album=" + this.album + '}';
    }
}

