/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Cover;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.Page;
import be.maximvdw.tabcore.facebook.Place;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.CoverJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.PlaceJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PageJSONImpl
extends FacebookResponseImpl
implements Page,
Serializable {
    private static final long serialVersionUID = -5784064954222183184L;
    private String id;
    private String name;
    private String category;
    private Date createdTime;
    private URL link;
    private Boolean isPublished;
    private Boolean canPost;
    private Integer likes;
    private Place.Location location;
    private String phone;
    private Integer checkins;
    private URL picture;
    private Cover cover;
    private String website;
    private String companyOverview;
    private Integer talkingAboutCount;
    private String accessToken;
    private Boolean isCommunityPage;
    private Integer wereHereCount;
    private Integer fanCount;
    private String about;
    private String username;

    PageJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    PageJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
        this.name = z_F4JInternalParseUtil.getRawString("name", jSONObject);
        this.category = z_F4JInternalParseUtil.getRawString("category", jSONObject);
        this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
        try {
            JSONObject jSONObject2;
            this.link = z_F4JInternalParseUtil.getURL("link", jSONObject);
            this.isPublished = z_F4JInternalParseUtil.getBoolean("is_published", jSONObject);
            this.canPost = z_F4JInternalParseUtil.getBoolean("can_post", jSONObject);
            this.likes = z_F4JInternalParseUtil.getInt("likes", jSONObject);
            if (!jSONObject.isNull("location")) {
                jSONObject2 = jSONObject.getJSONObject("location");
                this.location = new PlaceJSONImpl.LocationJSONImpl(jSONObject2);
            }
            this.phone = z_F4JInternalParseUtil.getRawString("phone", jSONObject);
            this.checkins = z_F4JInternalParseUtil.getInt("checkins", jSONObject);
            this.picture = z_F4JInternalParseUtil.getURL("picture", jSONObject);
            if (!jSONObject.isNull("cover")) {
                jSONObject2 = jSONObject.getJSONObject("cover");
                this.cover = new CoverJSONImpl(jSONObject2);
            }
            this.website = z_F4JInternalParseUtil.getRawString("website", jSONObject);
            this.companyOverview = z_F4JInternalParseUtil.getRawString("company_overview", jSONObject);
            this.talkingAboutCount = z_F4JInternalParseUtil.getInt("talking_about_count", jSONObject);
            this.accessToken = z_F4JInternalParseUtil.getRawString("access_token", jSONObject);
            this.isCommunityPage = z_F4JInternalParseUtil.getBoolean("is_community_page", jSONObject);
            this.wereHereCount = z_F4JInternalParseUtil.getInt("were_here_count", jSONObject);
            this.fanCount = z_F4JInternalParseUtil.getInt("fan_count", jSONObject);
            this.about = z_F4JInternalParseUtil.getRawString("about", jSONObject);
            this.username = z_F4JInternalParseUtil.getRawString("username", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public URL getLink() {
        return this.link;
    }

    @Override
    public Boolean isPublished() {
        return this.isPublished;
    }

    @Override
    public Boolean canPost() {
        return this.canPost;
    }

    @Override
    public Integer getLikes() {
        return this.likes;
    }

    @Override
    public Place.Location getLocation() {
        return this.location;
    }

    @Override
    public String getPhone() {
        return this.phone;
    }

    @Override
    public Integer getCheckins() {
        return this.checkins;
    }

    @Override
    public URL getPicture() {
        return this.picture;
    }

    @Override
    public Cover getCover() {
        return this.cover;
    }

    @Override
    public String getWebsite() {
        return this.website;
    }

    @Override
    public String getCompanyOverview() {
        return this.companyOverview;
    }

    @Override
    public Integer getTalkingAboutCount() {
        return this.talkingAboutCount;
    }

    @Override
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    public Boolean isCommunityPage() {
        return this.isCommunityPage;
    }

    @Override
    public Integer getWereHereCount() {
        return this.wereHereCount;
    }

    @Override
    public Integer getFanCount() {
        return this.fanCount;
    }

    @Override
    public String getAbout() {
        return this.about;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    static ResponseList<Page> createPageList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Page> responseListImpl = new ResponseListImpl<Page>(n2, jSONObject, new Page[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                PageJSONImpl pageJSONImpl = new PageJSONImpl(jSONArray.getJSONObject(i2));
                responseListImpl.add(pageJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONObject);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PageJSONImpl)) {
            return false;
        }
        PageJSONImpl pageJSONImpl = (PageJSONImpl)object;
        return !(this.id != null ? !this.id.equals(pageJSONImpl.id) : pageJSONImpl.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "PageJSONImpl [link=" + this.link + ", isPublished=" + this.isPublished + ", canPost=" + this.canPost + ", likes=" + this.likes + ", location=" + this.location + ", phone=" + this.phone + ", checkins=" + this.checkins + ", picture=" + this.picture + ", cover=" + this.cover + ", website=" + this.website + ", companyOverview=" + this.companyOverview + ", talkingAboutCount=" + this.talkingAboutCount + ", accessToken=" + this.accessToken + ", isCommunityPage=" + this.isCommunityPage + ", wereHereCount=" + this.wereHereCount + ", fanCount=" + this.fanCount + ", id=" + this.id + ", name=" + this.name + ", category=" + this.category + ", createdTime=" + this.createdTime + ", about=" + this.about + ", username=" + this.username + "]";
    }
}

