/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.Application;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.IdNameEntity;
import be.maximvdw.tabcore.facebook.Location;
import be.maximvdw.tabcore.facebook.PagableList;
import be.maximvdw.tabcore.facebook.Place;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.ApplicationJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.PagableListImpl;
import be.maximvdw.tabcore.facebook.internal.json.PlaceJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocationJSONImpl
extends FacebookResponseImpl
implements Location,
Serializable {
    private static final long serialVersionUID = -5585291369443446494L;
    private String id;
    private IdNameEntity from;
    private PagableList<IdNameEntity> tags;
    private Place place;
    private Application application;
    private Date createdTime;
    private String type;

    LocationJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    LocationJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            JSONObject jSONObject2;
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                jSONObject2 = jSONObject.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(jSONObject2);
            }
            if (!jSONObject.isNull("tags")) {
                jSONObject2 = jSONObject.getJSONObject("tags");
                JSONArray jSONArray = jSONObject2.getJSONArray("data");
                int n2 = jSONArray.length();
                this.tags = new PagableListImpl<IdNameEntity>(n2, jSONObject2, new IdNameEntity[0]);
                for (int i2 = 0; i2 < n2; ++i2) {
                    IdNameEntityJSONImpl idNameEntityJSONImpl = new IdNameEntityJSONImpl(jSONArray.getJSONObject(i2));
                    this.tags.add(idNameEntityJSONImpl);
                }
            } else {
                this.tags = new PagableListImpl<IdNameEntity>(0);
            }
            if (!jSONObject.isNull("place")) {
                jSONObject2 = jSONObject.getJSONObject("place");
                this.place = new PlaceJSONImpl(jSONObject2);
            }
            if (!jSONObject.isNull("application")) {
                jSONObject2 = jSONObject.getJSONObject("application");
                this.application = new ApplicationJSONImpl(jSONObject2);
            }
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.type = z_F4JInternalParseUtil.getRawString("type", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public PagableList<IdNameEntity> getTags() {
        return this.tags;
    }

    @Override
    public Place getPlace() {
        return this.place;
    }

    @Override
    public Application getApplication() {
        return this.application;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public String getType() {
        return this.type;
    }

    static ResponseList<Location> createLocationList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<Location> responseListImpl = new ResponseListImpl<Location>(n2, jSONObject, new Location[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                LocationJSONImpl locationJSONImpl = new LocationJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(locationJSONImpl, jSONObject2);
                }
                responseListImpl.add(locationJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LocationJSONImpl locationJSONImpl = (LocationJSONImpl)object;
        return !(this.id == null ? locationJSONImpl.id != null : !this.id.equals(locationJSONImpl.id));
    }

    public String toString() {
        return "LocationJSONImpl [id=" + this.id + ", from=" + this.from + ", tags=" + this.tags + ", place=" + this.place + ", application=" + this.application + ", createdTime=" + this.createdTime + ", type=" + this.type + "]";
    }
}

