/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.json;

import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.GroupDoc;
import be.maximvdw.tabcore.facebook.IdNameEntity;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.conf.Configuration;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.DataObjectFactoryUtil;
import be.maximvdw.tabcore.facebook.internal.json.FacebookResponseImpl;
import be.maximvdw.tabcore.facebook.internal.json.IdNameEntityJSONImpl;
import be.maximvdw.tabcore.facebook.internal.json.ResponseListImpl;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GroupDocJSONImpl
extends FacebookResponseImpl
implements GroupDoc,
Serializable {
    private static final long serialVersionUID = -4514164915020257301L;
    private String id;
    private IdNameEntity from;
    private String subject;
    private String message;
    private URL icon;
    private Date createdTime;
    private Date updatedTime;
    private Long revision;
    private Boolean canEdit;
    private Boolean canDelete;

    GroupDocJSONImpl(HttpResponse httpResponse, Configuration configuration) {
        super(httpResponse);
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.init(jSONObject);
        if (configuration.isJSONStoreEnabled()) {
            DataObjectFactoryUtil.clearThreadLocalMap();
            DataObjectFactoryUtil.registerJSONObject(this, jSONObject);
        }
    }

    GroupDocJSONImpl(JSONObject jSONObject) {
        this.init(jSONObject);
    }

    private void init(JSONObject jSONObject) {
        try {
            this.id = z_F4JInternalParseUtil.getRawString("id", jSONObject);
            if (!jSONObject.isNull("from")) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("from");
                this.from = new IdNameEntityJSONImpl(jSONObject2);
            }
            this.subject = z_F4JInternalParseUtil.getRawString("subject", jSONObject);
            this.message = z_F4JInternalParseUtil.getRawString("message", jSONObject);
            this.icon = z_F4JInternalParseUtil.getURL("icon", jSONObject);
            this.createdTime = z_F4JInternalParseUtil.getISO8601Datetime("created_time", jSONObject);
            this.updatedTime = z_F4JInternalParseUtil.getISO8601Datetime("updated_time", jSONObject);
            this.revision = z_F4JInternalParseUtil.getLong("revision", jSONObject);
            this.canEdit = z_F4JInternalParseUtil.getBoolean("can_edit", jSONObject);
            this.canDelete = z_F4JInternalParseUtil.getBoolean("can_delete", jSONObject);
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException.getMessage(), jSONException);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public IdNameEntity getFrom() {
        return this.from;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public URL getIcon() {
        return this.icon;
    }

    @Override
    public Date getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public Date getUpdatedTime() {
        return this.updatedTime;
    }

    @Override
    public Long getRevision() {
        return this.revision;
    }

    @Override
    public Boolean canEdit() {
        return this.canEdit;
    }

    @Override
    public Boolean canDelete() {
        return this.canDelete;
    }

    static ResponseList<GroupDoc> createGroupDocList(HttpResponse httpResponse, Configuration configuration) {
        try {
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            JSONObject jSONObject = httpResponse.asJSONObject();
            JSONArray jSONArray = jSONObject.getJSONArray("data");
            int n2 = jSONArray.length();
            ResponseListImpl<GroupDoc> responseListImpl = new ResponseListImpl<GroupDoc>(n2, jSONObject, new GroupDoc[0]);
            for (int i2 = 0; i2 < n2; ++i2) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i2);
                GroupDocJSONImpl groupDocJSONImpl = new GroupDocJSONImpl(jSONObject2);
                if (configuration.isJSONStoreEnabled()) {
                    DataObjectFactoryUtil.registerJSONObject(groupDocJSONImpl, jSONObject2);
                }
                responseListImpl.add(groupDocJSONImpl);
            }
            if (configuration.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.registerJSONObject(responseListImpl, jSONArray);
            }
            return responseListImpl;
        }
        catch (JSONException jSONException) {
            throw new FacebookException(jSONException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.id == null ? 0 : this.id.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        GroupDocJSONImpl groupDocJSONImpl = (GroupDocJSONImpl)object;
        return !(this.id == null ? groupDocJSONImpl.id != null : !this.id.equals(groupDocJSONImpl.id));
    }

    public String toString() {
        return "GroupDocJSONImpl{id='" + this.id + '\'' + ", from=" + this.from + ", subject='" + this.subject + '\'' + ", message='" + this.message + '\'' + ", icon=" + this.icon + ", createdTime=" + this.createdTime + ", updatedTime=" + this.updatedTime + ", revision=" + this.revision + ", canEdit=" + this.canEdit + ", canDelete=" + this.canDelete + '}';
    }
}

