/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.internal.http;

import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.internal.http.HttpRequest;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;

public final class HttpResponseEvent {
    private HttpRequest request;
    private HttpResponse response;
    private FacebookException FacebookException;

    HttpResponseEvent(HttpRequest httpRequest, HttpResponse httpResponse, FacebookException facebookException) {
        this.request = httpRequest;
        this.response = httpResponse;
        this.FacebookException = facebookException;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public FacebookException getFacebookException() {
        return this.FacebookException;
    }

    public boolean isAuthenticated() {
        return this.request.getAuthorization().isEnabled();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HttpResponseEvent httpResponseEvent = (HttpResponseEvent)object;
        if (this.request != null ? !this.request.equals(httpResponseEvent.request) : httpResponseEvent.request != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals(httpResponseEvent.response) : httpResponseEvent.response != null);
    }

    public int hashCode() {
        int n2 = this.request != null ? this.request.hashCode() : 0;
        n2 = 31 * n2 + (this.response != null ? this.response.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "HttpResponseEvent{request=" + this.request + ", response=" + this.response + '}';
    }
}

