/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook.auth;

import be.maximvdw.tabcore.facebook.auth.AuthType;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.Serializable;
import java.util.Arrays;

public class AccessToken
implements Serializable {
    private static final long serialVersionUID = -569157870319118047L;
    private String token;
    private String type;
    private Long expires;
    private AuthType authType;
    private String authNonce;
    String[] responseStr = null;

    public AccessToken(HttpResponse httpResponse) {
        String string = httpResponse.getResponseHeader("facebook-api-version");
        if (Double.parseDouble(string.substring(1)) < 2.3 && !httpResponse.asString().startsWith("{")) {
            this.parseQueryString(httpResponse.asString());
            return;
        }
        JSONObject jSONObject = httpResponse.asJSONObject();
        this.token = z_F4JInternalParseUtil.getRawString("access_token", jSONObject);
        this.type = z_F4JInternalParseUtil.getRawString("token_type", jSONObject);
        this.expires = z_F4JInternalParseUtil.getLong("expires_in", jSONObject);
        this.authType = AuthType.of(z_F4JInternalParseUtil.getRawString("auth_type", jSONObject));
        this.authNonce = z_F4JInternalParseUtil.getRawString("auth_nonce", jSONObject);
    }

    public AccessToken(String string) {
        this.parseQueryString(string);
    }

    public AccessToken(String string, Long l2) {
        this.token = string;
        this.expires = l2;
    }

    private void parseQueryString(String string) {
        if (string.contains("access_token=")) {
            this.responseStr = string.split("&");
            this.token = this.getParameter("access_token");
            if (this.responseStr.length > 1) {
                this.expires = Long.valueOf(this.getParameter("expires"));
            }
        } else {
            this.token = string;
            this.expires = null;
        }
    }

    public String getParameter(String string) {
        String string2 = null;
        for (String string3 : this.responseStr) {
            if (!string3.startsWith(string + '=')) continue;
            string2 = string3.split("=")[1].trim();
            break;
        }
        return string2;
    }

    public String getToken() {
        return this.token;
    }

    public String getType() {
        return this.type;
    }

    public Long getExpires() {
        return this.expires;
    }

    public String getAuthNonce() {
        return this.authNonce;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessToken)) {
            return false;
        }
        AccessToken accessToken = (AccessToken)object;
        return !(this.token != null ? !this.token.equals(accessToken.token) : accessToken.token != null);
    }

    public int hashCode() {
        return this.token != null ? this.token.hashCode() : 0;
    }

    public String toString() {
        return "AccessToken{token='" + this.token + '\'' + ", type='" + this.type + '\'' + ", expires=" + this.expires + ", authType=" + (Object)((Object)this.authType) + ", authNonce=" + this.authNonce + ", responseStr=" + Arrays.toString(this.responseStr) + '}';
    }
}

