/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook;

import be.maximvdw.tabcore.facebook.Media;
import be.maximvdw.tabcore.facebook.internal.http.HttpParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

public class VideoUpdate
implements Serializable {
    private static final long serialVersionUID = -757292229143435735L;
    private Media source;
    private String title;
    private String description;
    private Boolean published;
    private Integer scheduledPublishTime;

    public VideoUpdate(Media media) {
        this.source = media;
    }

    public Media getSource() {
        return this.source;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public VideoUpdate title(String string) {
        this.setTitle(string);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public VideoUpdate description(String string) {
        this.setDescription(string);
        return this;
    }

    public Boolean getPublished() {
        return this.published;
    }

    public void setPublished(Boolean bl2) {
        this.published = bl2;
    }

    public VideoUpdate published(boolean bl2) {
        this.setPublished(bl2);
        return this;
    }

    public Integer getScheduledPublishTime() {
        return this.scheduledPublishTime;
    }

    public void setScheduledPublishTime(Integer n2) {
        this.scheduledPublishTime = n2;
    }

    public void setScheduledPublishTime(Date date) {
        long l2 = date.getTime() / 1000L;
        this.setScheduledPublishTime(Long.valueOf(l2).intValue());
    }

    public VideoUpdate scheduledPublishTime(Integer n2) {
        this.setScheduledPublishTime(n2);
        return this;
    }

    public VideoUpdate scheduledPublishTime(Date date) {
        long l2 = date.getTime() / 1000L;
        return this.scheduledPublishTime(Long.valueOf(l2).intValue());
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>();
        arrayList.add(this.source.asHttpParameter("source"));
        if (this.title != null) {
            arrayList.add(new HttpParameter("title", this.title));
        }
        if (this.description != null) {
            arrayList.add(new HttpParameter("description", this.description));
        }
        if (this.published != null) {
            arrayList.add(new HttpParameter("published", this.published));
        }
        if (this.scheduledPublishTime != null) {
            arrayList.add(new HttpParameter("scheduled_publish_time", this.scheduledPublishTime));
        }
        return arrayList.toArray(new HttpParameter[arrayList.size()]);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VideoUpdate)) {
            return false;
        }
        VideoUpdate videoUpdate = (VideoUpdate)object;
        if (this.description != null ? !this.description.equals(videoUpdate.description) : videoUpdate.description != null) {
            return false;
        }
        if (this.published != null ? !this.published.equals(videoUpdate.published) : videoUpdate.published != null) {
            return false;
        }
        if (this.scheduledPublishTime != null ? !this.scheduledPublishTime.equals(videoUpdate.scheduledPublishTime) : videoUpdate.scheduledPublishTime != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(videoUpdate.source) : videoUpdate.source != null) {
            return false;
        }
        return !(this.title != null ? !this.title.equals(videoUpdate.title) : videoUpdate.title != null);
    }

    public int hashCode() {
        int n2 = this.source != null ? this.source.hashCode() : 0;
        n2 = 31 * n2 + (this.title != null ? this.title.hashCode() : 0);
        n2 = 31 * n2 + (this.description != null ? this.description.hashCode() : 0);
        n2 = 31 * n2 + (this.published != null ? this.published.hashCode() : 0);
        n2 = 31 * n2 + (this.scheduledPublishTime != null ? this.scheduledPublishTime.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "VideoUpdate{source=" + this.source + ", title='" + this.title + '\'' + ", description='" + this.description + '\'' + ", published=" + this.published + ", scheduledPublishTime=" + this.scheduledPublishTime + '}';
    }
}

