/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook;

import be.maximvdw.tabcore.facebook.internal.http.HttpParameter;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuestionUpdate
implements Serializable {
    private static final long serialVersionUID = 6854301390218101794L;
    private String question;
    private List<String> options;
    private Boolean allowNewOptions;
    private Boolean published;
    private Integer scheduledPublishTime;

    public QuestionUpdate() {
    }

    public QuestionUpdate(String string) {
        this.question = string;
    }

    public String getQuestion() {
        return this.question;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> list) {
        this.options = list;
    }

    public QuestionUpdate options(List<String> list) {
        this.setOptions(list);
        return this;
    }

    public QuestionUpdate option(String string) {
        if (this.options == null) {
            this.options = new ArrayList<String>();
        }
        this.options.add(string);
        return this;
    }

    public Boolean getAllowNewOptions() {
        return this.allowNewOptions;
    }

    public void setAllowNewOptions(Boolean bl2) {
        this.allowNewOptions = bl2;
    }

    public QuestionUpdate allowNewOptions(boolean bl2) {
        this.setAllowNewOptions(bl2);
        return this;
    }

    public Boolean getPublished() {
        return this.published;
    }

    public void setPublished(Boolean bl2) {
        this.published = bl2;
    }

    public QuestionUpdate published(boolean bl2) {
        this.setPublished(bl2);
        return this;
    }

    public Integer getScheduledPublishTime() {
        return this.scheduledPublishTime;
    }

    public void setScheduledPublishTime(Integer n2) {
        this.scheduledPublishTime = n2;
    }

    public void setScheduledPublishTime(Date date) {
        long l2 = date.getTime() / 1000L;
        this.setScheduledPublishTime(Long.valueOf(l2).intValue());
    }

    public QuestionUpdate scheduledPublishTime(Integer n2) {
        this.setScheduledPublishTime(n2);
        return this;
    }

    public QuestionUpdate scheduledPublishTime(Date date) {
        long l2 = date.getTime() / 1000L;
        return this.scheduledPublishTime(Long.valueOf(l2).intValue());
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>();
        arrayList.add(new HttpParameter("question", this.question));
        if (this.options != null && this.options.size() != 0) {
            arrayList.add(new HttpParameter("options", new JSONArray(this.options).toString()));
        }
        if (this.allowNewOptions != null) {
            arrayList.add(new HttpParameter("allow_new_options", this.allowNewOptions));
        }
        if (this.published != null) {
            arrayList.add(new HttpParameter("published", this.published));
        }
        if (this.scheduledPublishTime != null) {
            arrayList.add(new HttpParameter("scheduled_publish_time", this.scheduledPublishTime));
        }
        return arrayList.toArray(new HttpParameter[arrayList.size()]);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof QuestionUpdate)) {
            return false;
        }
        QuestionUpdate questionUpdate = (QuestionUpdate)object;
        if (this.allowNewOptions != null ? !this.allowNewOptions.equals(questionUpdate.allowNewOptions) : questionUpdate.allowNewOptions != null) {
            return false;
        }
        if (this.options != null ? !((Object)this.options).equals(questionUpdate.options) : questionUpdate.options != null) {
            return false;
        }
        if (this.published != null ? !this.published.equals(questionUpdate.published) : questionUpdate.published != null) {
            return false;
        }
        if (this.question != null ? !this.question.equals(questionUpdate.question) : questionUpdate.question != null) {
            return false;
        }
        return !(this.scheduledPublishTime != null ? !this.scheduledPublishTime.equals(questionUpdate.scheduledPublishTime) : questionUpdate.scheduledPublishTime != null);
    }

    public int hashCode() {
        int n2 = this.question != null ? this.question.hashCode() : 0;
        n2 = 31 * n2 + (this.options != null ? ((Object)this.options).hashCode() : 0);
        n2 = 31 * n2 + (this.allowNewOptions != null ? this.allowNewOptions.hashCode() : 0);
        n2 = 31 * n2 + (this.published != null ? this.published.hashCode() : 0);
        n2 = 31 * n2 + (this.scheduledPublishTime != null ? this.scheduledPublishTime.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "QuestionUpdate{question='" + this.question + '\'' + ", options=" + this.options + ", allowNewOptions=" + this.allowNewOptions + ", published=" + this.published + ", scheduledPublishTime=" + this.scheduledPublishTime + '}';
    }
}

