/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.tabcore.facebook;

import be.maximvdw.tabcore.facebook.BatchResponse;
import be.maximvdw.tabcore.facebook.FacebookException;
import be.maximvdw.tabcore.facebook.ResponseList;
import be.maximvdw.tabcore.facebook.internal.http.HttpResponse;
import be.maximvdw.tabcore.facebook.internal.json.z_F4JInternalFactory;
import be.maximvdw.tabcore.facebook.internal.json.z_F4JInternalJSONImplFactory;
import be.maximvdw.tabcore.facebook.internal.logging.Logger;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONArray;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONException;
import be.maximvdw.tabcore.facebook.internal.org.json.JSONObject;
import be.maximvdw.tabcore.facebook.internal.util.z_F4JInternalParseUtil;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchResponseImpl
extends HttpResponse
implements BatchResponse,
Serializable {
    private static final long serialVersionUID = -6354217417137066979L;
    private static final Logger logger = Logger.getLogger(BatchResponseImpl.class);
    private JSONObject json;
    private ConcurrentHashMap<String, List<String>> headers = new ConcurrentHashMap();
    private JSONObject bodyJson = null;
    private final z_F4JInternalFactory factory = new z_F4JInternalJSONImplFactory(null);
    private JSONArray bodyJsonArray = null;

    BatchResponseImpl(JSONObject jSONObject) {
        this.json = jSONObject;
        if (null != jSONObject) {
            this.statusCode = z_F4JInternalParseUtil.getInt("code", jSONObject);
        }
    }

    @Override
    public String getResponseHeader(String string) {
        if (this.json == null) {
            return null;
        }
        if (this.headers.isEmpty()) {
            this.cacheHeaders();
        }
        if (!this.headers.containsKey(string)) {
            return null;
        }
        List<String> list = this.headers.get(string);
        return list.get(list.size() - 1);
    }

    @Override
    public Map<String, List<String>> getResponseHeaderFields() {
        if (this.headers.isEmpty()) {
            this.cacheHeaders();
        }
        return this.headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheHeaders() {
        try {
            JSONArray jSONArray = this.json.getJSONArray("headers");
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                String string = z_F4JInternalParseUtil.getRawString("name", jSONObject);
                String string2 = z_F4JInternalParseUtil.getRawString("value", jSONObject);
                ConcurrentHashMap<String, List<String>> concurrentHashMap = this.headers;
                synchronized (concurrentHashMap) {
                    List<String> list = this.headers.get(string);
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    list.add(string2);
                    this.headers.put(string, list);
                    continue;
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    @Override
    public String asString() {
        if (null == this.responseAsString && null != this.json) {
            this.responseAsString = z_F4JInternalParseUtil.getRawString("body", this.json);
        }
        return this.responseAsString;
    }

    @Override
    public JSONObject asJSONObject() {
        if (this.bodyJson == null) {
            try {
                this.bodyJson = new JSONObject(this.asString());
                if (this.CONF.isPrettyDebugEnabled()) {
                    logger.debug(this.bodyJson.toString(1));
                } else {
                    logger.debug(this.responseAsString != null ? this.responseAsString : this.bodyJson.toString());
                }
            }
            catch (JSONException jSONException) {
                if (this.responseAsString == null) {
                    throw new FacebookException(jSONException.getMessage(), jSONException);
                }
                throw new FacebookException(jSONException.getMessage() + ":" + this.responseAsString, jSONException);
            }
        }
        return this.bodyJson;
    }

    @Override
    public ResponseList<JSONObject> asResponseList() {
        return this.factory.createJSONObjectList(this.asJSONObject());
    }

    @Override
    public JSONArray asJSONArray() {
        if (this.bodyJsonArray == null) {
            try {
                this.bodyJsonArray = new JSONArray(this.asString());
                if (this.CONF.isPrettyDebugEnabled()) {
                    logger.debug(this.bodyJsonArray.toString(1));
                } else {
                    logger.debug(this.responseAsString != null ? this.responseAsString : this.bodyJsonArray.toString());
                }
            }
            catch (JSONException jSONException) {
                if (this.responseAsString == null) {
                    throw new FacebookException(jSONException.getMessage(), jSONException);
                }
                throw new FacebookException(jSONException.getMessage() + ":" + this.responseAsString, jSONException);
            }
        }
        return this.bodyJsonArray;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public InputStream asStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader asReader() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return "BatchResponse{statusCode=" + this.statusCode + ", responseAsString=" + this.responseAsString + ", json=" + this.json + '}';
    }
}

