/*
 * Decompiled with CFR 0.152.
 */
package ru.tehkode.permissions.bukkit;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class PermissionsExConfig {
    private final Configuration config;
    private final PermissionsEx plugin;
    private final boolean useNetEvents;
    private final boolean debug;
    private final boolean allowOps;
    private final boolean userAddGroupsLast;
    private final boolean logPlayers;
    private final boolean createUserRecords;
    private final String defaultBackend;
    private final boolean updaterEnabled;
    private final boolean alwaysUpdate;
    private final boolean informPlayers;
    private final List<String> serverTags;
    private final String basedir;

    public PermissionsExConfig(Configuration config, PermissionsEx plugin) {
        this.config = config;
        this.plugin = plugin;
        this.useNetEvents = this.getBoolean("multiserver.use-netevents", true);
        this.serverTags = this.getStringList("multiserver.server-tags", new String[0]);
        this.debug = this.getBoolean("permissions.debug", false);
        this.allowOps = this.getBoolean("permissions.allowOps", false);
        this.userAddGroupsLast = this.getBoolean("permissions.user-add-groups-last", false);
        this.logPlayers = this.getBoolean("permissions.log-players", false);
        this.createUserRecords = this.getBoolean("permissions.createUserRecords", false);
        this.defaultBackend = this.getString("permissions.backend", "file");
        this.updaterEnabled = this.getBoolean("updater", true);
        this.alwaysUpdate = this.getBoolean("alwaysUpdate", false);
        this.informPlayers = this.getBoolean("permissions.informplayers.changes", false);
        this.basedir = this.getString("permissions.basedir", "plugins/PermissionsEx");
    }

    private boolean getBoolean(String key, boolean def) {
        if (!this.config.isSet(key)) {
            this.config.set(key, (Object)def);
        }
        return this.config.getBoolean(key, def);
    }

    private String getString(String key, String def) {
        String ret = this.config.getString(key);
        if (ret == null) {
            ret = def;
            this.config.set(key, (Object)ret);
        }
        return ret;
    }

    private List<String> getStringList(String key, String ... def) {
        List<String> ret = this.config.getStringList(key);
        if (ret == null) {
            ret = Arrays.asList(def);
            this.config.set(key, ret);
        }
        return Collections.unmodifiableList(ret);
    }

    public boolean useNetEvents() {
        return this.useNetEvents;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean allowOps() {
        return this.allowOps;
    }

    public boolean userAddGroupsLast() {
        return this.userAddGroupsLast;
    }

    public String getDefaultBackend() {
        return this.defaultBackend;
    }

    public boolean shouldLogPlayers() {
        return this.logPlayers;
    }

    public boolean createUserRecords() {
        return this.createUserRecords;
    }

    public boolean updaterEnabled() {
        return this.updaterEnabled;
    }

    public boolean alwaysUpdate() {
        return this.alwaysUpdate;
    }

    public boolean informPlayers() {
        return this.informPlayers;
    }

    public List<String> getServerTags() {
        return this.serverTags;
    }

    public String getBasedir() {
        return this.basedir;
    }

    public ConfigurationSection getBackendConfig(String backend) {
        ConfigurationSection section = this.config.getConfigurationSection("permissions.backends." + backend);
        if (section == null) {
            section = this.config.createSection("permissions.backends." + backend);
        }
        return section;
    }

    public void save() {
        this.plugin.saveConfig();
    }
}

