/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter.management;

import be.maximvdw.featherboardcore.twitter.management.InvocationStatistics;

public class InvocationStatisticsCalculator
implements InvocationStatistics {
    private final String name;
    private long[] times;
    private int index;
    private long callCount;
    private long errorCount;
    private long totalTime;

    public InvocationStatisticsCalculator(String string, int n2) {
        this.name = string;
        this.times = new long[n2];
    }

    void increment(long l2, boolean bl2) {
        ++this.callCount;
        this.errorCount += bl2 ? 0L : 1L;
        this.totalTime += l2;
        this.times[this.index] = l2;
        if (++this.index >= this.times.length) {
            this.index = 0;
        }
    }

    public String getName() {
        return this.name;
    }

    public long getCallCount() {
        return this.callCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public long getTotalTime() {
        return this.totalTime;
    }

    public synchronized long getAverageTime() {
        int n2 = Math.min(Math.abs((int)this.callCount), this.times.length);
        if (n2 == 0) {
            return 0L;
        }
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 += this.times[i2];
        }
        return l2 / (long)n2;
    }

    public synchronized void reset() {
        this.callCount = 0L;
        this.errorCount = 0L;
        this.totalTime = 0L;
        this.times = new long[this.times.length];
        this.index = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("calls=").append(this.getCallCount()).append(",").append("errors=").append(this.getErrorCount()).append(",").append("totalTime=").append(this.getTotalTime()).append(",").append("avgTime=").append(this.getAverageTime());
        return stringBuilder.toString();
    }
}

