/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter.management;

import be.maximvdw.featherboardcore.twitter.management.APIStatisticsMBean;
import be.maximvdw.featherboardcore.twitter.management.InvocationStatistics;
import be.maximvdw.featherboardcore.twitter.management.InvocationStatisticsCalculator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIStatistics
implements APIStatisticsMBean {
    private final InvocationStatisticsCalculator API_STATS_CALCULATOR;
    private final Map<String, InvocationStatisticsCalculator> METHOD_STATS_MAP;
    private final int HISTORY_SIZE;

    public APIStatistics(int n2) {
        this.API_STATS_CALCULATOR = new InvocationStatisticsCalculator("API", n2);
        this.METHOD_STATS_MAP = new HashMap<String, InvocationStatisticsCalculator>(100);
        this.HISTORY_SIZE = n2;
    }

    public synchronized void methodCalled(String string, long l2, boolean bl2) {
        this.getMethodStatistics(string).increment(l2, bl2);
        this.API_STATS_CALCULATOR.increment(l2, bl2);
    }

    private synchronized InvocationStatisticsCalculator getMethodStatistics(String string) {
        InvocationStatisticsCalculator invocationStatisticsCalculator = this.METHOD_STATS_MAP.get(string);
        if (invocationStatisticsCalculator == null) {
            invocationStatisticsCalculator = new InvocationStatisticsCalculator(string, this.HISTORY_SIZE);
            this.METHOD_STATS_MAP.put(string, invocationStatisticsCalculator);
        }
        return invocationStatisticsCalculator;
    }

    @Override
    public synchronized Iterable<? extends InvocationStatistics> getInvocationStatistics() {
        return this.METHOD_STATS_MAP.values();
    }

    @Override
    public synchronized void reset() {
        this.API_STATS_CALCULATOR.reset();
        this.METHOD_STATS_MAP.clear();
    }

    @Override
    public String getName() {
        return this.API_STATS_CALCULATOR.getName();
    }

    @Override
    public long getCallCount() {
        return this.API_STATS_CALCULATOR.getCallCount();
    }

    @Override
    public long getErrorCount() {
        return this.API_STATS_CALCULATOR.getErrorCount();
    }

    @Override
    public long getTotalTime() {
        return this.API_STATS_CALCULATOR.getTotalTime();
    }

    @Override
    public long getAverageTime() {
        return this.API_STATS_CALCULATOR.getAverageTime();
    }

    @Override
    public synchronized Map<String, String> getMethodLevelSummariesAsString() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Collection<InvocationStatisticsCalculator> collection = this.METHOD_STATS_MAP.values();
        for (InvocationStatisticsCalculator invocationStatisticsCalculator : collection) {
            hashMap.put(invocationStatisticsCalculator.getName(), invocationStatisticsCalculator.toString());
        }
        return hashMap;
    }

    @Override
    public synchronized String getMethodLevelSummary(String string) {
        return this.METHOD_STATS_MAP.get(string).toString();
    }
}

