/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter.conf;

import be.maximvdw.featherboardcore.twitter.HttpClientConfiguration;
import be.maximvdw.featherboardcore.twitter.Logger;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

class ConfigurationBase
implements Configuration,
Serializable {
    private static final long serialVersionUID = 6175546394599249696L;
    private boolean debug = false;
    private String user = null;
    private String password = null;
    private HttpClientConfiguration httpConf = new MyHttpClientConfiguration(null, null, null, -1, 20000, 120000, false, true);
    private int httpStreamingReadTimeout = 40000;
    private int httpRetryCount = 0;
    private int httpRetryIntervalSeconds = 5;
    private String oAuthConsumerKey = null;
    private String oAuthConsumerSecret = null;
    private String oAuthAccessToken = null;
    private String oAuthAccessTokenSecret = null;
    private String oAuth2TokenType;
    private String oAuth2AccessToken;
    private String oAuth2Scope;
    private String oAuthRequestTokenURL = "https://api.twitter.com/oauth/request_token";
    private String oAuthAuthorizationURL = "https://api.twitter.com/oauth/authorize";
    private String oAuthAccessTokenURL = "https://api.twitter.com/oauth/access_token";
    private String oAuthAuthenticationURL = "https://api.twitter.com/oauth/authenticate";
    private String oAuth2TokenURL = "https://api.twitter.com/oauth2/token";
    private String oAuth2InvalidateTokenURL = "https://api.twitter.com/oauth2/invalidate_token";
    private String restBaseURL = "https://api.twitter.com/1.1/";
    private String streamBaseURL = "https://stream.twitter.com/1.1/";
    private String userStreamBaseURL = "https://userstream.twitter.com/1.1/";
    private String siteStreamBaseURL = "https://sitestream.twitter.com/1.1/";
    private String uploadBaseURL = "https://upload.twitter.com/1.1/";
    private String dispatcherImpl = "be.maximvdw.featherboardcore.twitter.DispatcherImpl";
    private int asyncNumThreads = 1;
    private String loggerFactory = null;
    private long contributingTo = -1L;
    private boolean includeMyRetweetEnabled = true;
    private boolean includeEntitiesEnabled = true;
    private boolean trimUserEnabled = false;
    private boolean jsonStoreEnabled = false;
    private boolean mbeanEnabled = false;
    private boolean userStreamRepliesAllEnabled = false;
    private boolean userStreamWithFollowingsEnabled = true;
    private boolean stallWarningsEnabled = true;
    private boolean applicationOnlyAuthEnabled = false;
    private String mediaProvider = "TWITTER";
    private String mediaProviderAPIKey = null;
    private Properties mediaProviderParameters = null;
    private boolean daemonEnabled = true;
    private static final List<ConfigurationBase> instances = new ArrayList<ConfigurationBase>();

    protected ConfigurationBase() {
    }

    public void dumpConfiguration() {
        Logger logger = Logger.getLogger(ConfigurationBase.class);
        if (this.debug) {
            Field[] fieldArray;
            for (Field field : fieldArray = ConfigurationBase.class.getDeclaredFields()) {
                try {
                    Object object = field.get(this);
                    String string = String.valueOf(object);
                    if (object != null && field.getName().matches("oAuthConsumerSecret|oAuthAccessTokenSecret|password")) {
                        string = String.valueOf(object).replaceAll(".", "*");
                    }
                    logger.debug(field.getName() + ": " + string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    public final boolean isDebugEnabled() {
        return this.debug;
    }

    protected final void setDebug(boolean bl2) {
        this.debug = bl2;
    }

    public final String getUser() {
        return this.user;
    }

    protected final void setUser(String string) {
        this.user = string;
    }

    public final String getPassword() {
        return this.password;
    }

    public HttpClientConfiguration getHttpClientConfiguration() {
        return this.httpConf;
    }

    protected final void setPassword(String string) {
        this.password = string;
    }

    protected final void setPrettyDebugEnabled(boolean bl2) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), this.httpConf.getHttpProxyUser(), this.httpConf.getHttpProxyPassword(), this.httpConf.getHttpProxyPort(), this.httpConf.getHttpConnectionTimeout(), this.httpConf.getHttpReadTimeout(), bl2, this.httpConf.isGZIPEnabled());
    }

    protected final void setGZIPEnabled(boolean bl2) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), this.httpConf.getHttpProxyUser(), this.httpConf.getHttpProxyPassword(), this.httpConf.getHttpProxyPort(), this.httpConf.getHttpConnectionTimeout(), this.httpConf.getHttpReadTimeout(), this.httpConf.isPrettyDebugEnabled(), bl2);
    }

    protected final void setHttpProxyHost(String string) {
        this.httpConf = new MyHttpClientConfiguration(string, this.httpConf.getHttpProxyUser(), this.httpConf.getHttpProxyPassword(), this.httpConf.getHttpProxyPort(), this.httpConf.getHttpConnectionTimeout(), this.httpConf.getHttpReadTimeout(), this.httpConf.isPrettyDebugEnabled(), this.httpConf.isGZIPEnabled());
    }

    protected final void setHttpProxyUser(String string) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), string, this.httpConf.getHttpProxyPassword(), this.httpConf.getHttpProxyPort(), this.httpConf.getHttpConnectionTimeout(), this.httpConf.getHttpReadTimeout(), this.httpConf.isPrettyDebugEnabled(), this.httpConf.isGZIPEnabled());
    }

    protected final void setHttpProxyPassword(String string) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), this.httpConf.getHttpProxyUser(), string, this.httpConf.getHttpProxyPort(), this.httpConf.getHttpConnectionTimeout(), this.httpConf.getHttpReadTimeout(), this.httpConf.isPrettyDebugEnabled(), this.httpConf.isGZIPEnabled());
    }

    protected final void setHttpProxyPort(int n2) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), this.httpConf.getHttpProxyUser(), this.httpConf.getHttpProxyPassword(), n2, this.httpConf.getHttpConnectionTimeout(), this.httpConf.getHttpReadTimeout(), this.httpConf.isPrettyDebugEnabled(), this.httpConf.isGZIPEnabled());
    }

    protected final void setHttpConnectionTimeout(int n2) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), this.httpConf.getHttpProxyUser(), this.httpConf.getHttpProxyPassword(), this.httpConf.getHttpProxyPort(), n2, this.httpConf.getHttpReadTimeout(), this.httpConf.isPrettyDebugEnabled(), this.httpConf.isGZIPEnabled());
    }

    protected final void setHttpReadTimeout(int n2) {
        this.httpConf = new MyHttpClientConfiguration(this.httpConf.getHttpProxyHost(), this.httpConf.getHttpProxyUser(), this.httpConf.getHttpProxyPassword(), this.httpConf.getHttpProxyPort(), this.httpConf.getHttpConnectionTimeout(), n2, this.httpConf.isPrettyDebugEnabled(), this.httpConf.isGZIPEnabled());
    }

    public int getHttpStreamingReadTimeout() {
        return this.httpStreamingReadTimeout;
    }

    protected final void setHttpStreamingReadTimeout(int n2) {
        this.httpStreamingReadTimeout = n2;
    }

    protected final void setHttpRetryCount(int n2) {
        this.httpRetryCount = n2;
    }

    protected final void setHttpRetryIntervalSeconds(int n2) {
        this.httpRetryIntervalSeconds = n2;
    }

    public final String getOAuthConsumerKey() {
        return this.oAuthConsumerKey;
    }

    protected final void setOAuthConsumerKey(String string) {
        this.oAuthConsumerKey = string;
    }

    public final String getOAuthConsumerSecret() {
        return this.oAuthConsumerSecret;
    }

    protected final void setOAuthConsumerSecret(String string) {
        this.oAuthConsumerSecret = string;
    }

    public String getOAuthAccessToken() {
        return this.oAuthAccessToken;
    }

    protected final void setOAuthAccessToken(String string) {
        this.oAuthAccessToken = string;
    }

    public String getOAuthAccessTokenSecret() {
        return this.oAuthAccessTokenSecret;
    }

    protected final void setOAuthAccessTokenSecret(String string) {
        this.oAuthAccessTokenSecret = string;
    }

    public String getOAuth2TokenType() {
        return this.oAuth2TokenType;
    }

    protected final void setOAuth2TokenType(String string) {
        this.oAuth2TokenType = string;
    }

    public String getOAuth2AccessToken() {
        return this.oAuth2AccessToken;
    }

    public String getOAuth2Scope() {
        return this.oAuth2Scope;
    }

    protected final void setOAuth2AccessToken(String string) {
        this.oAuth2AccessToken = string;
    }

    protected final void setOAuth2Scope(String string) {
        this.oAuth2Scope = string;
    }

    public final int getAsyncNumThreads() {
        return this.asyncNumThreads;
    }

    protected final void setAsyncNumThreads(int n2) {
        this.asyncNumThreads = n2;
    }

    public final long getContributingTo() {
        return this.contributingTo;
    }

    protected final void setContributingTo(long l2) {
        this.contributingTo = l2;
    }

    public String getRestBaseURL() {
        return this.restBaseURL;
    }

    protected final void setRestBaseURL(String string) {
        this.restBaseURL = string;
    }

    public String getUploadBaseURL() {
        return this.uploadBaseURL;
    }

    protected final void setUploadBaseURL(String string) {
        this.uploadBaseURL = string;
    }

    public String getStreamBaseURL() {
        return this.streamBaseURL;
    }

    protected final void setStreamBaseURL(String string) {
        this.streamBaseURL = string;
    }

    public String getUserStreamBaseURL() {
        return this.userStreamBaseURL;
    }

    protected final void setUserStreamBaseURL(String string) {
        this.userStreamBaseURL = string;
    }

    public String getSiteStreamBaseURL() {
        return this.siteStreamBaseURL;
    }

    protected final void setSiteStreamBaseURL(String string) {
        this.siteStreamBaseURL = string;
    }

    public String getOAuthRequestTokenURL() {
        return this.oAuthRequestTokenURL;
    }

    protected final void setOAuthRequestTokenURL(String string) {
        this.oAuthRequestTokenURL = string;
    }

    public String getOAuthAuthorizationURL() {
        return this.oAuthAuthorizationURL;
    }

    protected final void setOAuthAuthorizationURL(String string) {
        this.oAuthAuthorizationURL = string;
    }

    public String getOAuthAccessTokenURL() {
        return this.oAuthAccessTokenURL;
    }

    protected final void setOAuthAccessTokenURL(String string) {
        this.oAuthAccessTokenURL = string;
    }

    public String getOAuthAuthenticationURL() {
        return this.oAuthAuthenticationURL;
    }

    protected final void setOAuthAuthenticationURL(String string) {
        this.oAuthAuthenticationURL = string;
    }

    public String getOAuth2TokenURL() {
        return this.oAuth2TokenURL;
    }

    protected final void setOAuth2TokenURL(String string) {
        this.oAuth2TokenURL = string;
    }

    public String getOAuth2InvalidateTokenURL() {
        return this.oAuth2InvalidateTokenURL;
    }

    protected final void setOAuth2InvalidateTokenURL(String string) {
        this.oAuth2InvalidateTokenURL = string;
    }

    public String getDispatcherImpl() {
        return this.dispatcherImpl;
    }

    protected final void setDispatcherImpl(String string) {
        this.dispatcherImpl = string;
    }

    public String getLoggerFactory() {
        return this.loggerFactory;
    }

    public boolean isIncludeEntitiesEnabled() {
        return this.includeEntitiesEnabled;
    }

    protected void setIncludeEntitiesEnabled(boolean bl2) {
        this.includeEntitiesEnabled = bl2;
    }

    protected final void setLoggerFactory(String string) {
        this.loggerFactory = string;
    }

    public boolean isIncludeMyRetweetEnabled() {
        return this.includeMyRetweetEnabled;
    }

    public void setIncludeMyRetweetEnabled(boolean bl2) {
        this.includeMyRetweetEnabled = bl2;
    }

    public boolean isTrimUserEnabled() {
        return this.trimUserEnabled;
    }

    public boolean isDaemonEnabled() {
        return this.daemonEnabled;
    }

    protected void setDaemonEnabled(boolean bl2) {
        this.daemonEnabled = bl2;
    }

    public void setTrimUserEnabled(boolean bl2) {
        this.trimUserEnabled = bl2;
    }

    public boolean isJSONStoreEnabled() {
        return this.jsonStoreEnabled;
    }

    protected final void setJSONStoreEnabled(boolean bl2) {
        this.jsonStoreEnabled = bl2;
    }

    public boolean isMBeanEnabled() {
        return this.mbeanEnabled;
    }

    protected final void setMBeanEnabled(boolean bl2) {
        this.mbeanEnabled = bl2;
    }

    public boolean isUserStreamRepliesAllEnabled() {
        return this.userStreamRepliesAllEnabled;
    }

    public boolean isUserStreamWithFollowingsEnabled() {
        return this.userStreamWithFollowingsEnabled;
    }

    protected final void setUserStreamRepliesAllEnabled(boolean bl2) {
        this.userStreamRepliesAllEnabled = bl2;
    }

    protected final void setUserStreamWithFollowingsEnabled(boolean bl2) {
        this.userStreamWithFollowingsEnabled = bl2;
    }

    public boolean isStallWarningsEnabled() {
        return this.stallWarningsEnabled;
    }

    protected final void setStallWarningsEnabled(boolean bl2) {
        this.stallWarningsEnabled = bl2;
    }

    public boolean isApplicationOnlyAuthEnabled() {
        return this.applicationOnlyAuthEnabled;
    }

    protected final void setApplicationOnlyAuthEnabled(boolean bl2) {
        this.applicationOnlyAuthEnabled = bl2;
    }

    public String getMediaProvider() {
        return this.mediaProvider;
    }

    protected final void setMediaProvider(String string) {
        this.mediaProvider = string;
    }

    public String getMediaProviderAPIKey() {
        return this.mediaProviderAPIKey;
    }

    protected final void setMediaProviderAPIKey(String string) {
        this.mediaProviderAPIKey = string;
    }

    public Properties getMediaProviderParameters() {
        return this.mediaProviderParameters;
    }

    protected final void setMediaProviderParameters(Properties properties) {
        this.mediaProviderParameters = properties;
    }

    static String fixURL(boolean bl2, String string) {
        if (null == string) {
            return null;
        }
        int n2 = string.indexOf("://");
        if (-1 == n2) {
            throw new IllegalArgumentException("url should contain '://'");
        }
        String string2 = string.substring(n2 + 3);
        if (bl2) {
            return "https://" + string2;
        }
        return "http://" + string2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConfigurationBase configurationBase = (ConfigurationBase)object;
        if (this.applicationOnlyAuthEnabled != configurationBase.applicationOnlyAuthEnabled) {
            return false;
        }
        if (this.asyncNumThreads != configurationBase.asyncNumThreads) {
            return false;
        }
        if (this.contributingTo != configurationBase.contributingTo) {
            return false;
        }
        if (this.daemonEnabled != configurationBase.daemonEnabled) {
            return false;
        }
        if (this.debug != configurationBase.debug) {
            return false;
        }
        if (this.httpRetryCount != configurationBase.httpRetryCount) {
            return false;
        }
        if (this.httpRetryIntervalSeconds != configurationBase.httpRetryIntervalSeconds) {
            return false;
        }
        if (this.httpStreamingReadTimeout != configurationBase.httpStreamingReadTimeout) {
            return false;
        }
        if (this.includeEntitiesEnabled != configurationBase.includeEntitiesEnabled) {
            return false;
        }
        if (this.includeMyRetweetEnabled != configurationBase.includeMyRetweetEnabled) {
            return false;
        }
        if (this.jsonStoreEnabled != configurationBase.jsonStoreEnabled) {
            return false;
        }
        if (this.mbeanEnabled != configurationBase.mbeanEnabled) {
            return false;
        }
        if (this.stallWarningsEnabled != configurationBase.stallWarningsEnabled) {
            return false;
        }
        if (this.trimUserEnabled != configurationBase.trimUserEnabled) {
            return false;
        }
        if (this.userStreamRepliesAllEnabled != configurationBase.userStreamRepliesAllEnabled) {
            return false;
        }
        if (this.userStreamWithFollowingsEnabled != configurationBase.userStreamWithFollowingsEnabled) {
            return false;
        }
        if (this.dispatcherImpl != null ? !this.dispatcherImpl.equals(configurationBase.dispatcherImpl) : configurationBase.dispatcherImpl != null) {
            return false;
        }
        if (this.httpConf != null ? !this.httpConf.equals(configurationBase.httpConf) : configurationBase.httpConf != null) {
            return false;
        }
        if (this.loggerFactory != null ? !this.loggerFactory.equals(configurationBase.loggerFactory) : configurationBase.loggerFactory != null) {
            return false;
        }
        if (this.mediaProvider != null ? !this.mediaProvider.equals(configurationBase.mediaProvider) : configurationBase.mediaProvider != null) {
            return false;
        }
        if (this.mediaProviderAPIKey != null ? !this.mediaProviderAPIKey.equals(configurationBase.mediaProviderAPIKey) : configurationBase.mediaProviderAPIKey != null) {
            return false;
        }
        if (this.mediaProviderParameters != null ? !this.mediaProviderParameters.equals(configurationBase.mediaProviderParameters) : configurationBase.mediaProviderParameters != null) {
            return false;
        }
        if (this.oAuth2AccessToken != null ? !this.oAuth2AccessToken.equals(configurationBase.oAuth2AccessToken) : configurationBase.oAuth2AccessToken != null) {
            return false;
        }
        if (this.oAuth2InvalidateTokenURL != null ? !this.oAuth2InvalidateTokenURL.equals(configurationBase.oAuth2InvalidateTokenURL) : configurationBase.oAuth2InvalidateTokenURL != null) {
            return false;
        }
        if (this.oAuth2TokenType != null ? !this.oAuth2TokenType.equals(configurationBase.oAuth2TokenType) : configurationBase.oAuth2TokenType != null) {
            return false;
        }
        if (this.oAuth2TokenURL != null ? !this.oAuth2TokenURL.equals(configurationBase.oAuth2TokenURL) : configurationBase.oAuth2TokenURL != null) {
            return false;
        }
        if (this.oAuth2Scope != null ? !this.oAuth2Scope.equals(configurationBase.oAuth2Scope) : configurationBase.oAuth2Scope != null) {
            return false;
        }
        if (this.oAuthAccessToken != null ? !this.oAuthAccessToken.equals(configurationBase.oAuthAccessToken) : configurationBase.oAuthAccessToken != null) {
            return false;
        }
        if (this.oAuthAccessTokenSecret != null ? !this.oAuthAccessTokenSecret.equals(configurationBase.oAuthAccessTokenSecret) : configurationBase.oAuthAccessTokenSecret != null) {
            return false;
        }
        if (this.oAuthAccessTokenURL != null ? !this.oAuthAccessTokenURL.equals(configurationBase.oAuthAccessTokenURL) : configurationBase.oAuthAccessTokenURL != null) {
            return false;
        }
        if (this.oAuthAuthenticationURL != null ? !this.oAuthAuthenticationURL.equals(configurationBase.oAuthAuthenticationURL) : configurationBase.oAuthAuthenticationURL != null) {
            return false;
        }
        if (this.oAuthAuthorizationURL != null ? !this.oAuthAuthorizationURL.equals(configurationBase.oAuthAuthorizationURL) : configurationBase.oAuthAuthorizationURL != null) {
            return false;
        }
        if (this.oAuthConsumerKey != null ? !this.oAuthConsumerKey.equals(configurationBase.oAuthConsumerKey) : configurationBase.oAuthConsumerKey != null) {
            return false;
        }
        if (this.oAuthConsumerSecret != null ? !this.oAuthConsumerSecret.equals(configurationBase.oAuthConsumerSecret) : configurationBase.oAuthConsumerSecret != null) {
            return false;
        }
        if (this.oAuthRequestTokenURL != null ? !this.oAuthRequestTokenURL.equals(configurationBase.oAuthRequestTokenURL) : configurationBase.oAuthRequestTokenURL != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(configurationBase.password) : configurationBase.password != null) {
            return false;
        }
        if (this.restBaseURL != null ? !this.restBaseURL.equals(configurationBase.restBaseURL) : configurationBase.restBaseURL != null) {
            return false;
        }
        if (this.uploadBaseURL != null ? !this.uploadBaseURL.equals(configurationBase.uploadBaseURL) : configurationBase.uploadBaseURL != null) {
            return false;
        }
        if (this.siteStreamBaseURL != null ? !this.siteStreamBaseURL.equals(configurationBase.siteStreamBaseURL) : configurationBase.siteStreamBaseURL != null) {
            return false;
        }
        if (this.streamBaseURL != null ? !this.streamBaseURL.equals(configurationBase.streamBaseURL) : configurationBase.streamBaseURL != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(configurationBase.user) : configurationBase.user != null) {
            return false;
        }
        return !(this.userStreamBaseURL != null ? !this.userStreamBaseURL.equals(configurationBase.userStreamBaseURL) : configurationBase.userStreamBaseURL != null);
    }

    public int hashCode() {
        int n2 = this.debug ? 1 : 0;
        n2 = 31 * n2 + (this.user != null ? this.user.hashCode() : 0);
        n2 = 31 * n2 + (this.password != null ? this.password.hashCode() : 0);
        n2 = 31 * n2 + (this.httpConf != null ? this.httpConf.hashCode() : 0);
        n2 = 31 * n2 + this.httpStreamingReadTimeout;
        n2 = 31 * n2 + this.httpRetryCount;
        n2 = 31 * n2 + this.httpRetryIntervalSeconds;
        n2 = 31 * n2 + (this.oAuthConsumerKey != null ? this.oAuthConsumerKey.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthConsumerSecret != null ? this.oAuthConsumerSecret.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthAccessToken != null ? this.oAuthAccessToken.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthAccessTokenSecret != null ? this.oAuthAccessTokenSecret.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuth2TokenType != null ? this.oAuth2TokenType.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuth2AccessToken != null ? this.oAuth2AccessToken.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuth2Scope != null ? this.oAuth2Scope.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthRequestTokenURL != null ? this.oAuthRequestTokenURL.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthAuthorizationURL != null ? this.oAuthAuthorizationURL.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthAccessTokenURL != null ? this.oAuthAccessTokenURL.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuthAuthenticationURL != null ? this.oAuthAuthenticationURL.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuth2TokenURL != null ? this.oAuth2TokenURL.hashCode() : 0);
        n2 = 31 * n2 + (this.oAuth2InvalidateTokenURL != null ? this.oAuth2InvalidateTokenURL.hashCode() : 0);
        n2 = 31 * n2 + (this.restBaseURL != null ? this.restBaseURL.hashCode() : 0);
        n2 = 31 * n2 + (this.uploadBaseURL != null ? this.uploadBaseURL.hashCode() : 0);
        n2 = 31 * n2 + (this.streamBaseURL != null ? this.streamBaseURL.hashCode() : 0);
        n2 = 31 * n2 + (this.userStreamBaseURL != null ? this.userStreamBaseURL.hashCode() : 0);
        n2 = 31 * n2 + (this.siteStreamBaseURL != null ? this.siteStreamBaseURL.hashCode() : 0);
        n2 = 31 * n2 + (this.dispatcherImpl != null ? this.dispatcherImpl.hashCode() : 0);
        n2 = 31 * n2 + this.asyncNumThreads;
        n2 = 31 * n2 + (this.loggerFactory != null ? this.loggerFactory.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.contributingTo ^ this.contributingTo >>> 32);
        n2 = 31 * n2 + (this.includeMyRetweetEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.includeEntitiesEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.trimUserEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.jsonStoreEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.mbeanEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.userStreamRepliesAllEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.userStreamWithFollowingsEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.stallWarningsEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.applicationOnlyAuthEnabled ? 1 : 0);
        n2 = 31 * n2 + (this.mediaProvider != null ? this.mediaProvider.hashCode() : 0);
        n2 = 31 * n2 + (this.mediaProviderAPIKey != null ? this.mediaProviderAPIKey.hashCode() : 0);
        n2 = 31 * n2 + (this.mediaProviderParameters != null ? this.mediaProviderParameters.hashCode() : 0);
        n2 = 31 * n2 + (this.daemonEnabled ? 1 : 0);
        return n2;
    }

    public String toString() {
        return "ConfigurationBase{debug=" + this.debug + ", user='" + this.user + '\'' + ", password='" + this.password + '\'' + ", httpConf=" + this.httpConf + ", httpStreamingReadTimeout=" + this.httpStreamingReadTimeout + ", httpRetryCount=" + this.httpRetryCount + ", httpRetryIntervalSeconds=" + this.httpRetryIntervalSeconds + ", oAuthConsumerKey='" + this.oAuthConsumerKey + '\'' + ", oAuthConsumerSecret='" + this.oAuthConsumerSecret + '\'' + ", oAuthAccessToken='" + this.oAuthAccessToken + '\'' + ", oAuthAccessTokenSecret='" + this.oAuthAccessTokenSecret + '\'' + ", oAuth2TokenType='" + this.oAuth2TokenType + '\'' + ", oAuth2AccessToken='" + this.oAuth2AccessToken + '\'' + ", oAuth2Scope='" + this.oAuth2Scope + '\'' + ", oAuthRequestTokenURL='" + this.oAuthRequestTokenURL + '\'' + ", oAuthAuthorizationURL='" + this.oAuthAuthorizationURL + '\'' + ", oAuthAccessTokenURL='" + this.oAuthAccessTokenURL + '\'' + ", oAuthAuthenticationURL='" + this.oAuthAuthenticationURL + '\'' + ", oAuth2TokenURL='" + this.oAuth2TokenURL + '\'' + ", oAuth2InvalidateTokenURL='" + this.oAuth2InvalidateTokenURL + '\'' + ", restBaseURL='" + this.restBaseURL + '\'' + ", uploadBaseURL='" + this.uploadBaseURL + '\'' + ", streamBaseURL='" + this.streamBaseURL + '\'' + ", userStreamBaseURL='" + this.userStreamBaseURL + '\'' + ", siteStreamBaseURL='" + this.siteStreamBaseURL + '\'' + ", dispatcherImpl='" + this.dispatcherImpl + '\'' + ", asyncNumThreads=" + this.asyncNumThreads + ", loggerFactory='" + this.loggerFactory + '\'' + ", contributingTo=" + this.contributingTo + ", includeMyRetweetEnabled=" + this.includeMyRetweetEnabled + ", includeEntitiesEnabled=" + this.includeEntitiesEnabled + ", trimUserEnabled=" + this.trimUserEnabled + ", jsonStoreEnabled=" + this.jsonStoreEnabled + ", mbeanEnabled=" + this.mbeanEnabled + ", userStreamRepliesAllEnabled=" + this.userStreamRepliesAllEnabled + ", userStreamWithFollowingsEnabled=" + this.userStreamWithFollowingsEnabled + ", stallWarningsEnabled=" + this.stallWarningsEnabled + ", applicationOnlyAuthEnabled=" + this.applicationOnlyAuthEnabled + ", mediaProvider='" + this.mediaProvider + '\'' + ", mediaProviderAPIKey='" + this.mediaProviderAPIKey + '\'' + ", mediaProviderParameters=" + this.mediaProviderParameters + ", daemonEnabled=" + this.daemonEnabled + '}';
    }

    private static void cacheInstance(ConfigurationBase configurationBase) {
        if (!instances.contains(configurationBase)) {
            instances.add(configurationBase);
        }
    }

    protected void cacheInstance() {
        ConfigurationBase.cacheInstance(this);
    }

    private static ConfigurationBase getInstance(ConfigurationBase configurationBase) {
        int n2 = instances.indexOf(configurationBase);
        if (n2 == -1) {
            instances.add(configurationBase);
            return configurationBase;
        }
        return instances.get(n2);
    }

    protected Object readResolve() {
        return ConfigurationBase.getInstance(this);
    }

    class MyHttpClientConfiguration
    implements HttpClientConfiguration,
    Serializable {
        private static final long serialVersionUID = 8226866124868861058L;
        private String httpProxyHost = null;
        private String httpProxyUser = null;
        private String httpProxyPassword = null;
        private int httpProxyPort = -1;
        private int httpConnectionTimeout = 20000;
        private int httpReadTimeout = 120000;
        private boolean prettyDebug = false;
        private boolean gzipEnabled = true;

        MyHttpClientConfiguration(String string, String string2, String string3, int n2, int n3, int n4, boolean bl2, boolean bl3) {
            this.httpProxyHost = string;
            this.httpProxyUser = string2;
            this.httpProxyPassword = string3;
            this.httpProxyPort = n2;
            this.httpConnectionTimeout = n3;
            this.httpReadTimeout = n4;
            this.prettyDebug = bl2;
            this.gzipEnabled = bl3;
        }

        public String getHttpProxyHost() {
            return this.httpProxyHost;
        }

        public int getHttpProxyPort() {
            return this.httpProxyPort;
        }

        public String getHttpProxyUser() {
            return this.httpProxyUser;
        }

        public String getHttpProxyPassword() {
            return this.httpProxyPassword;
        }

        public int getHttpConnectionTimeout() {
            return this.httpConnectionTimeout;
        }

        public int getHttpReadTimeout() {
            return this.httpReadTimeout;
        }

        public int getHttpRetryCount() {
            return ConfigurationBase.this.httpRetryCount;
        }

        public int getHttpRetryIntervalSeconds() {
            return ConfigurationBase.this.httpRetryIntervalSeconds;
        }

        public boolean isPrettyDebugEnabled() {
            return this.prettyDebug;
        }

        public boolean isGZIPEnabled() {
            return this.gzipEnabled;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            MyHttpClientConfiguration myHttpClientConfiguration = (MyHttpClientConfiguration)object;
            if (this.gzipEnabled != myHttpClientConfiguration.gzipEnabled) {
                return false;
            }
            if (this.httpConnectionTimeout != myHttpClientConfiguration.httpConnectionTimeout) {
                return false;
            }
            if (this.httpProxyPort != myHttpClientConfiguration.httpProxyPort) {
                return false;
            }
            if (this.httpReadTimeout != myHttpClientConfiguration.httpReadTimeout) {
                return false;
            }
            if (this.prettyDebug != myHttpClientConfiguration.prettyDebug) {
                return false;
            }
            if (this.httpProxyHost != null ? !this.httpProxyHost.equals(myHttpClientConfiguration.httpProxyHost) : myHttpClientConfiguration.httpProxyHost != null) {
                return false;
            }
            if (this.httpProxyPassword != null ? !this.httpProxyPassword.equals(myHttpClientConfiguration.httpProxyPassword) : myHttpClientConfiguration.httpProxyPassword != null) {
                return false;
            }
            return !(this.httpProxyUser != null ? !this.httpProxyUser.equals(myHttpClientConfiguration.httpProxyUser) : myHttpClientConfiguration.httpProxyUser != null);
        }

        public int hashCode() {
            int n2 = this.httpProxyHost != null ? this.httpProxyHost.hashCode() : 0;
            n2 = 31 * n2 + (this.httpProxyUser != null ? this.httpProxyUser.hashCode() : 0);
            n2 = 31 * n2 + (this.httpProxyPassword != null ? this.httpProxyPassword.hashCode() : 0);
            n2 = 31 * n2 + this.httpProxyPort;
            n2 = 31 * n2 + this.httpConnectionTimeout;
            n2 = 31 * n2 + this.httpReadTimeout;
            n2 = 31 * n2 + (this.prettyDebug ? 1 : 0);
            n2 = 31 * n2 + (this.gzipEnabled ? 1 : 0);
            return n2;
        }

        public String toString() {
            return "MyHttpClientConfiguration{httpProxyHost='" + this.httpProxyHost + '\'' + ", httpProxyUser='" + this.httpProxyUser + '\'' + ", httpProxyPassword='" + this.httpProxyPassword + '\'' + ", httpProxyPort=" + this.httpProxyPort + ", httpConnectionTimeout=" + this.httpConnectionTimeout + ", httpReadTimeout=" + this.httpReadTimeout + ", prettyDebug=" + this.prettyDebug + ", gzipEnabled=" + this.gzipEnabled + '}';
        }
    }
}

