/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.Twitter;
import be.maximvdw.featherboardcore.twitter.auth.AccessToken;
import be.maximvdw.featherboardcore.twitter.auth.Authorization;
import be.maximvdw.featherboardcore.twitter.auth.AuthorizationFactory;
import be.maximvdw.featherboardcore.twitter.auth.OAuthAuthorization;
import be.maximvdw.featherboardcore.twitter.conf.Configuration;
import be.maximvdw.featherboardcore.twitter.conf.ConfigurationContext;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class TwitterFactory
implements Serializable {
    private static final Constructor<Twitter> TWITTER_CONSTRUCTOR;
    static final Authorization DEFAULT_AUTHORIZATION;
    private static final Twitter SINGLETON;
    private static final long serialVersionUID = -563983536986910054L;
    private final Configuration conf;

    public TwitterFactory() {
        this(ConfigurationContext.getInstance());
    }

    public TwitterFactory(Configuration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration cannot be null");
        }
        this.conf = configuration;
    }

    public TwitterFactory(String string) {
        this(ConfigurationContext.getInstance(string));
    }

    public Twitter getInstance() {
        return this.getInstance(AuthorizationFactory.getInstance(this.conf));
    }

    public Twitter getInstance(AccessToken accessToken) {
        String string = this.conf.getOAuthConsumerKey();
        String string2 = this.conf.getOAuthConsumerSecret();
        if (null == string && null == string2) {
            throw new IllegalStateException("Consumer key and Consumer secret not supplied.");
        }
        OAuthAuthorization oAuthAuthorization = new OAuthAuthorization(this.conf);
        oAuthAuthorization.setOAuthAccessToken(accessToken);
        return this.getInstance(oAuthAuthorization);
    }

    public Twitter getInstance(Authorization authorization) {
        try {
            return TWITTER_CONSTRUCTOR.newInstance(this.conf, authorization);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }

    public static Twitter getSingleton() {
        return SINGLETON;
    }

    static {
        Object object;
        boolean bl2;
        DEFAULT_AUTHORIZATION = AuthorizationFactory.getInstance(ConfigurationContext.getInstance());
        try {
            Class.forName("com.google.appengine.api.urlfetch.URLFetchService");
            bl2 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl2 = false;
        }
        String string = null;
        if (bl2) {
            object = "be.maximvdw.featherboardcore.twitter.AppEngineTwitterImpl";
            try {
                Class.forName("be.maximvdw.featherboardcore.twitter.AppEngineTwitterImpl");
                string = "be.maximvdw.featherboardcore.twitter.AppEngineTwitterImpl";
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = "be.maximvdw.featherboardcore.twitter.TwitterImpl";
        }
        try {
            Class<?> clazz = Class.forName(string);
            object = clazz.getDeclaredConstructor(Configuration.class, Authorization.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
        TWITTER_CONSTRUCTOR = object;
        try {
            SINGLETON = TWITTER_CONSTRUCTOR.newInstance(ConfigurationContext.getInstance(), DEFAULT_AUTHORIZATION);
        }
        catch (InstantiationException instantiationException) {
            throw new AssertionError((Object)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new AssertionError((Object)invocationTargetException);
        }
    }
}

