/*
 * Decompiled with CFR 0.152.
 */
package be.maximvdw.featherboardcore.twitter;

import be.maximvdw.featherboardcore.twitter.GeoLocation;
import be.maximvdw.featherboardcore.twitter.HttpParameter;
import be.maximvdw.featherboardcore.twitter.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatusUpdate
implements Serializable {
    private static final long serialVersionUID = 7422094739799350035L;
    private final String status;
    private long inReplyToStatusId = -1L;
    private GeoLocation location = null;
    private String placeId = null;
    private boolean displayCoordinates = true;
    private boolean possiblySensitive;
    private String mediaName;
    private transient InputStream mediaBody;
    private File mediaFile;
    private long[] mediaIds;

    public StatusUpdate(String string) {
        this.status = string;
    }

    public String getStatus() {
        return this.status;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public void setInReplyToStatusId(long l2) {
        this.inReplyToStatusId = l2;
    }

    public StatusUpdate inReplyToStatusId(long l2) {
        this.setInReplyToStatusId(l2);
        return this;
    }

    public GeoLocation getLocation() {
        return this.location;
    }

    public void setLocation(GeoLocation geoLocation) {
        this.location = geoLocation;
    }

    public StatusUpdate location(GeoLocation geoLocation) {
        this.setLocation(geoLocation);
        return this;
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public void setPlaceId(String string) {
        this.placeId = string;
    }

    public StatusUpdate placeId(String string) {
        this.setPlaceId(string);
        return this;
    }

    public boolean isDisplayCoordinates() {
        return this.displayCoordinates;
    }

    public void setDisplayCoordinates(boolean bl2) {
        this.displayCoordinates = bl2;
    }

    public StatusUpdate displayCoordinates(boolean bl2) {
        this.setDisplayCoordinates(bl2);
        return this;
    }

    public void setMedia(File file) {
        this.mediaFile = file;
    }

    public StatusUpdate media(File file) {
        this.setMedia(file);
        return this;
    }

    public void setMedia(String string, InputStream inputStream) {
        this.mediaName = string;
        this.mediaBody = inputStream;
    }

    public void setMediaIds(long[] lArray) {
        this.mediaIds = lArray;
    }

    boolean isForUpdateWithMedia() {
        return this.mediaFile != null || this.mediaName != null;
    }

    public StatusUpdate media(String string, InputStream inputStream) {
        this.setMedia(string, inputStream);
        return this;
    }

    public void setPossiblySensitive(boolean bl2) {
        this.possiblySensitive = bl2;
    }

    public StatusUpdate possiblySensitive(boolean bl2) {
        this.setPossiblySensitive(bl2);
        return this;
    }

    public boolean isPossiblySensitive() {
        return this.possiblySensitive;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> arrayList = new ArrayList<HttpParameter>();
        this.appendParameter("status", this.status, arrayList);
        if (-1L != this.inReplyToStatusId) {
            this.appendParameter("in_reply_to_status_id", this.inReplyToStatusId, (List<HttpParameter>)arrayList);
        }
        if (this.location != null) {
            this.appendParameter("lat", this.location.getLatitude(), arrayList);
            this.appendParameter("long", this.location.getLongitude(), arrayList);
        }
        this.appendParameter("place_id", this.placeId, arrayList);
        if (!this.displayCoordinates) {
            this.appendParameter("display_coordinates", "false", arrayList);
        }
        if (null != this.mediaFile) {
            arrayList.add(new HttpParameter("media[]", this.mediaFile));
            arrayList.add(new HttpParameter("possibly_sensitive", this.possiblySensitive));
        } else if (this.mediaName != null && this.mediaBody != null) {
            arrayList.add(new HttpParameter("media[]", this.mediaName, this.mediaBody));
            arrayList.add(new HttpParameter("possibly_sensitive", this.possiblySensitive));
        } else if (this.mediaIds != null && this.mediaIds.length >= 1) {
            arrayList.add(new HttpParameter("media_ids", StringUtil.join(this.mediaIds)));
        }
        HttpParameter[] httpParameterArray = new HttpParameter[arrayList.size()];
        return arrayList.toArray(httpParameterArray);
    }

    private void appendParameter(String string, String string2, List<HttpParameter> list) {
        if (string2 != null) {
            list.add(new HttpParameter(string, string2));
        }
    }

    private void appendParameter(String string, double d2, List<HttpParameter> list) {
        list.add(new HttpParameter(string, String.valueOf(d2)));
    }

    private void appendParameter(String string, long l2, List<HttpParameter> list) {
        list.add(new HttpParameter(string, String.valueOf(l2)));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StatusUpdate statusUpdate = (StatusUpdate)object;
        if (this.displayCoordinates != statusUpdate.displayCoordinates) {
            return false;
        }
        if (this.inReplyToStatusId != statusUpdate.inReplyToStatusId) {
            return false;
        }
        if (this.possiblySensitive != statusUpdate.possiblySensitive) {
            return false;
        }
        if (this.location != null ? !this.location.equals(statusUpdate.location) : statusUpdate.location != null) {
            return false;
        }
        if (this.mediaBody != null ? !this.mediaBody.equals(statusUpdate.mediaBody) : statusUpdate.mediaBody != null) {
            return false;
        }
        if (this.mediaFile != null ? !this.mediaFile.equals(statusUpdate.mediaFile) : statusUpdate.mediaFile != null) {
            return false;
        }
        if (this.mediaName != null ? !this.mediaName.equals(statusUpdate.mediaName) : statusUpdate.mediaName != null) {
            return false;
        }
        if (this.mediaIds != null ? !Arrays.equals(this.mediaIds, statusUpdate.mediaIds) : statusUpdate.mediaIds != null) {
            return false;
        }
        if (this.placeId != null ? !this.placeId.equals(statusUpdate.placeId) : statusUpdate.placeId != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(statusUpdate.status) : statusUpdate.status != null);
    }

    public int hashCode() {
        int n2 = this.status != null ? this.status.hashCode() : 0;
        n2 = 31 * n2 + (int)(this.inReplyToStatusId ^ this.inReplyToStatusId >>> 32);
        n2 = 31 * n2 + (this.location != null ? this.location.hashCode() : 0);
        n2 = 31 * n2 + (this.placeId != null ? this.placeId.hashCode() : 0);
        n2 = 31 * n2 + (this.displayCoordinates ? 1 : 0);
        n2 = 31 * n2 + (this.possiblySensitive ? 1 : 0);
        n2 = 31 * n2 + (this.mediaName != null ? this.mediaName.hashCode() : 0);
        n2 = 31 * n2 + (this.mediaBody != null ? this.mediaBody.hashCode() : 0);
        n2 = 31 * n2 + (this.mediaFile != null ? this.mediaFile.hashCode() : 0);
        n2 = 31 * n2 + (this.mediaIds != null ? StringUtil.join(this.mediaIds).hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "StatusUpdate{status='" + this.status + '\'' + ", inReplyToStatusId=" + this.inReplyToStatusId + ", location=" + this.location + ", placeId='" + this.placeId + '\'' + ", displayCoordinates=" + this.displayCoordinates + ", possiblySensitive=" + this.possiblySensitive + ", mediaName='" + this.mediaName + '\'' + ", mediaBody=" + this.mediaBody + ", mediaFile=" + this.mediaFile + ", mediaIds=" + this.mediaIds + '}';
    }
}

